class FeaturedList {
    static get toolbox() {
        return {
            title: 'Features',
            icon: '<i class="fas fa-stars"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, title: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Features Section<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Features</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control wsinput" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">Default</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="bg-primary">Primary</option>
					</select>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bgsbgcolor" class="form-control bgsbgcolor" value="" />
							<span onclick="PageGraphics('${this.data.id}-bgsbgcolor')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				</div>
				<div class="sborderinput">
					<div class="form-group">
						<label>Border</label>
						<select type="select" class="form-control blockborders">
							<option value="">None</option>
							<option value="border-top">Top Border</option>
							<option value="border-bottom">Bottom Border</option>
						</select>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Features Type</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Style</label>
					<select type="select" class="form-control featureblockstyles">
						<option value="">Style 1</option>
						<option value="1">Style 2</option>
						<option value="2">Style 3</option>
						<option value="3">Style 4</option>
					</select>
				</div>
				<div class="listitemcount">
				   <div class="form-group">
					  <label>list count</label>
					  <input type="text" class="form-control laitems" value="" />
				   </div>
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>		
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Features Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Item Title</label>
					<input type="text" class="form-control feature_title">
				</div>
				<div class="form-group">
					<label>Item Description</label>
					<textarea type="text" type="text" rows="7" class="form-control feature_description"></textarea>
				</div>
				<div class="form-group">
					<label>Graphic</label>
					<input type="medialib" class="form-control feature_graphic">
				</div>
				<div class="small">
				   <ul class="text-muted" style="margin-bottom: 0;">
					  <li>The minimum image size is 100px by 100px, and the accepted ratio should be square.</li>
					  <li>In icon, you can use supported classes (<code>text-primary, text-danger, text-warning, text-info</code>), i.e. <code>fas fa-rocket text-primary</code>.</li>
				   </ul>
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
		const title = this.data && this.data.title ? this.data.title : "";
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        const featureblockstyles = this.data && this.data.blocklistStyle ? this.data.blocklistStyle : "";
        $(wrapper).find(".featureblockstyles").val(featureblockstyles);
        const vvimage = this.data && this.data.image ? this.data.image : "";
        $(wrapper).find(".bgsbgcolor").val(vvimage);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
		//
        if ($(wrapper).find('.blockbgcolor').val() !== '') {
			$(wrapper).find('.simginput').addClass('hidden');
        } else {
            $(wrapper).find('.simginput').removeClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() !== '') {
                $(wrapper).find('.simginput').addClass('hidden');
            } else {
                $(wrapper).find('.simginput').removeClass('hidden');
            }
        });
		//
		
		//
        if ($(wrapper).find('.featureblockstyles').val() == '1') {
			$(wrapper).find('.listitemcount').addClass('hidden');
        } else {
            $(wrapper).find('.listitemcount').removeClass('hidden');
        }
        $(wrapper).find('.featureblockstyles').on('change', function () {
            if ($(wrapper).find('.featureblockstyles').val() == '1') {
                $(wrapper).find('.listitemcount').addClass('hidden');
            } else {
                $(wrapper).find('.listitemcount').removeClass('hidden');
            }
        });
		//
		
		//
        if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the feature <b> \"" + args.item.title + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var features = item;
				var iconElement = "";
				if (features.icon) {
					if (features.icon.includes("fa-")) {
						iconElement = "<span class='fa-fw " + features.icon + "'></span>";
					} else {
						iconElement = "<img src='" + whmcsBaseUrl + "/" + features.icon + "' class='thumbnail_placeholder feature_icon'>";
					}
				}
				var $config = $("<div>").addClass("panel panel-default")
                .append($("<div class='panel-heading'><h3 class='panel-title'>").html(iconElement + " " + features.title))
				.append($("<div class='panel-body'>").html("" + features.description));
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block custom-grid jsgrid-align-left").attr("width", "400px").append($config))
					.append($cButtons);
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{name: "title", title: "Features", type: "text", width: 400, validate: "required"},
				{name: "description", title: "Description", type: "textarea", visible: false, sorting: false, validate: "required"},
                {name: "icon", title: "Graphic", type: "text", visible: false, sorting: false, validate: "required"},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, features, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "feature_new_" : "feature_" + itemIndex;
			
			if (isNew) {
				features = {
					title: '',
					description: '',
					icon: ''
				};
			}

			$(wrapper).find('input[type="medialib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageMedia(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Graphic"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageMedia('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".feature_title").val(features.title);;
            $(wrapper).find(".feature_graphic").val(features.icon);
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $featuresDescription = $('#' + modalId).find('.feature_description');

				if (!$featuresDescription.next('.trumbowyg-box ').length) {
					$featuresDescription.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$featuresDescription.trumbowyg('html', features.description);
			});
			
            formSubmitHandler = function () {
                saveFeatures(features, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .feature_title").val() === '') {
				alert('Title is required.');
				e.preventDefault();
			} else if ($(".ce-block--focused .feature_description").val() === "") {
				alert('Description is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
		
        var saveFeatures = function (features, isNew) {
            $.extend(features, {
				title: $(wrapper).find(".feature_title").val(),
				description: $(wrapper).find(".feature_description").val(),
				icon: $(wrapper).find(".feature_graphic").val()
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", features);
            $(wrapper).find(".modal").modal('hide');
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "title": $(blockContent).find(".wsinput").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "image": $(blockContent).find(".bgsbgcolor").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
            "blocklistStyle": $(blockContent).find(".featureblockstyles").val(),
			"sechidden": sechidden
        };
    }
}