class ImageGallery {
    static get toolbox() {
        return {
            title: 'Image Gallery',
            icon: '<i class="fas fa-images"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, title: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Image Gallery<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Gallery</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Description</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
				   <label>Title</label>
				   <input type="text" class="form-control wsinput" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">Default</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="bg-primary">Primary</option>
					</select>
				</div>
				 <div class="simginput">					 
					 <div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-blockbgimg" class="form-control blockbgimg" value="" />
							<span onclick="PageGraphics('${this.data.id}-blockbgimg')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				</div>
				<div class="sborderinput">
					<div class="form-group">
						<label>Border</label>
						<select type="select" class="form-control blockborders">
							<option value="">None</option>
							<option value="border-top">Top Border</option>
							<option value="border-bottom">Bottom Border</option>
						</select>
					</div>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Gallery Type</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Type</label>
							<select type="select" class="form-control blockstyle">
								 <option value="">Slider</option>
								 <option value="1">Grid</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">			
						<div class="form-group">
							<label>list count</label>
							<input type="text" class="form-control laitems" value="" />
						</div>
					</div>
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit gallery item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Image</label>
					<input type="imagelib" class="form-control thumbnail" style="margin-bottom: 0;">
				</div>
				<div class="form-group">
					<label>Image Alt Tag</label>
					<input type="text" class="form-control alttag">
				</div>
				<div class="form-group">
					<label>Image Caption/Description</label>
					<input type="text" class="form-control caption">
				</div>
                <div class="form-group">
					<div class="flex-checkbox">
					<span class="control-label">Enable this option to display a zoom icon when hovering over the image.</span>
                      <label class="switch">
					    <input type="checkbox" class="success zoomin">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
				<div class="form-group zoominput">
					<input type="imagelib" class="form-control fullImage">
					<span class="help-block">This is an optional field. Use it to display an alternative image instead of the main image when zoomed in.</span>
				</div>
				<div class="form-group">
					<label>Link Type</label>
					<select type="select" class="form-control linktype">
						<option value="">Custom URL</option>
						<option value="1">Page Manager</option>
						<option value="2">Product Group</option>
						<option value="3">Product</option>
					</select>
				</div>
				<div class="curl">
					<div class="form-group">
						<label>Link To</label>
						<input type="text" class="form-control bsblink" placeholder="add custom URL..">
					</div>
				</div>
				<div class="purl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control pagelink">${cmsPages}</select>
					</div>
				</div>
				<div class="gurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control grouplink">${groupSelect}</select>
					</div>
				</div>
				<div class="pdurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control productlink">${productsSelect}</select>
					</div>
				</div>				
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);
		const title = this.data && this.data.title ? this.data.title : "";
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockstyle = this.data && this.data.bstyle ? this.data.bstyle : "";
        $(wrapper).find(".blockstyle").val(blockstyle);
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const blocktheight = this.data && this.data.btheight ? this.data.btheight : "";
        $(wrapper).find(".blocktheight").val(blocktheight);
        const blockbheight = this.data && this.data.bbheight ? this.data.bbheight : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
        const blockbgimg = this.data && this.data.sbimg ? this.data.sbimg : "";
        $(wrapper).find(".blockbgimg").val(blockbgimg);
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
        //
        if ($(wrapper).find('.blockbgcolor').val() !== '') {
            $(wrapper).find('.simginput').addClass('hidden');
        } else {
            $(wrapper).find('.simginput').removeClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() !== '') {
                $(wrapper).find('.simginput').addClass('hidden');
            } else {
                $(wrapper).find('.simginput').removeClass('hidden');
            }
        });
        //
		
		//
        if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//

        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the below item from this section?<br> <img src=\"" + args.item.Thumbnail + "\" class=\"thumbnail_placeholder_alert\">",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{
					name: "Thumbnail",
					title: "Gallery",
					type: "text",
					width: 400,
					align: "left",
					css: "grid-info-block",		  
					itemTemplate: function(value, item) {
					  var $thumbnail = $("<div>").addClass("");
					  var $image = $("<img>").attr("src", value).addClass("thumbnail_placeholder");
					  
					  // Handle image load error
					  $image.on("error", function() {
						$(this).replaceWith('<span class="fas fa-image fa-3x fa-fw"></span>');
					  });
					  
					  var $preview = $("<div>").addClass("").append($image);
					  $thumbnail.append($preview);
					  
					  return $thumbnail;
					}
				},
                {name: "Caption", title: "Caption/Description", type: "textarea", width: 100, visible: false, sorting: false},
                {name: "FullImage", title: "Full Image", type: "text", width: 200, visible: false, sorting: false},
				{name: "AltTag", title: "Link", type: "text", width: 100, visible: false, sorting: false},
				{name: "Zooming", type: "checkbox", title: "Zoom", visible: false, sorting: false},
                {type: "control", editButton: false, width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, gallery, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "gallery_new_" : "gallery_" + itemIndex;
			
			if (isNew) {
				gallery = {
					Zooming: 0,
					Caption: '',
					Thumbnail: '',
					FullImage: '',
					alttag: '',
					LinkType: '',
					Link: ''
				};
			}		

			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".caption").val(gallery.Caption);
            $(wrapper).find(".thumbnail").val(gallery.Thumbnail);
            $(wrapper).find(".fullImage").val(gallery.FullImage);
			$(wrapper).find(".linktype").val(gallery.LinkType);
			$(wrapper).find(".alttag").val(gallery.AltTag);
			$(wrapper).find(".zoomin").prop('checked', gallery.Zooming ? true : false);

			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
				{ selector: ".productlink", placeholder: 'Select a product' },
				{ selector: ".grouplink", placeholder: 'Select a products group' },
				{ selector: ".groupprice", placeholder: 'Select a product or group' }
			];

			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});

			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".bsblink").val(gallery.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".grouplink").val('');
						break;
					case '2':
						$(wrapper).find(".grouplink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					case '3':
						$(wrapper).find(".productlink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".grouplink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					default:
						$(wrapper).find(".bsblink").val(gallery.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//gallery.LinkType = $(this).val();
				updateLinkFields();
			});
			
			if ($(wrapper).find('.zoomin').is(':checked')) {
				$(wrapper).find('.zoominput').removeClass('hidden');
			} else {
				$(wrapper).find('.zoominput').addClass('hidden');
			}
			$(wrapper).find('.zoomin').change(function() {
			  if ($(this).is(':checked')) {
				$(wrapper).find('.zoominput').removeClass('hidden');
			  } else {
				$(wrapper).find('.zoominput').addClass('hidden');
			  }
			});
			
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl'),
					pdurl: $(wrapper).find('.pdurl'),
					gurl: $(wrapper).find('.gurl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
					case '2':
						LinkInputs.gurl.removeClass('hidden');
						break;
					case '3':
						LinkInputs.pdurl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);
			
            formSubmitHandler = function () {
                saveGallery(gallery, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .thumbnail").val() === '') {
				alert('Image is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
		
        var saveGallery = function (gallery, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".bsblink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				case '2':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '3':
					linkValue = $(wrapper).find(".productlink").val();
					break;
				default:
					linkValue = $(wrapper).find(".bsblink").val();
					break;
			}
			$.extend(gallery, {			
				Thumbnail: $(wrapper).find(".thumbnail").val(),
                FullImage: $(wrapper).find(".fullImage").val(),
                Caption: $(wrapper).find(".caption").val(),
				LinkType: $(wrapper).find(".linktype").val(),
				AltTag: $(wrapper).find(".alttag").val(),
				Link: linkValue,
				Zooming: $(wrapper).find(".zoomin").is(':checked')
            });
			
			$(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", gallery);
            $(wrapper).find(".modal").modal('hide');
        };
		
        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });		
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);
        return wrapper;
    }
    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "title": $(blockContent).find(".wsinput").val(),
			"subtitle": subtitle,
            "bstyle": $(blockContent).find(".blockstyle").val(),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "btheight": $(blockContent).find(".blocktheight").val(),
            "bbheight": $(blockContent).find(".blockbheight").val(),
            "sbimg": $(blockContent).find(".blockbgimg").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
			"sechidden": sechidden
        };
    }
}