class TeamList {
    static get toolbox() {
        return {
            title: 'Team Members',
            icon: '<i class="fas fa-list"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }    
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Team Members<a class="sec-docs" href="https://docs.thememetro.com/#Sec-TeamMembers" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control wsinput" value=""/>
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>					
			</div>			
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
					</select>
				</div>
				<div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					</select>
				</div>
			</div>
			<div class="heading">
				<h5>List Type</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
						   <label>Type</label>					
						   <select type="select" class="form-control blockliststyle">
							 <option value="">Slider</option>
							 <option value="1">Grid</option>
						   </select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>list count</label>
							<input type="text" class="form-control laitems" value="" />
						</div>
					</div>
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>
<div class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Member</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Name</label>
					<input type="text" class="form-control name">
				</div>
				<div class="form-group">
					<label>Designation</label>
					<input type="text" class="form-control designation">
				</div>
				<div class="form-group">
					<label>Profile Image</label>
					<input type="imagelib" class="form-control photograph">
				</div>
				<hr />
				<h5><strong>Social Media Profile Links</strong> <small>(Optional)</small></h5>
				<hr />
				<div class="form-group">
					<label>Facebook</label>
					<input type="text" class="form-control facebook">
				</div>
				<div class="form-group">
					<label>Twitter</label>
					<input type="text" class="form-control twitter">
				</div>
				<div class="form-group">
					<label>Linkedin</label>
					<input type="text" class="form-control linkedin">
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
		const title = this.data && this.data.title ? this.data.title : "";
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
		const image = this.data && this.data.image ? this.data.image : "";		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);		
        const blockliststyle = this.data && this.data.liststyle ? this.data.liststyle : "";
        $(wrapper).find(".blockliststyle").val(blockliststyle);	
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "4";
        $(wrapper).find(".laitems").val(laitems);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the member <b> \"" + args.item.Name + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Name", title: "Team", type: "text", width: 400, align: "left", css: "grid-info-block"},
                {name: "Designation", type: "text", visible: false, sorting: false},
                {name: "Facebook", type: "text", visible: false, sorting: false},
                {name: "Twitter", type: "text", visible: false, sorting: false},
                {name: "Linkedin", type: "text", visible: false, sorting: false},
                {name: "Image", type: "text", visible: false, sorting: false},
                {type: "control", editButton: false, width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                            .addClass(cls)
                            .attr({
                                type: "button",
                                title: tooltip
                            })
                            .on("click", function (e) {
                                // clickHandler(grid, e);
                                showDetailsDialog("Add", {});
                            });
                    },

                    editValue: function () {
                        return "";
                    }
                }
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, team, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "team_new_" : "team_" + itemIndex;

			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".name").val(team.Name);
            $(wrapper).find(".designation").val(team.Designation);
            $(wrapper).find(".facebook").val(team.Facebook);
			$(wrapper).find(".twitter").val(team.Twitter);
			$(wrapper).find(".linkedin").val(team.Linkedin);
			$(wrapper).find(".photograph").val(team.Image);
		
            formSubmitHandler = function () {
                saveTeam(team, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .name").val() === '') {
				alert('Name is required.');
				e.preventDefault();
			} else if ($(".ce-block--focused .photograph").val() === "") {
				alert('Photograph is required.');
				e.preventDefault();
			} else if ($(".ce-block--focused .designation").val() === "") {
				alert('Designation is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
		
        var saveTeam = function (team, isNew) {
            const updatedTeam = {
				Name: $(wrapper).find(".name").val(),
                Designation: $(wrapper).find(".designation").val(),
                Image: $(wrapper).find(".photograph").val(),
				Facebook: $(wrapper).find(".facebook").val(),
				Twitter: $(wrapper).find(".twitter").val(),
				Linkedin: $(wrapper).find(".linkedin").val()
            };

            if (isNew) $(wrapper).find(".vjsGrid").jsGrid("insertItem", updatedTeam);
            else $(wrapper).find(".vjsGrid").jsGrid("updateItem", team, updatedTeam);

            $(wrapper).find(".modal").modal('hide');
        };
		
        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });			
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);          
        return wrapper;
    }
	
    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "title": $(blockContent).find(".wsinput").val(),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "liststyle": $(blockContent).find(".blockliststyle").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
            "borders": $(blockContent).find(".blockborders").val(),
			"subtitle": subtitle,
			"sechidden": sechidden
        };
    }
}