class banner_domain {
    static get toolbox() {
        return {
            title: 'Banner Domain',
            icon: '<i class="fas fa-search"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            },			
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Banner Domain<a class="sec-docs" href="https://docs.thememetro.com/#Sec-BannerDomain" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="sec_groups">
			   <div class="form-group">
					<label>Banner Type</label>
					<select type="select" class="form-control bannertype">
						<option value="">Type 1 - Two-column banner with left or right-aligned graphics</option>
						<option value="1">Type 2 - Centered single column without graphics</option>
						<option value="2">Type 3 - Compact without background or graphics</option>
					</select>
			   </div>
			</div>		
			<div class="noCompact">
				<div class="heading">
					<h5>Section Descriptions</h5>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<label>Caption</label>
						<input type="text" class="form-control sectioncaption" value="" />
					</div>			
					<div class="form-group">
						<label>Title</label>
						<input type="text" class="form-control sectiontitle" value="" />
					</div>
					<div class="form-group">
						<label>Subitle</label>
						<textarea class="form-control sectionsubtitle" rows="6"></textarea>
					</div>				
				</div>			
				<div class="grpahicpanel">			
					<div class="heading">
						<h5>Section Graphic</h5>
					</div>
					<div class="sec_groups">
						<div class="form-group">
							<label>Graphic</label>
							<div class="input-group">
								<input type="text" id="${this.data.id}-secgraphic" class="form-control secgraphic" value="" />
								<span onclick="PageGraphics('${this.data.id}-secgraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Graphic"><i class="fas fa-images"></i></span>
							</div>
						</div>
					   <div class="form-group">
							<label>Graphic Position</label>
							<select type="select" class="form-control graphicposition">
								<option value="">Right</option>
								<option value="1">Left</option>
							</select>
					   </div>
					</div>
				</div>			
				<div class="heading">
					<h5>Section Background</h5>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<label>Background Type</label>
						<select type="select" class="form-control blockbgcolor">
							<option value="">None</option>
							<option value="bg-primary">Primary</option>
							<option value="dark">Dark</option>
							<option value="light">Light</option>
							<option value="graphics">Graphic</option>									
						</select>
					</div>
					<div class="simginput">
					   <div class="form-group">
						<label>Graphic</label>
							<div class="input-group">
								<input type="text" id="${this.data.id}-bggraphic" class="form-control bggraphic" value="" />
								<span onclick="PageGraphics('${this.data.id}-bggraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Graphic"><i class="fas fa-images"></i></span>
							</div>
					   </div>
					   <div class="row">
					     <div class="col-sm-6">
						   <div class="form-group">
						    <label>Opacity</label>
						     <select type="select" class="form-control bgopacity">
							  <option value="">Dark</option>
							  <option value="1">Light</option>
							  <option value="2">None</option>
						     </select>
						   </div>
					     </div>
					     <div class="col-sm-6">
						   <div class="form-group">
						    <label>Text Color</label>
						     <select type="select" class="form-control textcolor">
							   <option value="">Light</option>
							    <option value="text-dark">Dark</option>
						     </select>
						   </div>
					     </div>					   
					   </div>				   
					</div>
				</div>
			</div>
			<div class="sborderinput">
				<div class="heading">
					<h5>Section Border & Spacing</h5>
				</div>
				<div class="sec_groups">			
				  <div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				  </div>
				  <div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				  </div>			  
				</div>
			</div>
			<div class="heading">
				<h5>Section Domain From</h5>
			</div>
			<div class="sec_groups">
			   <div class="form-group">
					<label>Field Type</label>
					<select type="select" class="form-control formtype">
						<option value="">Domain Search</option>
						<option value="1">Domain Transfer</option>
						<option value="2">Domain Search & Transfer</option>
					</select>
			   </div>
			</div>
			<div style="margin: 10px 0;">
				<div class="vjsGrid"></div>
			</div>
			<div class="noCompact">
				<div class="sec_groups">
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">Overlay section below on this screen.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success secoverlay" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>
				</div>
			</div>			
		</div>
	</div>
</div>
<div class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit TLD</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Select TLD </label><select type="select" class="form-control tlds">${tldSelect}</select>
                </div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
		const bannertype = this.data && this.data.type ? this.data.type : "";
        $(wrapper).find(".bannertype").val(bannertype);		
		const formtype = this.data && this.data.formtype ? this.data.formtype : "";
        $(wrapper).find(".formtype").val(formtype);
		const bggraphic = this.data && this.data.bggraphic ? this.data.bggraphic : "";
        $(wrapper).find(".bggraphic").val(bggraphic);
		const bgopacity = this.data && this.data.bgopacity ? this.data.bgopacity : "";
        $(wrapper).find(".bgopacity").val(bgopacity);
		const textcolor = this.data && this.data.textcolor ? this.data.textcolor : "";
        $(wrapper).find(".textcolor").val(textcolor);
		const secgraphic = this.data && this.data.graphic ? this.data.graphic : "";
        $(wrapper).find(".secgraphic").val(secgraphic);		
		const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);		
		const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
		const graphicposition = this.data && this.data.graphicposition ? this.data.graphicposition : "";
        $(wrapper).find(".graphicposition").val(graphicposition);

		if (this.data.SecOverlay === true) {
            $(wrapper).find('.secoverlay').attr('checked', 'checked');
        }		
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		//
		function secOptions(wrapper, selector, condition) {
			$(wrapper).find(selector).toggleClass('hidden', !condition);
		}
		
		secOptions(wrapper, '.simginput', $(wrapper).find('.blockbgcolor').val() === 'graphics');
		secOptions(wrapper, '.grpahicpanel', $(wrapper).find('.bannertype').val() !== '1');
		secOptions(wrapper, '.noCompact', $(wrapper).find('.bannertype').val() !== '2');

		$(wrapper).find('.blockbgcolor').on('change', function () {
			secOptions(wrapper, '.simginput', $(this).val() === 'graphics');
		});

		$(wrapper).find('.bannertype').on('change', function () {
			secOptions(wrapper, '.grpahicpanel', $(this).val() !== '1');
			secOptions(wrapper, '.noCompact', $(this).val() !== '2');
		});
		//		
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the TLD <b> \"" + args.item.tld + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "tld", title: "TLDs", type: "select", width: 400, items: bycdomains, valueField: "extension", textField: "extension", align: "left", css: "grid-info-block"},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false, width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, tlds, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "tld_new_" : "tld_" + itemIndex;

			if (isNew) {
				tlds = {				
					tld: '',
					logo: ''
				};
			}
			
            $(wrapper).find(".tlds").val(tlds.tld);
			$(wrapper).find(".tlds").select2().trigger("change");
		
            formSubmitHandler = function () {
                saveTlds(tlds, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .tlds").prop("selectedIndex") === -1) {
			  alert('Please select a tld from the list.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var saveTlds = function (tlds, isNew) {
            $.extend(tlds, {
                tld: $(wrapper).find(".tlds").val(),
				
            });
			
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", tlds);			
            $(wrapper).find(".modal").modal('hide');
        };
		
        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });		
		
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var SecOverlay = $(blockContent).find(".secoverlay").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
			"subtitle": subtitle,
            "graphic": $(blockContent).find(".secgraphic").val(),			
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
			"graphicposition": $(blockContent).find(".graphicposition").val(),
			"bggraphic": $(blockContent).find(".bggraphic").val(),
			"bgopacity": $(blockContent).find(".bgopacity").val(),
			"textcolor": $(blockContent).find(".textcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),
            "type": $(blockContent).find(".bannertype").val(),
            "formtype": $(blockContent).find(".formtype").val(),
			"SecOverlay": SecOverlay,
			"sechidden": sechidden
        };
    }
}