{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


<form method="post" action="{$smarty.server.PHP_SELF}?action=bulkdomain">
	<input type="hidden" name="update" value="{$update}">
	<input type="hidden" name="save" value="1">
	{foreach $domainids as $domainid}
		<input type="hidden" name="domids[]" value="{$domainid}" />
	{/foreach}

	{if $update eq "nameservers"}
		{if $save}
			{if $errors}
			<div class="alert alert-danger">
				<p class="bold">{lang key='clientareaerrors'}</p>
				<ul>
				{foreach $errors as $error}
					<li>{$error}</li>
				{/foreach}
				</ul>
			</div>
			{else}
			<div class="alert alert-success">
				{lang key='changessavedsuccessfully'}
			</div>
			{/if}
		{/if}
		<p>{lang key='domainbulkmanagementchangesaffect'}</p>
		<ul class="list-group mb-5">
			{foreach $domains as $domain}
				<li class="list-group-item"><i class="fad fa-check-square mr-2"></i>{$domain}</li>
			{/foreach}
		</ul>
		<div class="form-group px-3 py-2 border mb-1 bg-light rounded">
			<label for="nsChoiceDefault" class="m-0">
			<input id="nsChoiceDefault" type="radio" class="cros-checkbox" name="nschoice" value="default" onclick="disableFields('domnsinputs',true)" checked />
				<span class="scheck">
					<h6 class="h5 mt-n1">{lang key='nschoicedefault'}</h5>
				</span>
			</label>
		</div>
		<div class="form-group px-3 py-2 border bg-light rounded">
			<label for="nsChoiceCustom" class="m-0">
				<input id="nsChoiceCustom" type="radio" class="cros-checkbox" name="nschoice" value="custom" onclick="disableFields('domnsinputs', '')" checked />
				<span class="scheck">
					<h6 class="h5 mt-n1">{lang key='nschoicecustom'}</h5>
				</span>
			</label>
		</div>
		<div class="card">
			<div class="card-body">
				{for $num=1 to 5}
					<div class="mw-500">
						<div class="form-group">
							<label for="inputNs{$num}">{lang key='clientareanameserver'} {$num}</label>
							<input type="text" name="ns{$num}" class="form-control domnsinputs" id="inputNs{$num}" />
						</div>
					</div>
				{/for}
			</div>
		</div>
		<div class="form-actions">
			<button type="submit" class="btn btn-primary btn-large">
				{lang key='changenameservers'}
			</button>
		</div>
	{elseif $update eq "autorenew"}
		{if $save}
			<div class="alert alert-success">
				{lang key='changessavedsuccessfully'}
			</div>
		{/if}	
		<h3 class="card-title mb-2">{lang key='domainsautorenew'}</h3>
		<p class="desc">{lang key='domainautorenewinfo'}</p>
		<div class="alert alert-primary">
			{lang key='domainautorenewrecommend'}
		</div>
		<p>{lang key='domainbulkmanagementchangeaffect'}</p>
		<ul class="list-group mb-3">
			{foreach $domains as $domain}
				<li class="list-group-item"><i class="fad fa-check-square mr-2"></i>{$domain}</li>
			{/foreach}
		</ul>
		<div class="form-actions">
			<button type="submit" name="enable" class="btn btn-success btn-large">
				{lang key='domainsautorenewenable'}
			</button>
			<button type="submit" name="disable" class="btn btn-danger btn-large">
				{lang key='domainsautorenewdisable'}
			</button>
		</div>

	{elseif $update eq "reglock"}
		{if $save}
			{if $errors}
			<div class="alert alert-danger">
				<p class="bold">
					{lang key='clientareaerrors'}
				</p>
				<ul>
					{foreach $errors as $error}
					<li>{$error}</li>
					{/foreach}
				</ul>
			</div>
			{else}
			<div class="alert alert-success">
				{lang key='changessavedsuccessfully'}
			</div>
			{/if}
		{/if}
		
		<h3 class="card-title mb-2">{lang key='domainregistrarlock'}</h3>
		<p class="desc">{lang key='domainreglockinfo'}</p>
		<div class="alert alert-primary">
			{lang key='domainreglockrecommend'}
		</div>
		<p>{lang key='domainbulkmanagementchangeaffect'}</p>
		<ul class="list-group mb-3">
			{foreach $domains as $domain}
				<li class="list-group-item"><i class="fad fa-check-square mr-2"></i>{$domain}</li>
			{/foreach}
		</ul>
		<div class="form-actions">
			<button type="submit" name="enable" class="btn btn-success btn-large">
				{lang key='domainreglockenable'}
			</button>
			<button type="submit" name="disable" class="btn btn-danger btn-large">
				{lang key='domainreglockdisable'}
			</button>
		</div>

	{elseif $update eq "contactinfo"}
		{if $save}
			{if $errors}
				<div class="alert alert-danger">
					<p class="bold">
						{lang key='clientareaerrors'}
					</p>
					<ul>
						{foreach $errors as $error}
						<li>{$error}</li>
					{/foreach}
					</ul>
				</div>
			{else}
				<div class="alert alert-success">
					<p>
						{lang key='changessavedsuccessfully'}
					</p>
				</div>
			{/if}
		{/if}
		<h3 class="card-title mb-2">{lang key='domaincontactinfo'}</h3>
		<p>{lang key='domainbulkmanagementchangesaffect'}</p>
		<ul class="list-group mb-3">
			{foreach $domains as $domain}
				<li class="list-group-item"><i class="fad fa-check-square mr-2"></i>{$domain}</li>
			{/foreach}
		</ul>

		<ul class="nav nav-tabs responsive-tabs-sm" role="tablist">
			{foreach $contactdetails as $contactdetail => $values}
				<li class="nav-item">
					<a class="nav-link{if $values@first} active{/if}" id="tabSelector{$contactdetail}" data-toggle="tab" href="#tab{$contactdetail}" role="tab">{$contactdetail}</a>
				</li>
			{/foreach}
		</ul>
		<div class="responsive-tabs-sm-connector"><div class="channel"></div><div class="bottom-border"></div></div>
		<div class="tab-content p-4">
			{foreach $contactdetails as $contactdetail => $values}
				<div class="tab-pane fade{if $values@first} show active{/if}" id="tab{$contactdetail}" role="tabpanel">

					<div class="form-check">
						<label>
							<input type="radio" class="form-check-input" name="wc[{$contactdetail}]" id="{$contactdetail}1" value="contact" onclick="useDefaultWhois(this.id)" />
							{lang key='domaincontactusexisting'}
						</label>
					</div>

					<div class="row">
						<div class="offset-1 col-10">
							<div class="form-group">
								<label for="{$contactdetail}3">{lang key='domaincontactchoose'}</label>
								<input type="hidden" name="sel[{$contactdetail}]" value="">
								<select id="{$contactdetail}3" class="form-control custom-select {$contactdetail}defaultwhois" name="sel[{$contactdetail}]" disabled>
									<option value="u{$clientsdetails.userid}">{lang key='domaincontactprimary'}</option>
									{foreach $contacts as $contact}
										<option value="c{$contact.id}">{$contact.name}</option>
									{/foreach}
								</select>
							</div>
						</div>
					</div>

					<div class="form-check">
						<label>
							<input type="radio" class="form-check-input" name="wc[{$contactdetail}]" id="{$contactdetail}2" value="custom" onclick="useCustomWhois(this.id)" checked />
							{lang key='domaincontactusecustom'}
						</label>
					</div>

					{foreach $values as $name => $value}
						<div class="form-group">
							<label>{$contactdetailstranslations[$name]}</label>
							<input type="text" name="contactdetails[{$contactdetail}][{$name}]" value="{$value}" data-original-value="{$value}" class="form-control {$contactdetail}customwhois{if isset($irtpFields[$contactdetail]) && in_array($name, $irtpFields[$contactdetail])} irtp-field{/if}" />
						</div>
					{/foreach}
				</div>
				
			{foreachelse}
				
				<div class="alert alert-danger">
					<p>
						{$LANG.domainbulkmanagementnotpossible}
					</p>
				</div>
			{/foreach}
		</div>

		<div class="form-actions">
			<button type="submit" class="btn btn-primary">
				{lang key='clientareasavechanges'}
			</button>
		</div>

	{/if}

</form>

    </div>
</div>

<a href="clientarea.php?action=domains" class="btn btn-default">
    {lang key='clientareabacklink'}
</a>

<script type="text/javascript">
    var disableInternalTabSelection = true;
</script>
