{if $pagedata.item.publish eq "1"}
{$pagebuilder}
{else}

{if $registerdomainenabled || $transferdomainenabled}
<div class="sec products domains-section bg-primary position-relative">
	<div class="cros-bg-shapes-right"></div>
	<div class="cros-bg-shapes-left"></div>
	<div class="container">
		<div class="domain-hero">
		<div class="h1 text-center fw-900">{lang key="secureYourDomainShort"}</div>
			<!--Domain Search Input Box-->
			<form class="form-search mw-768-strictly" action="{$WEB_ROOT}/domainchecker.php" method="post">
				<div class="serach-form input-group">
					<i class="input-group-icon fad fa-search"></i>
					<input type="text" name="domain" placeholder="{$LANG.findyourdomain}" value="" id="inputDomain" class="form-control search-query" autocapitalize="none" />
					<span class="input-group-btn btn-group">
                         {if $registerdomainenabled}
                            <button type="submit" class="btn btn-default{$captcha->getButtonClass($captchaForm)}" id="btnDomainSearch">
                                 {lang key="search"}
                            </button>
                        {/if}
                        {if $transferdomainenabled}
                            <button type="submit" id="btnTransfer" data-domain-action="transfer" class="btn btn-default{$captcha->getButtonClass($captchaForm)}">
                                {lang key="domainstransfer"}
                            </button>
                        {/if}
					</span>
				</div>
				{include file="$template/includes/captcha.tpl"}
				
                {if $featuredTlds}
					<div class="home-domain-search mt-3">
						<ul class="tld-logos bg-white">
							{foreach $featuredTlds as $num => $tldinfo}
								{if $num < 3}
									<li class="py-1 px-3 border rounded mr-1 mb-1 mb-md-0">
										<img src="{$BASE_PATH_IMG}/tld_logos/{$tldinfo.tldNoDots}.png">
										{if is_object($tldinfo.register)}
											{$tldinfo.register->toFull()}
										{else}
											{lang key="domainregnotavailable"}
										{/if}
									</li>
								{/if}
							{/foreach}
						</ul>
					</div>
                {/if}
				
				<a href="{routePath('domain-pricing')}" class="btn btn-link text-white btn-sm float-right">{lang key='viewAllPricing'}</a>
				
			</form>
			<!--End Domain Search Input Box-->
		</div>
	</div>
</div>
{/if}

<div  id="main-body">
<div class="">
	<div class="py-5">
		<div class="container">
			<div class="h2 text-center mt-0">{lang key='howCanWeHelp'}</div>
			<div class="row my-5 action-icon-btns">
				<div class="col-6 col-md-4 col-lg">
					<a href="{routePath('announcement-index')}" class="card">
						<figure class="ico-container">
							<i class="fal fa-bullhorn"></i>
						</figure>
						<span>{lang key='announcementstitle'}</span>
					</a>
				</div>
				<div class="col-6 col-md-4 col-lg">
					<a href="serverstatus.php" class="card">
						<figure class="ico-container">
							<i class="fal fa-server"></i>
						</figure>
						<span>{lang key='networkstatustitle'}</span>
					</a>
				</div>
				<div class="col-6 col-md-4 col-lg">
					<a href="{routePath('knowledgebase-index')}" class="card">
						<figure class="ico-container">
							<i class="fal fa-book"></i>
						</figure>
						<span>{lang key='knowledgebasetitle'}</span>
					</a>
				</div>
				<div class="col-6 col-md-4 offset-md-2 offset-lg-0 col-lg">
					<a href="{routePath('download-index')}" class="card">
						<figure class="ico-container">
							<i class="fal fa-download"></i>
						</figure>
						<span>{lang key='downloadstitle'}</span>
					</a>
				</div>
				<div class="col-6 offset-3 offset-md-0 col-md-4 col-lg">
					<a href="submitticket.php" class="card">
						<figure class="ico-container">
							<i class="fal fa-life-ring"></i>
						</figure>
						<span>{lang key='homepage.submitTicket'}</span>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>


{if !empty($productGroups) || $registerdomainenabled || $transferdomainenabled}
<div class="sec light">
	<div class="py-5">
		<div class="container">
			<div class="h2 text-center mt-0">{lang key='clientHomePanels.productsAndServices'}</div>
			<div class="row row-cols-1 row-cols-md-3 my-5">
				{foreach $productGroups as $productGroup}
					<div class="col mb-4">
						<div class="card mb-3 h-100">
							<div class="card-body p-4">
							
								<h4 class="mt-0">{$productGroup->name}</h4>
								
								{if $productGroup->headline}
									<p>{$productGroup->headline}</p>
								{/if}
								{if $productGroup->tagline}
									<p>{$productGroup->tagline}</p>
								{/if}
								
								{if count($productGroup.features) > 0}
									<div class="includes-features">
										<ul class="list-features list-unstyled mb-0">
											{foreach $productGroup.features as $features}
												<li><i class="far fa-check-circle fa-fw text-primary"></i> {$features.feature}</li>
											{/foreach}
										</ul>
									</div>
								{/if}
								
							</div>
							<div class="card-footer bg-white">
								<a href="{$productGroup->getRoutePath()}" class="btn btn-block btn-primary">
									{lang key='browseProducts'}
								</a>
							</div>
						</div>
					</div>

				{/foreach}
			</div>
		</div>
	</div>
</div>
{/if}

</div>
{/if}