{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

<div class="section">
	<div class="TM-card search-card bg-checkered">
		<form role="form" method="post" action="{routePath('knowledgebase-search')}">
			<div class="input-group input-group-lg kb-search">
				<input type="text" name="search" class="form-control input-lg" placeholder="{$LANG.howcanwehelp}" value="{$searchterm}" />
				<span class="input-group-append">
					<input type="submit" id="btnKnowledgebaseSearch" class="btn btn-primary btn-input-padded-responsive" value="{$LANG.search}" />
				</span>
			</div>
		</form>
	</div>
</div>

{if $kbcurrentcat.description}
<div class="section">
	<p>{$kbcurrentcat.description}</p>
</div>
{/if}

{if $kbcats}
	<div class="section">
    <h4>{$LANG.knowledgebasecategories}</h4>
		<div class="kbcat">
			<div class="row">
				{foreach $kbcats as $category}
					<div class="col-xl-6">
						<div class="kb-article" onclick="clickableSafeRedirect(event, '{routePath('knowledgebase-category-view', {$category.id}, {$category.urlfriendlyname})}')">
							<i class="fal fa-folder{if $category.numarticles > 0 }-open{/if} fa-fw"></i> {$category.name}
							{if $category.numarticles > 0 }<span>({$category.numarticles})</span>{/if}
							{if $category.editLink}
								<span class="admin-edit-link"><a href="{$category.editLink}">
									<i class="fal fa-edit fa-fw"></i>{$LANG.edit}
								</a></span>
							{/if}
							{if $category.description}<p>{$category.description}</p>{/if}
						</div>
					</div>
				{/foreach}
			</div>
		</div>
	</div>
{/if}

{if $kbarticles || !$kbcats}
	<div class="section">
		{if $tag}
			<h4>{$LANG.kbviewingarticlestagged} '{$tag}'</h4>
		{else}
			<h4>{$LANG.knowledgebasearticles}</h4>
		{/if}
		{if $kbarticles}
		<div class="kbarticles">
			{foreach $kbarticles as $kbarticle}
				<div class="kb-article" onclick="clickableSafeRedirect(event, '{routePath('knowledgebase-article-view', {$kbarticle.id}, {$kbarticle.urlfriendlytitle})}')">
					<span class="fal fa-file-alt fa-fw"></span>{$kbarticle.title} {if $kbarticle.editLink} <span class="admin-edit-link"><a href="{$kbarticle.editLink}">{$LANG.edit}</a></span>{/if}
					<p>{$kbarticle.article|truncate:100:"..."}</p>
				</div>
			{/foreach}
		</div>
		
		{else}
			<div class="alert alert-info text-center">
				{lang key='knowledgebasenoarticles'}
			</div>
		{/if}
	</div>
{/if}


<div class="mt-3">
	<a href="javascript:history.go(-1)" class="btn btn-default px-4">
		{lang key='clientareabacklink'}
	</a>

	{if $kbcurrentcat.editLink}
		<a href="{$kbcurrentcat.editLink}" class="btn btn-default px-4 float-right">
			<i class="fal fa-edit fa-fw"></i>
			{lang key='edit'}
		</a>
	{/if}
</div>