{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $themesettings.clientarea.loginpagestyle eq ""} 
<div id="wrapper">
	<div class="container">
		<div class="login-container">
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>					
			</div>
			<div id="login-box" class="login-box">					
				<h1 class="h6 mb-0 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='account'} {lang key='loginbutton'}</b>
				</h1>
				<p class="text-muted">{lang key='userLogin.signInToContinue'}</p>
						
				<hr />
				{include file="$template/includes/flashmessage.tpl"}
				
				<form method="post" action="{routePath('login-validate')}">
						
					<div class="form-group">
						<label for="inputEmail" class="form-control-label">{lang key='clientareaemail'}</label>
						<div class="input-group input-group-merge">
							<input type="email" class="form-control" name="username" id="inputEmail" placeholder="{lang key='enteremail'}" autofocus>
						</div>
					</div>
					<div class="form-group mb-2 focused">
						<div class="d-flex align-items-center justify-content-between">
							<label for="inputPassword" class="form-control-label">{lang key='clientareapassword'}</label>
							<a href="{routePath('password-reset-begin')}" class="small text-muted mb-2" tabindex="-1">{lang key='forgotpw'}</a>
						</div>
						<div class="input-group input-group-merge">
							<input type="password" class="form-control pw-input" name="password" id="inputPassword" placeholder="{lang key='clientareapassword'}" autocomplete="off">
							<div class="input-group-append">
								<button class="btn btn-default btn-sm btn-reveal-pw" type="button" tabindex="-1">
									<i class="fas fa-eye"></i>
								</button>
							</div>
						</div>
					</div>
							
					<div class="footer-warp">
						<label>
							<input type="checkbox" type="checkbox" class="rememberme" name="rememberme" />
							<span class="labels">{lang key='loginrememberme'}</span>
						</label>							

						{if $captcha->isEnabled()}
							<div class="text-center">
								{include file="$template/includes/captcha.tpl"}
							</div>
						{/if}							
						<input id="login" type="submit" class="mb-3 btn-login btn btn-primary btn-lg btn-block{$captcha->getButtonClass($captchaForm)}" value="{lang key='loginbutton'}" /> 
			
					</div>		
				</form>
						
				{if $linkableProviders}
					<div class="social-or-login">
						<span class="text-muted">{lang key='remoteAuthn.titleOr'}</span>
					</div>
					<div class="providerLinkingFeedback"></div>					
					{include file="$template/includes/linkedaccounts.tpl" linkContext="login" customFeedback=true}
				{/if}
				
				{if $condlinks.allowClientRegistration}
				<div class="login-container-register">
					{$LANG.userLogin.notRegistered} <a href="{$WEB_ROOT}/register.php" class="ml-1">{$LANG.orderForm.createAccount}</a>
				</div>
				{/if}
			</div>
					
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}			
					
		</div>
	</div>
</div>
	
{else}


<div class="primary-content loginpage-with-sidebar sidebar-left">
    <div class="sidebar-container light">
        <div class="login-header">
			<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
				{if $themesettings.general.enablelogo}
					<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
					{if $themesettings.general.darklogo}
					<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
					{else}
					<span class="logo-dark">{$companyname}</span>
					{/if}
				{else}
					<span class="logo-dark">{$companyname}</span>
					<span class="logo-light">{$companyname}</span>
				{/if}
			</a>
        </div>
        <div class="sidebar-content">
			{if $announcements}
				<h2 class="header fw-400">{$LANG.ourlatestnews}</h2>
				<div id="annuncements" class="swiper-container">
					<div class="swiper-wrapper">
					{foreach $announcements as $announcement}
						{if $announcement@index < 3}
							<div class="swiper-slide">
								<span class="text-muted">
									<i class="fad fa-calendar-week"></i>&nbsp;{"jS M Y"|date:$announcement.timestamp}
								</span>
								<a href="{routePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}"><h2 class="h3 bolder">{$announcement.title}</h2></a>
								<p>{$announcement.text|strip_tags|truncate:160:"..."}</p>
							</div>
						{/if}
					{/foreach}
					</div>
					<div class="swiper-pagination"></div>
				</div>
			{/if}
			<div class="user_lock_icon">
				<i class="fad fa-user-lock"></i>
			</div>
		</div>
    </div>        
    <div class="center-container">
		<div class="login-container">
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>					
			</div>
			<div id="login-box" class="login-box">					
				<h1 class="h6 mb-0 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='account'} {lang key='loginbutton'}</b>
				</h1>
				<p class="text-muted">{lang key='userLogin.signInToContinue'}</p>
						
				<hr />
						
				{include file="$template/includes/flashmessage.tpl"}
				
				<form method="post" action="{routePath('login-validate')}">
						
					<div class="form-group">
						<label for="inputEmail" class="form-control-label">{lang key='clientareaemail'}</label>
						<div class="input-group input-group-merge">
							<input type="email" class="form-control" name="username" id="inputEmail" placeholder="{lang key='enteremail'}" autofocus>
						</div>
					</div>
					<div class="form-group mb-2 focused">
						<div class="d-flex align-items-center justify-content-between">
							<label for="inputPassword" class="form-control-label">{lang key='clientareapassword'}</label>
							<a href="{routePath('password-reset-begin')}" class="small text-muted mb-2" tabindex="-1">{lang key='forgotpw'}</a>
						</div>
						<div class="input-group input-group-merge">
							<input type="password" class="form-control pw-input" name="password" id="inputPassword" placeholder="{lang key='clientareapassword'}" autocomplete="off">
							<div class="input-group-append">
								<button class="btn btn-default btn-sm btn-reveal-pw" type="button" tabindex="-1">
									<i class="fas fa-eye"></i>
								</button>
							</div>
						</div>
					</div>
							
					<div class="footer-warp">
						<label>
							<input class="rememberme" type="checkbox" class="rememberme" name="rememberme" />
							<span class="labels">{lang key='loginrememberme'}</span>
						</label>							

						{if $captcha->isEnabled()}
							<div class="text-center">
								{include file="$template/includes/captcha.tpl"}
							</div>
						{/if}							
						<input id="login" type="submit" class="mb-3 btn-login btn btn-primary btn-lg btn-block{$captcha->getButtonClass($captchaForm)}" value="{lang key='loginbutton'}" /> 
			
					</div>		
				</form>
						
				{if $linkableProviders}
					<div class="social-or-login">
						<span class="text-muted">{lang key='remoteAuthn.titleOr'}</span>
					</div>
					<div class="providerLinkingFeedback"></div>					
					{include file="$template/includes/linkedaccounts.tpl" linkContext="login" customFeedback=true}
				{/if}
				
				{if $condlinks.allowClientRegistration}
				<div class="login-container-register">
					{$LANG.userLogin.notRegistered} <a href="{$WEB_ROOT}/register.php" class="ml-1">{$LANG.orderForm.createAccount}</a>
				</div>
				{/if}
			</div>
					
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}			
					
		</div>
    </div>
</div>

<script>
	jQuery(document).ready(function () {
		var swiper = new Swiper('#annuncements', {
		  slidesPerView: 1,
		  pagination: {
			el: '.swiper-pagination',
			clickable: true,
		  },

		  breakpoints: {
			0: {
				slidesPerView: 1,
			},
		  }
		  
		});
	});
</script>

{/if}
	
<script src="{$WEB_ROOT}/templates/{$template}/assets/js/main.min.js?v={$versionHash}"></script>
<script>
	jQuery(document).ready(function () {
		jQuery('.rememberme').iCheck({
			checkboxClass: 'icheckbox_square-blue',
		});
	});
</script>