{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $themesettings.clientarea.loginpagestyle eq ""}
<div id="wrapper" class="primary-content" style="min-height: auto; margin: auto;">
	<div class="container">
		<div class="login-container">	
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>		
			</div>
			<div class="login-box">				
				<h1 class="h6 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='twofactorauth'}</b>
				</h1>
						
				<hr />
				
				<div class="logincontainer" style="margin: 0; padding: 0;">

					{if $newbackupcode}
						{include file="$template/includes/alert.tpl" type="success" msg=$LANG.twofabackupcodereset textcenter=true}
					{elseif $incorrect}
						{include file="$template/includes/alert.tpl" type="error" msg=$LANG.twofa2ndfactorincorrect textcenter=true}
					{elseif $error}
						{include file="$template/includes/alert.tpl" type="error" msg=$error textcenter=true}
					{else}
						{include file="$template/includes/alert.tpl" type="warning" msg=$LANG.twofa2ndfactorreq textcenter=true}
					{/if}

					<form method="post" action="{$systemsslurl}dologin.php" id="frmLogin">
						{if $newbackupcode}
							<input type="hidden" name="newbackupcode" value="1" />
							<h2 class="text-center">{$LANG.twofanewbackupcodeis}</h2>
							{include file="$template/includes/alert.tpl" type="warning" msg=$newbackupcode textcenter=true}
							<p class="text-center">{$LANG.twofabackupcodeexpl}</p>
							<p class="text-center"><input type="submit" value="{$LANG.continue} &raquo;" class="btn" /></p>
						{elseif $backupcode}
							<input type="text" name="code" class="form-control" placeholder="{$LANG.twofabackupcodelogin}">
							<br/>
							<input id="login" type="submit" class="btn btn-primary btn-block" value="{$LANG.loginbutton}" />
							<input type="hidden" name="backupcode" value="1" />
						{else}
							<div class="margin-bottom">
								{$challenge}
							</div>
							<div class="panel panel-info">
								<div class="panel-heading">
									<h3 class="panel-title">{$LANG.twofacantaccess2ndfactor}</h3>
								</div>
								<div class="panel-body">
									<a href="clientarea.php?backupcode=1">{$LANG.twofaloginusingbackupcode}</a>
								</div>
							</div>
						{/if}
					</form>
				</div>

			</div>
			
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}
					
		</div>
	</div>
</div>

{else}

<div class="primary-content loginpage-with-sidebar sidebar-left">
    <div class="sidebar-container light">
        <div class="login-header">
			<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
				{if $themesettings.general.enablelogo}
					<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
					{if $themesettings.general.darklogo}
					<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
					{else}
					<span class="logo-dark">{$companyname}</span>
					{/if}
				{else}
					<span class="logo-dark">{$companyname}</span>
					<span class="logo-light">{$companyname}</span>
				{/if}
			</a>
        </div>
        <div class="sidebar-content">
			{if $announcements}
				<h2 class="header fw-400">{$LANG.ourlatestnews}</h2>
				<div id="annuncements" class="swiper-container">
					<div class="swiper-wrapper">
					{foreach $announcements as $announcement}
						{if $announcement@index < 3}
							<div class="swiper-slide">
								<span class="text-muted">
									<i class="fad fa-calendar-week"></i>&nbsp;{"jS M Y"|date:$announcement.timestamp}
								</span>
								<a href="{routePath('announcement-view', $announcement.id, $announcement.urlfriendlytitle)}"><h2 class="h3 bolder">{$announcement.title}</h2></a>
								<p>{$announcement.text|strip_tags|truncate:160:"..."}</p>
							</div>
						{/if}
					{/foreach}
					</div>
					<div class="swiper-pagination"></div>
				</div>
			{/if}
			<div class="user_lock_icon">
				<i class="fad fa-user-lock"></i>
			</div> 
		</div>
    </div>        
    <div class="center-container">
		<div class="login-container">	
			<div class="login-header">
				<a href="{if $themesettings.headersetting.CustomLogoLink}{$themesettings.headersetting.CustomLogoLink}{else}{$WEB_ROOT}/{/if}">
					{if $themesettings.general.enablelogo}
						<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
						{if $themesettings.general.darklogo}
						<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
						{else}
						<span class="logo-dark">{$companyname}</span>
						{/if}
					{else}
						<span class="logo-dark">{$companyname}</span>
						<span class="logo-light">{$companyname}</span>
					{/if}
				</a>		
			</div>
			<div class="login-box">				
				<h1 class="h6 text-uppercase">
					<i class="fas fa-key"></i> <b>{lang key='twofactorauth'}</b>
				</h1>
						
				<hr />
				
				<div class="logincontainer" style="margin: 0; padding: 0;">
				
					{if $newbackupcode}
						{include file="$template/includes/alert.tpl" type="success" msg=$LANG.twofabackupcodereset textcenter=true}
					{elseif $incorrect}
						{include file="$template/includes/alert.tpl" type="error" msg=$LANG.twofa2ndfactorincorrect textcenter=true}
					{elseif $error}
						{include file="$template/includes/alert.tpl" type="error" msg=$error textcenter=true}
					{else}
						{include file="$template/includes/alert.tpl" type="warning" msg=$LANG.twofa2ndfactorreq textcenter=true}
					{/if}

					<form method="post" action="{$systemsslurl}dologin.php" id="frmLogin">
						{if $newbackupcode}
							<input type="hidden" name="newbackupcode" value="1" />
							<h2 class="text-center">{$LANG.twofanewbackupcodeis}</h2>
							{include file="$template/includes/alert.tpl" type="warning" msg=$newbackupcode textcenter=true}
							<p class="text-center">{$LANG.twofabackupcodeexpl}</p>
							<p class="text-center"><input type="submit" value="{$LANG.continue} &raquo;" class="btn" /></p>
						{elseif $backupcode}
							<input type="text" name="code" class="form-control" placeholder="{$LANG.twofabackupcodelogin}">
							<br/>
							<input id="login" type="submit" class="btn btn-primary btn-block" value="{$LANG.loginbutton}" />
							<input type="hidden" name="backupcode" value="1" />
						{else}
							<div class="margin-bottom">
								{$challenge}
							</div>
							<div class="panel panel-info">
								<div class="panel-heading">
									<h3 class="panel-title">{$LANG.twofacantaccess2ndfactor}</h3>
								</div>
								<div class="panel-body">
									<a href="clientarea.php?backupcode=1">{$LANG.twofaloginusingbackupcode}</a>
								</div>
							</div>
						{/if}
					</form>
				</div>

			</div>
			
			{if $languagechangeenabled && count($locales) > 1}
				<div class="lang-btn d-flex align-items-center justify-content-center">
					<button type="button" class="btn" data-toggle="modal" data-target="#modalChooseLanguage">
						<div class="d-inline-block align-middle">
							<div class="iti-flag {if $activeLocale.countryCode === '001'}us{else}{$activeLocale.countryCode|lower}{/if}"></div>
						</div>
						{$activeLocale.localisedName}
					</button>
				</div>
			{/if}
					
		</div>
    </div>
</div>

<script>
	jQuery(document).ready(function () {
		var swiper = new Swiper('#annuncements', {
		  slidesPerView: 1,
		  pagination: {
			el: '.swiper-pagination',
			clickable: true,
		  },

		  breakpoints: {
			0: {
				slidesPerView: 1,
			},
		  }
		  
		});
	});
</script>
{/if}

<script src="{$WEB_ROOT}/templates/{$template}/assets/js/main.min.js?v={$versionHash}"></script>