{if count($existingAccounts) > 0}
	<div class="cc-input-container">
		<div class="existing-cc-grid">
			<div class="card-list bankAccount">
				{foreach $existingAccounts as $bankAccount}
					{assign "payMethod" $bankAccount.payMethod nocache}
					<label class="card-item border rounded{if !$existingAccount} disabled{/if}{if $existingAccount && $payMethodId eq $bankAccount.paymethodid} selected{/if}"{if !$hasRemoteInput} onclick="hideNewAccountInputFields();"{/if} for="existing-card">
						<div class="card-item-checkbox ml-0" data-paymethod-id="{$bankAccount.paymethodid}">
							<input
									id="existingAccount{$bankAccount.paymethodid}"
									type="radio"
									name="paymethod"
									class="existing-account icheck-button"
									data-billing-contact-id="{$bankAccount.billingcontactid}"
									{if $existingAccount && $payMethodId eq $bankAccount.paymethodid}
										{assign "preselectedBillingContactId" {$bankAccount.billingcontactid}}
										checked="checked"
										data-loaded-paymethod="true"
									{elseif !$existingAccount}
										disabled="disabled"
									{/if}
									{if !$hasRemoteInput}onclick="hideNewAccountInputFields();"{/if}
									value="{$bankAccount.paymethodid}"
							>
						</div>
						<div class="card-item-icon" data-paymethod-id="{$bankAccount.paymethodid}">
							<div for="existingAccount{$bankAccount.paymethodid}">
								<i class="{$payMethod->getFontAwesomeIcon()} fa-fw bigger-150"></i>
							</div>
						</div>
						<div class="card-item-info" data-paymethod-id="{$bankAccount.paymethodid}">
							<div for="existingAccount{$bankAccount.paymethodid}">
								<strong class="fw-500">{$payMethod->payment->getDisplayName()}</strong>
							</div>
							<div class="small text-muted" for="existingAccount{$bankAccount.paymethodid}">
								{if $payMethod->getDescription()}
									{$payMethod->getDescription()}
								{else}
									-
								{/if}
							</div>
							
						</div>
					</label>
				{/foreach}
			</div>
		</div>
	</div>
{/if}
<div class="paymethod-info">
    <label class="py-2 px-3 border rounded w-100">
        <input id="newAccountInfo"
               type="radio"
               class="icheck-button"
               name="paymethod"
               value="new"
               {if $payMethodId eq "new" || !$existingAccount} checked="checked"{/if}
        >
        {lang key='paymentMethods.addNewBank'}
    </label>
</div>
