<div id="invoiceIdSummary" class="card invoice-summary-card">
	<h4 class="mt-0 card-header bg-white">
       {lang key="invoicenumber"}{if $invoicenum}{$invoicenum}{else}{$invoiceid}{/if}
    </h4>
	
    <div class="card-body invoice-summary">
		<div class="summary-content text-muted">
			<ul class="summary-list border-bottom">
				{foreach $invoiceitems as $item}
					<li class="list-item">
						<span class="item-name">{$item.description}</span>
						<span class="item-value">{$item.amount}</span>
					</li>
				{/foreach}
			</ul>
			<ul class="summary-list">
				<li class="list-item">
					<span class="item-name">{$LANG.invoicessubtotal}</span>
					<span class="item-value">{$invoice.subtotal}</span>
				</li>
				{if $invoice.taxrate}
					<li class="list-item">
						<span class="item-name">{$invoice.taxrate}% {$invoice.taxname}</span>
						<span class="item-value">{$invoice.tax}</span>
					</li>
				{/if}
				{if $invoice.taxrate2}
					<li class="list-item">
						<span class="item-name">{$invoice.taxrate2}% {$invoice.taxname2}</span>
						<span class="item-value">{$invoice.tax2}</span>
					</li>                                          
				{/if}
				<li class="list-item">
					<span class="item-name">{$LANG.invoicescredit}</span>
					<span class="item-value">{$invoice.credit}</span>
				</li>
				<li class="list-item">
					<span class="item-name">{$LANG.paymentstodate}</span>
					<span class="item-value">{$invoice.amountpaid}</span>
				</li>
				<li class="list-item">
					<span class="item-name">{$LANG.balancedue}</span>
					<span class="item-value">{$balance}</span>
				</li>
			</ul>
		</div>
    </div>
	<div class="card-footer bg-white">
        <div class="price">
			<span class="price-total text-muted">{$LANG.invoicestotaldue}</span> 
			<div class="price-amount">{$invoice.total}</div>
		</div>
		<div class="alert alert-success text-center m-0 d-none">
			{lang key="balancedue"}: <strong>{$balance}</strong>
		</div>
	</div>
</div>
