{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $themesettings.clientarea.viandq eq "outer-layout"}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="{$charset}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{$companyname} - {$pagetitle}</title>
	<link href="{$WEB_ROOT}/templates/{$template}/assets/css/invoice.min.css" rel="stylesheet">
	<script>var whmcsBaseUrl = "{$WEB_ROOT}";</script>
	{include file="templates/$template/includes/head.tpl"}

</head>
<body {if $themesettings.customcolors.darkmode == '1'} class="dark-mode{if $themesettings.customcolors.dmimggs != '1'} gray_logos{/if}"{/if} style="margin: 0;">
{else}
{include file="{$template}/header.tpl"}
<style>
#fullpage-overlay {
  display: table;
  position: fixed;
  z-index: 1000;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: black;
  background-color: rgba(0, 0, 0, 0.8);
  color: #fff;
}

#fullpage-overlay .outer-wrapper {
  position: relative;
  height: 100%;
}

#fullpage-overlay .inner-wrapper {
  position: absolute;
  top: 50%;
  left: 50%;
  height: 30%;
  width: 50%;
  margin: -3% 0 0 -25%;
  text-align: center;
}

#fullpage-overlay .msg {
  display: inline-block;
  padding: 20px;
  max-width: 400px;
}

</style>

<script>var whmcsBaseUrl = "{$WEB_ROOT}";</script>

{/if}

	<div {if $themesettings.clientarea.viandq eq "outer-layout"}class="container" style="margin: 4rem auto"{/if}>
		{if $invalidInvoiceIdRequested}
			{include file="$template/includes/panel.tpl" type="danger" headerTitle=$LANG.error bodyContent=$LANG.invoiceserror bodyTextCenter=true}
		{else}
			<div class="row">
			
				<div class="col-lg-9">				
					<div class="TM-card invoice{if $themesettings.customcolors.darkmode != '1'}{if $themesettings.clientarea.viandqbg neq ""} {$themesettings.clientarea.viandqbg}{/if}{/if}" style="padding: 45px 30px;">
						
						<div class="company-logo">
							{if $themesettings.general.enablelogo}
								<img src="{$themesettings.general.logourl}" alt="{$companyname}" class="logo-light" />
								{if $themesettings.general.darklogo}
									<img src="{$themesettings.general.darklogo}" alt="{$companyname}" class="logo-dark" />
								{else}
								<h2 class="logo-dark">{$companyname}</h2>
								{/if}
							{else}
								<h2 class="logo-dark">{$companyname}</h2>
								<h2 class="logo-light">{$companyname}</h2>
							{/if}
						</div>
						
						{if $paymentSuccessAwaitingNotification}
							{include file="$template/includes/alert.tpl" type="success" msg=$LANG.invoicePaymentSuccessAwaitingNotify}
						{elseif $paymentSuccess}
							{include file="$template/includes/alert.tpl" type="success" msg=$LANG.invoicepaymentsuccessconfirmation}
						{elseif $paymentInititated}
							{include file="$template/includes/alert.tpl" type="info" msg=$LANG.invoicePaymentInitiated}
						{elseif $pendingReview}
							{include file="$template/includes/alert.tpl" type="info" msg=$LANG.invoicepaymentpendingreview}
						{elseif $paymentFailed}
							{include file="$template/includes/alert.tpl" type="danger" msg=$LANG.invoicepaymentfailedconfirmation}
						{elseif $offlineReview}
							{include file="$template/includes/alert.tpl" type="info" msg=$LANG.invoiceofflinepaid}
						{/if}
			
						<div class="section">
							<div class="invoice-info">
								<div class="invoice-title">
									<span class="title"> {$pagetitle}
										{if $status eq "Draft"}
											<span class="invoice-status label label-info">{$LANG.invoicesdraft}</span>                                    
										{elseif $status eq "Unpaid"}
											<span class="invoice-status label label-danger">{$LANG.invoicesunpaid}</span>
										{elseif $status eq "Paid"}
											<span class="invoice-status label label-success">{$LANG.invoicespaid}</span>                                   
										{elseif $status eq "Refunded"}
											<span class="invoice-status label label-info">{$LANG.invoicesrefunded}</span>                                          
										{elseif $status eq "Cancelled"}
											<span class="invoice-status label label-info">{$LANG.invoicescancelled}</span>         
										{elseif $status eq "Collections"}
											<span class="invoice-status label label-info">{$LANG.invoicescollections}</span>         
										{elseif $status eq "Payment Pending"}
											<span class="invoice-status label label-warning">{$LANG.invoicesPaymentPending}</span>          
										{/if}
									</span>
								</div>
								<div class="invoice-date">
									<div class="pull-right">
										<div class="text-right">
											<strong>{$LANG.invoicesdatecreated}</strong><br />
											<span class="text-muted">{$date}</span>
										</div>
										{if $status eq "Unpaid" || $status eq "Draft"}
											<div class="text-right">
												<strong>{$LANG.invoicesdatedue}</strong><br />
												<span class="text-muted">{$datedue}</span>
											</div>
										{/if}
										{if $status neq "Unpaid"}
											<div class="text-right">
												<strong>{$LANG.orderpaymentmethod}</strong><br />
												<span class="text-muted">{$paymentmethod}{if $paymethoddisplayname} ({$paymethoddisplayname}){/if}</span>
											</div>
										{/if}
									</div>
								</div>
							</div>
						</div>
						
						
						
						<div class="section">
							<div class="row">
								<div class="col-sm-7">
									<h4>{$LANG.invoicespayto}:</h4>
									<address>
										{$payto}
										{if $taxCode}<br />{$taxIdLabel}: {$taxCode}{/if}
									</address>
								</div>
								<div class="col-sm-5">
									<h4>{$LANG.invoicesinvoicedto}:</h4>
									<address> {if $clientsdetails.companyname}{$clientsdetails.companyname}<br />{/if}
											{$clientsdetails.firstname} {$clientsdetails.lastname}<br />
											{$clientsdetails.address1}, {$clientsdetails.address2}<br />
											{$clientsdetails.city}, {$clientsdetails.state}, {$clientsdetails.postcode}<br />
											{$clientsdetails.country}
											{if $clientsdetails.tax_id}<br />{$taxIdLabel}: {$clientsdetails.tax_id}{/if}
											{if $customfields}
											<br /><br />
											{foreach from=$customfields item=customfield}
											{$customfield.fieldname}: {$customfield.value}<br />
											{/foreach}
											{/if}
									</address>
								</div>
							</div>
						</div>
						
						
						{if $notes}
						   <div class="section">
								{include file="$template/includes/panel.tpl" type="info" headerTitle=$LANG.invoicesnotes bodyContent=$notes}
							</div>
						{/if}
						
						<div class="section">
							<h4>{$LANG.invoicelineitems}</h4>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
										<tr>
											<th>{$LANG.invoicesdescription}</th>
											<th width="20%" class="text-center">{$LANG.invoicesamount}</th>
										</tr>
									</thead>
									<tbody>
										{foreach from=$invoiceitems item=item}
											<tr>
												<td>{$item.description}{if $item.taxed eq "true"} *{/if}</td>
												<td class="text-center">{$item.amount}</td>
											</tr>
										{/foreach}
										<tr>
											<td class="total-row text-right"><strong>{$LANG.invoicessubtotal}</strong></td>
											<td class="total-row text-center">{$subtotal}</td>
										</tr>
										{if $taxname}
											<tr>
												<td class="total-row text-right"><strong>{$taxrate}% {$taxname}</strong></td>
												<td class="total-row text-center">{$tax}</td>
											</tr>
										{/if}
										{if $taxname2}
											<tr>
												<td class="total-row text-right"><strong>{$taxrate2}% {$taxname2}</strong></td>
												<td class="total-row text-center">{$tax2}</td>
											</tr>
										{/if}
										<tr>
											<td class="total-row text-right"><strong>{$LANG.invoicescredit}</strong></td>
											<td class="total-row text-center">{$credit}</td>
										</tr>
										<tr class="active">
											<td class="total-row text-right"><strong>{$LANG.invoicestotal}</strong></td>
											<td class="total-row text-center">{$total}</td>
										</tr>
									</tbody>
								</table>
							</div>
							{if $taxrate}
								<p class="text-muted">* {$LANG.invoicestaxindicator}</p>
							{/if}
						</div>

						<div class="section">
							<h4>{$LANG.invoicestransactions}</h4>
							<div class="table-responsive">    
								<table class="table table-hover">
									<thead>
										<tr>
											<th>{$LANG.invoicestransdate}</th>
											<th>{$LANG.invoicestransgateway}</th>
											<th>{$LANG.invoicestransid}</th>
											<th>{$LANG.invoicestransamount}</th>
										</tr>
									</thead>
									<tbody>
										{foreach from=$transactions item=transaction}
											<tr>
												<td>{$transaction.date}</td>
												<td>{$transaction.gateway}</td>
												<td>{$transaction.transid}</td>
												<td>{$transaction.amount}</td>
											</tr>
										{foreachelse}
											<tr>
												<td colspan="4">{$LANG.invoicestransnonefound}</td>
											</tr>
										{/foreach}
										<tr class="total-row active">
											<td></td>
											<td></td>
											<td><strong>{$LANG.invoicesbalance}</strong></td>
											<td>{$balance}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				
				</div>
				
				<div class="col-lg-3 sidebar d-print-none">
					{if $status eq "Unpaid"}
						<div menuitemname="Client Details" class="panel panel-sidebar panel-invoice-info">
							<div class="panel-body">
								<div class="total">
									<span class="text-muted">{$LANG.invoicestotaldue}</span> 
									<span class="total-price">{$balance}</span>
								</div>
								{if $status eq "Unpaid" && $allowchangegateway}
									<label>{$LANG.orderpaymentmethod}:</label>
									<span data-role="paymethod-info">
									<form method="post" action="{$smarty.server.PHP_SELF}?id={$invoiceid}">
										<div class="form-group">
											{$gatewaydropdown}
										</div>
									</form>
									</span>
								{else}
									{$paymentmethod}{if $paymethoddisplayname} ({$paymethoddisplayname}){/if}
								{/if}
								{if $status eq "Unpaid" || $status eq "Draft"}
									<div class="payment-form" data-btntext="{$LANG.makepayment}" data-btnsubscribetext="Subscribe">
										{$paymentbutton}
									</div>
								{/if}
							</div>
						</div>

						{if $manualapplycredit}
							<div menuitemname="Add Funds" class="panel panel-sidebar panel-invoice-info panel-apply-credit">
								<div class="panel-body">
									<form method="post" action="{$smarty.server.PHP_SELF}?id={$invoiceid}">
										<input type="hidden" name="applycredit" value="true">                              
										<div class="total">
											<span class="text-muted">{$LANG.invoiceaddcreditdesc1}:</span>
											<span class="total-price">{$totalcredit}</span>
										</div>
										<div class="form-group">
											<label class="control-label">{$LANG.invoiceaddcreditamount}</label>
											<input type="text" name="creditamount" value="{$creditamount}" class="form-control" />
										</div>
										<input type="submit" value="{$LANG.invoiceaddcreditapply}" class="btn btn-block btn-success" />
									</form>    
								</div>
							</div>
						{/if}
					{/if}
					<div menuitemname="Client Details" class="panel panel-sidebar">
						<div class="panel-heading">
							<h3 class="panel-title">
								<i class="fas fa-location-arrow"></i>&nbsp;{$LANG.actions}<i class="fas fa-chevron-up panel-minimise pull-right"></i>
							</h3>
						</div>
						<div class="list-group">
							<a href="javascript:window.print()" class="list-group-item list-group-item-action"><i class="fas fa-print fa-fw"></i>&nbsp;{$LANG.print}</a>
							<a href="dl.php?type=i&amp;id={$invoiceid}" class="list-group-item list-group-item-action"><i class="fas fa-download fa-fw"></i>&nbsp;{$LANG.invoicesdownload}</a>
							<a href="clientarea.php?action=invoices" class="list-group-item list-group-item-action"><i class="fas fa-chevron-double-left fa-fw"></i>&nbsp;{$LANG.goback}</a>
						</div>
					</div>
				</div>
				
			</div>
		{/if}
	</div>
	
    <div id="fullpage-overlay" class="w-hidden">
        <div class="outer-wrapper">
            <div class="inner-wrapper">
                <img src="{$WEB_ROOT}/assets/img/overlay-spinner.svg" alt="">
                <br>
                <span class="msg"></span>
            </div>
        </div>
    </div>
	
	{if $paymentmodule neq "payfast"}
	<script>
	$(document).ready(function() {
		$(".payment-form").length > 0 
			var s = $(".payment-form").data("btntext"),
				o = $(".payment-form").data("btnsubscribetext");
			$(".payment-form").find('input[type="image"]').attr("type", "submit").attr("value", s).addClass("btn btn-primary"),
			$(".payment-form").find('.btn').addClass("btn-sm"),
			$("#paynow").html(s).attr("style", "color: #fff").addClass("btn");
			
			var c = $(".payment-form").find("form").length;
			2 == c && $(".payment-form").find("form:first").find('input[type="submit"]').attr("value", o)
		
	});
	</script>
	{/if}
	
{if $themesettings.clientarea.viandq eq "outer-layout"}
</body>
</html>
{else}
{include file="{$template}/footer.tpl"}
{/if}
