<div id="order-standard_cart">
	<div class="row">
		<div class="col-md-12">
			<div class="d-flex aling-items-center justify-content-center text-center">
				<div class="header-lined mb-3">
					<h1>
						{$productGroup.name}
					</h1>
					{if $productGroup.headline}
						<div class="text-muted mt-2">{$productGroup.headline}</div>
					{/if}
					{if $productGroup.tagline}
						<div class="text-muted mt-2">{$productGroup.tagline}</div>
					{/if}
				</div>
			</div>
			
			{if $showSidebarToggle}
			<div class="TM-categories-options d-flex justify-content-center">
				<a data-toggle="modal" data-target="#cat-opt" class="btn btn-primary btn-xs mb-2">
					<i class="fas fa-search-plus"></i> {$LANG.showMenu}
				</a>
			</div>
			<hr class="separator">
			{/if}
			
			{if $errormessage}
				<div class="alert alert-danger">
					{$errormessage}
				</div>
			{elseif !$productGroup}
				<div class="alert alert-info">
					{lang key='orderForm.selectCategory'}
				</div>
			{/if}
		</div>

		<div class="col-md-12">
			<div id="order-clouder">
				<div id="products" class="cros-pricing-container">
					<div class="swiper" id="pricing-tables">
						<div class="row row-eq-height flex-nowrap pricing-slider swiper-wrapper">
						{foreach $products as $key => $product}
							{$idPrefix = ($product.bid) ? ("bundle"|cat:$product.bid) : ("product"|cat:$product.pid)}
							<div class="col-12 col-md-6 col-lg-4 col-xl-3 products-slide">
								<div class="cros-pricing-table overflow-hidden light fixed-height {if $product.isFeatured}active{/if}">	
									<h4 id="{$idPrefix}-name">{$product.name}
										{if $product.stockControlEnabled}
											<span class="small text-muted">
												<br />{$product.qty} {$LANG.orderavailable}
											</span>
										{/if}								
									</h4>
									{if $product.features}
										{if $product.featuresdesc}
											<div class="desc mb-0">
												{$product.featuresdesc}
											</div>
										{/if}
									{/if}
									<div id="{$idPrefix}-price">
										{if $product.bid}
											<div class="small text-muted">{$LANG.bundledeal}</div>
											{if $product.displayprice}
												<span class="text-secondary bolder" style="font-size: 33px;">{$product.displayPriceSimple}</span>
											{/if}
										{/if}
										<div class="price d-block">
											{if $product.bid}
											{elseif $product.paytype eq "free"}
												<mark>{$LANG.orderfree}</mark>
											{elseif $product.paytype eq "onetime"}
												<span class="cost">{$product.pricing.minprice.simple}</span><br />{$LANG.orderpaymenttermonetime}
											{else}
											
												{if $product.pricing.hasconfigoptions}
													{$LANG.from}<br />
												{/if}
												
												<span class="cost">{$product.pricing.minprice.price}</span>
												<span class="cycle">{if $product.pricing.minprice.cycle eq "monthly"}
													/{$LANG.pricingCycleShort.monthly}
												{elseif $product.pricing.minprice.cycle eq "quarterly"}
													/{$LANG.pricingCycleShort.quarterly}
												{elseif $product.pricing.minprice.cycle eq "semiannually"}
													/{$LANG.pricingCycleShort.semiannually}
												{elseif $product.pricing.minprice.cycle eq "annually"}
													/{$LANG.pricingCycleShort.annually}
												{elseif $product.pricing.minprice.cycle eq "biennially"}
													/{$LANG.pricingCycleShort.biennially}
												{elseif $product.pricing.minprice.cycle eq "triennially"}
													/{$LANG.pricingCycleShort.triennially}
												{/if}</span>
														
											{/if}
										</div>
										{if $product.pricing.minprice.setupFee}
											<div class="small text-muted">+ ({$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee})</div>
										{/if}																								
									</div>
									
									<a href="{if $themesettings.orderform.orderopc != ""}{$WEB_ROOT}/cart.php?a=add&{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}{else}{$product.productUrl}{/if}" class="btn btn-primary btn-block" style="margin-top: 10px;" id="{$idPrefix}-order-button"{if $product.hasRecommendations} data-has-recommendations="1"{/if}>
										{$LANG.ordernowbutton}
									</a>																
											
									<p class="PriceList-toggle collapsed" data-toggle="collapse" data-target="#PlanLists-{$idPrefix}">
										<span>Details</span>
									</p>

									{if $product.features}
										<ul class="plan-features collapse" id="PlanLists-{$idPrefix}">			
											{foreach $product.features as $feature => $value}
												<li id="{$idPrefix}-feature{$value@iteration}"><b>{$value}</b> {$feature}</li>
											{/foreach}
										</ul>
									{else}
										<div class="plan-features collapse" id="PlanLists-{$idPrefix}">
											{if strpos($product.description, 'custom-features') !== false}
												{$product.description|replace:'<br>':''|replace:'<br />':''}
											{else}
												{$product.description}
											{/if}
										</div>
									{/if}										
										
									{if $product.freedomain neq ""}
										<div class="mt-1 p-1 border rounded small text-muted text-center white border-secondary">{lang key="orderfreedomainonly"}</div>
									{/if}										

									
									{if $product.isFeatured}
									<!-- Popular plan sticker -->
										<div class="sticker-wrapper">
											<div class="sticker">
												{$LANG.featuredProduct}
											</div>
										</div>
									<!-- //End popular plan sticker-->
									{/if}					
										
								</div>
							</div>
									
									
						{/foreach}
						</div>
					</div>
					<div class="swiper-pagination pricing-tables"></div>
				</div>
						
			</div>
			
			{if $productGroup.features|@count > 0}
				
				<div class="space-30"></div>
				
				<div class="block-s3 p-0">
					<div class="text-center">
						<h2 class="no-margin h3">{$LANG.orderForm.includedWithPlans}</h2>
					</div>
				</div>
					
				<hr class="separator"></hr>
				
				<div class="cart-features no-margin-top">							
					<div class="includes-features">
						<ul class="list-features">
							{foreach $productGroup.features as $features}
								<li>{$features.feature}</li>
							{/foreach}
						</ul>
					</div>
				</div>
			{/if}
			
		</div>
	</div>
	
	
</div>
			
{include file="orderforms/{$carttpl}/categories-options.tpl"}
{include file="orderforms/{$carttpl}/recommendations-modal.tpl"}

<script>
	$(document).ready(function() {		
		var swiper = new Swiper('#pricing-tables', {
		  slidesPerView: 1,
		  preventClicks: true,
		  slideClass: 'products-slide',
		  pagination: {
			el: '.swiper-pagination.pricing-tables',
			clickable: true,
		  },
		  breakpoints: {
			0: {
				slidesPerView: 1
			},
			768: {
			  slidesPerView: 2
			},
			992: {
			  slidesPerView: 3
			},
			1200: {
			  slidesPerView: 4
			},
		  }
		  
		});
	});

	jQuery('.select2-single').select2();
	
	function redirectToCartPage()
	{
		var path = jQuery('#gidForm').val();
		if (path) {
			window.location.href = path;
		}
	}	
</script>