class DedicatedServerList {
    static get toolbox() {
        return {
            title: 'Dedicated Server Plans',
            icon: '<i class="fas fa-server"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            header: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true
            }, promo: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            table: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	 <div class="form">
		<div class="section_header">
			<label>Dedicated Server Plans<a class="sec-docs" href="https://docs.thememetro.com/#Sec-DedicatedServerPlans" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Descriptions</label>
					<textarea class="wsinput form-control" style="text-align:left"></textarea>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Button Text</label>
							<input type="text" class="form-control tablebtntext" placeholder="i.e., Add to Cart" value="" />
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Latest Offer Badge</label>
							<input type="text" class="form-control promoc" placeholder="i.e., 30% OFF first month" value="" />
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">			
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Background Type</label>
							<select type="select" class="form-control blockbgcolor">
								<option value="">None</option>
								<option value="light">Light</option>
							</select>
						</div>
					</div>
					 <div class="col-md-6">
						<div class="form-group">
							<label>Border</label>
							<select type="select" class="form-control blockborders">
								<option value="">None</option>
								<option value="border-top">Top Border</option>
								<option value="border-bottom">Bottom Border</option>
							</select>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blocktheight">
							  <option value="">Default</option>
							  <option value="1">60px</option>
							  <option value="2">30px</option>
							  <option value="3">None</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
							  <option value="">Default</option>
							  <option value="1">60px</option>
							  <option value="2">30px</option>
							  <option value="3">None</option>
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Table Settings</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-6 pt_bs_order">
					   <div class="form-group">
						  <label>Billing Cycle Order</label>
						  <select type="select" class="form-control bscorder">
							<option value="">Descending</option>
							<option value="1">Ascending</option>
						  </select>
					   </div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
						  <label>list count</label>
						   <select type="select" class="form-control laitems">
							  <option value="10">10</option>
							  <option value="15">15</option>
							  <option value="20">20</option>
							  <option value="25">25</option>
							  <option value="30">30</option>
							</select>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Disable the billing cycle switcher and display the pricing for the first available billing cycle..</span>
						<label class="switch">
							<input type="checkbox" class="form-control success disable_switcher" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>				
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, the shadow effect will be disabled for the tables container.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success boxshadow" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-1">
				<h5>Table Labels</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-1" class="collapse">
				<p class="help-block">If left empty, the default labels will be shown in English only.</p>
				<div class="sec_groups">
					<div class="row">
					   <div class="col-md-4">
						  <div class="form-group">
							 <label>Server Model</label>
							 <input type="text" class="form-control modeltext" placeholder="i.e., Server Model" value="" />
						  </div>					   
						</div> 
						<div class="col-md-4">
						  <div class="form-group">
							 <label>Processor</label>
							 <input type="text" class="form-control processortext" placeholder="i.e., Processor" value="" />
						  </div>
						</div>
						<div class="col-md-4">
						  <div class="form-group">
							 <label>Speed</label>
							 <input type="text" class="form-control speedtext" placeholder="i.e., Speed" value="" />
						  </div>
						</div>
						<div class="col-md-4">
						  <div class="form-group">
							 <label>Memory</label>
							 <input type="text" class="form-control memorytext" placeholder="i.e., Memory" value="" />
						  </div>
						</div>
						<div class="col-md-4">
						  <div class="form-group">
							 <label>Hard Drive</label>
							 <input type="text" class="form-control hddtext" placeholder="i.e., Hard Drive" value="" />
						  </div>
						</div>
						<div class="col-md-4">
						  <div class="form-group">
							 <label>Bandwidth</label>
							 <input type="text" class="form-control bandwidthtext" placeholder="i.e., Bandiwdth" value="" />
						  </div>
						</div>						
					</div>
				</div>
			</div>
			<div style="margin-top: 10px;">
				<div class="vjsGrid"></div>
			</div>
		</div>
	</div>
</div>
<div class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit product</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Product: </label>
					<select type="select" class="form-control plan">${productsSelect}</select>
                </div>
                <div class="form-group">
					<div class="flex-checkbox">
					  <span class="control-label">Enable this if you want highlight this product.</span>
                      <label class="switch">
					    <input type="checkbox" class="success featured">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
                <div class="form-group">
                    <label>Server Model</label>
                    <input type="text" class="form-control model" placeholder="EL1" />
                </div>
                <div class="form-group">
                    <label>Processor</label>
                    <input type="text" class="form-control processor" placeholder="Intel Xeon 5650" />
                </div>
                <div class="form-group">
                    <label>Speed</label>
                    <input type="text" class="form-control speed" placeholder="4 Cores x 2.8 GHz" />
                </div>
                <div class="form-group">
                    <label>Memory</label>
                    <input type="text" class="form-control memory" placeholder="1GB" />
                </div>
                <div class="form-group">
                    <label>Hard Drives</label>
                    <input type="text" class="form-control hdds" placeholder="100GB" />
                </div>
                <div class="form-group">
                    <label>Bandwidth</label>
                    <input type="text" class="form-control bandwidth" placeholder="1000GB" />
                </div>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary savedataid">Submit</button> 
			</div>
		</div>
	</div>
</div>`);

        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const modeltext = this.data && this.data.ModelText ? this.data.ModelText : "";
        $(wrapper).find(".modeltext").val(modeltext);
        const processortext = this.data && this.data.ProcessorText ? this.data.ProcessorText : "";
        $(wrapper).find(".processortext").val(processortext);
        const speedtext = this.data && this.data.SpeedText ? this.data.SpeedText : "";
        $(wrapper).find(".speedtext").val(speedtext);
        const memorytext = this.data && this.data.MemoryText ? this.data.MemoryText : "";
        $(wrapper).find(".memorytext").val(memorytext);
        const hddtext = this.data && this.data.HardDriveText ? this.data.HardDriveText : "";
        $(wrapper).find(".hddtext").val(hddtext);
        const bandwidthtext = this.data && this.data.BandwidthText ? this.data.BandwidthText : "";
        $(wrapper).find(".bandwidthtext").val(bandwidthtext);
        const tablebtntext = this.data && this.data.btntext ? this.data.btntext : "";
        $(wrapper).find(".tablebtntext").val(tablebtntext);
        const bscorder = this.data && this.data.bsco ? this.data.bsco : "";
        $(wrapper).find(".bscorder").val(bscorder);
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "10";
        $(wrapper).find(".laitems").val(laitems);
        const blocktheight = this.data && this.data.btheight ? this.data.btheight : "";
        $(wrapper).find(".blocktheight").val(blocktheight);
        const blockbheight = this.data && this.data.bbheight ? this.data.bbheight : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
		
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked','checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		if (this.data.DisableSwitcher === true) {
            $(wrapper).find('.disable_switcher').attr('checked', 'checked');
        }		
		
        const wsinput = this.data && this.data.header ? this.data.header : "";
        const wsinput2 = this.data && this.data.promo ? this.data.promo : "";
		
		function getPlanNameById(plans, id) {
			var plan = plans.find(function(plan) {
				return plan.id === id;
			});
			return plan ? plan.name : "Unknown Plan";
		}
		
        $(wrapper).find(".promoc").val(wsinput2);
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
						var planId = args.item.Plan;
						var planName = getPlanNameById(plans, planId);
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the product <b> \"" + planName + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{name: "Plan", title: "Products", type: "select", width: 400, items: plans, valueField: "id", textField: "name", align: "left", css: "grid-info-block"},
                {name: "Model", type: "text", width: 50, visible: false, sorting: false},
                {name: "Processor", type: "text", width: 100, visible: false, sorting: false},
                {name: "Speed", type: "text", width: 100, visible: false, sorting: false},
                {name: "Memory", type: "text", width: 100, visible: false, sorting: false},
                {name: "Hard Drives", type: "text", width: 100, visible: false, sorting: false},
                {name: "Bandwidth", type: "text", width: 100, visible: false, sorting: false},
				{name: "Featured", type: "checkbox", title: "Featured", visible: false, sorting: false},                
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, product) {		
            if (dialogType === "Add") product = {
                Plan: 0,
                Featured: 0,
                Processor: '',
                Speed: '',
				Memory: '',
				Bandwidth: '',
				Model: '',
				'Hard Drives' : ''			
            };
            $(wrapper).find(".plan").val(product.Plan);
			$(wrapper).find(".model").val(product.Model);
            $(wrapper).find(".processor").val(product.Processor);
			$(wrapper).find(".speed").val(product.Speed);
            $(wrapper).find(".memory").val(product.Memory);
			$(wrapper).find(".hdds").val(product['Hard Drives']);		
			$(wrapper).find(".bandwidth").val(product.Bandwidth);
            $(wrapper).find(".featured").prop('checked', product.Featured);
			$(wrapper).find(".plan").select2().trigger("change");
		
            formSubmitHandler = function () {
                saveProduct(product, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .plan").prop("selectedIndex") === -1) {
			  alert('Please select a product from the list.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .model").val() === "") {
			  alert('Model is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .processor").val() === "") {
			  alert('Processor is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .speed").val() === "") {
			  alert('Speed is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .memory").val() === "") {
			  alert('Memory is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .hdds").val() === "") {
			  alert('Hard Drives is required.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .bandwidth").val() === "") {
			  alert('Bandwidth is required.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var saveProduct = function (product, isNew) {
            const updatedProduct = {
                Plan: parseInt($(wrapper).find(".plan").val()),
                Model: $(wrapper).find(".model").val(),
				Processor: $(wrapper).find(".processor").val(),
                Speed: $(wrapper).find(".speed").val(),
				Memory: $(wrapper).find(".memory").val(),
				'Hard Drives': $(wrapper).find(".hdds").val(),
				Bandwidth: $(wrapper).find(".bandwidth").val(),
				Featured: $(wrapper).find(".featured").is(':checked')
            };

            if (isNew) $(wrapper).find(".vjsGrid").jsGrid("insertItem", updatedProduct);
            else $(wrapper).find(".vjsGrid").jsGrid("updateItem", product, updatedProduct);

            $(wrapper).find(".modal").modal('hide');
        };
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(wsinput);
        }, 200);         
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".boxshadow").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var DisableSwitcher = $(blockContent).find(".disable_switcher").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "btntext": $(blockContent).find(".tablebtntext").val(),
			"bsco": $(blockContent).find(".bscorder").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "btheight": $(blockContent).find(".blocktheight").val(),
            "bbheight": $(blockContent).find(".blockbheight").val(),
            "header": $(blockContent).find(".wsinput").val(),
            "promo": $(blockContent).find(".promoc").val(),
            "ModelText": $(blockContent).find(".modeltext").val(),
            "ProcessorText": $(blockContent).find(".processortext").val(),
            "SpeedText": $(blockContent).find(".speedtext").val(),
            "MemoryText": $(blockContent).find(".memorytext").val(),
            "HardDriveText": $(blockContent).find(".hddtext").val(),
            "BandwidthText": $(blockContent).find(".bandwidthtext").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
			"DisableSwitcher": DisableSwitcher,			
			"noshadow": status,
			"sechidden": sechidden
        };
    }
}