class ProductPriceListTwo {
    static get toolbox() {
        return {
            title: 'VPS Hosting Plans',
            icon: '<i class="fas fa-server"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            footer: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>VPS Hosting Plans<a class="sec-docs" href="https://docs.thememetro.com/#Sec-VPSHostingPlans" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
			   <div class="row">
				   <div class="col-md-6">
					   <div class="form-group">
						  <label>Background Type</label>
						  <select type="select" class="form-control blockbgcolor">
							 <option value="">None</option>
							 <option value="light">Light</option>
						  </select>
					   </div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
						   <label>Border</label>
						   <select type="select" class="form-control blockborders">
							  <option value="">None</option>
							  <option value="border-top">Top Border</option>
							  <option value="border-bottom">Bottom Border</option>
						   </select>
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Section Action</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Button Text</label>
					<input type="text" class="form-control tablebtntext" placeholder="i.e., Signup Now" value="" />
				</div>
			</div>
			<div class="heading">
				<h5>Table Settings</h5>
			</div>	
			<div class="sec_groups">
				<div class="pt_bs_order">
					<div class="form-group">
						<label>Pricing Display Order</label>
						<select type="select" class="form-control bscorder">
							<option value="">Descending</option>
							<option value="1">Ascending</option>
						</select>
					</div>
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Disable the billing cycle switcher and display the pricing for the first available billing cycle..</span>
						<label class="switch">
							<input type="checkbox" class="form-control success disable_switcher" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>				
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, the shadow effect will be disabled for the tables container.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success boxshadow" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>				
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-1">
				<h5>Table Labels</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-1" class="collapse">
				<p class="help-block">If left empty, the default labels will be shown in English only.</p>
				<div class="sec_groups">
					<div class="row">
					   <div class="col-md-3">
						  <div class="form-group">
							 <label>CPU</label>
							 <input type="text" class="form-control cputext" placeholder="i.e., CPU" value="" />
						  </div>					   
						</div> 
						<div class="col-md-3">
						  <div class="form-group">
							 <label>RAM</label>
							 <input type="text" class="form-control ramtext" placeholder="i.e., RAM" value="" />
						  </div>
						</div>
						<div class="col-md-3">
						  <div class="form-group">
							 <label>Storage</label>
							 <input type="text" class="form-control storagetext" placeholder="i.e., Storage" value="" />
						  </div>
						</div>
						<div class="col-md-3">
						  <div class="form-group">
							 <label>Bandwidth</label>
							 <input type="text" class="form-control datatext" placeholder="i.e., Bandwidth" value="" />
						  </div>
						</div>						
					</div>
				</div>
			</div>
			<div style="margin-top: 10px;">
				<div class="vjsGrid"></div>
			</div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit product</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Product</label>
					<select type="select" class="form-control plan">${productsSelect}</select>
                </div>
                <div class="form-group">
                    <label>Tab Label</label>
                    <input type="text" class="form-control tablabel" placeholder="Level 1" />
                </div>
				<div class="row">
				 <div class="col-sm-3">
                  <div class="form-group">
                      <label>CPU</label>
                      <input type="text" class="form-control cpu" placeholder="1 Core" />
                  </div>
				 </div>
				 <div class="col-sm-3">
                  <div class="form-group">
                      <label>RAM</label>
                      <input type="text" class="form-control ram" placeholder="1GB" />
                  </div>
				 </div>
				 <div class="col-sm-3">
                   <div class="form-group">
                      <label>Storage</label>
                      <input type="text" class="form-control storage" placeholder="100GB" />
                   </div>
				 </div>
				 <div class="col-sm-3">
                   <div class="form-group">
                      <label>Bandwidth</label>
                      <input type="text" class="form-control bandwidth" placeholder="1000GB" />
                   </div>
				 </div>
				</div>
                  <div class="form-group">
                    <label>Footer Note:</label>
					<textarea type="text" rows="5" class="form-control footertext"></textarea>
                  </div>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary savedataid">Submit</button> 
			</div>
		</div>
	</div>
</div>`);

        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const cputext = this.data && this.data.CpuText ? this.data.CpuText : "";
        $(wrapper).find(".cputext").val(cputext);
        const ramtext = this.data && this.data.RamText ? this.data.RamText : "";
        $(wrapper).find(".ramtext").val(ramtext);
        const storagetext = this.data && this.data.StorageText ? this.data.StorageText : "";
        $(wrapper).find(".storagetext").val(storagetext);
        const datatext = this.data && this.data.DataText ? this.data.DataText : "";
        $(wrapper).find(".datatext").val(datatext);
        const tablebtntext = this.data && this.data.btntext ? this.data.btntext : "";
        $(wrapper).find(".tablebtntext").val(tablebtntext);
        const bscorder = this.data && this.data.bsco ? this.data.bsco : "";
        $(wrapper).find(".bscorder").val(bscorder);
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked', 'checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		if (this.data.DisableSwitcher === true) {
            $(wrapper).find('.disable_switcher').attr('checked', 'checked');
        }			
        const wsinput = this.data && this.data.footer ? this.data.footer : "";
		
		function getPlanNameById(plans, id) {
			var plan = plans.find(function(plan) {
				return plan.id === id;
			});
			return plan ? plan.name : "Unknown Plan";
		}

        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
						var planId = args.item.Plan;
						var planName = getPlanNameById(plans, planId);
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the product <b> \"" + planName + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{name: "Plan", title: "Products", type: "select", width: 400, items: plans, valueField: "id", textField: "name", align: "left", css: "grid-info-block"},
                {name: "Tab Title", type: "text", width: 100, visible: false, sorting: false},
                {name: "CPU", type: "text", width: 100, visible: false, sorting: false},
                {name: "Ram", type: "text", width: 100, visible: false, sorting: false},
                {name: "Storage", type: "text", width: 100, visible: false, sorting: false},
                {name: "Bandwidth", type: "text", width: 100, visible: false, sorting: false},                           
                {name: "Footer Text", type: "textarea", width: 300, visible: false, sorting: false},
                {type: "control", editButton: false,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, product) {
            if (dialogType === "Add") product = {
                Plan: 0,
                CPU: '',
                Ram: '',
				Storage: '',
				Bandwidth: '',
				'Footer Text': '',
				'Tab Title' : ''			
            };
            $(wrapper).find(".plan").val(product.Plan);
			$(wrapper).find(".tablabel").val(product['Tab Title']);
            $(wrapper).find(".cpu").val(product.CPU);
            $(wrapper).find(".ram").val(product.Ram);
			$(wrapper).find(".storage").val(product.Storage);
			$(wrapper).find(".bandwidth").val(product.Bandwidth);
			$(wrapper).find(".plan").select2().trigger("change");
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $footerText = $('#' + modalId).find('.footertext');

				if (!$footerText.next('.trumbowyg-box ').length) {
					$footerText.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$footerText.trumbowyg('html', product['Footer Text']);
			});			
		
            formSubmitHandler = function () {
                saveProduct(product, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .plan").prop("selectedIndex") === -1) {
			  alert('Please select a product from the list.');
			  e.preventDefault();
			} else if ($(".ce-block--focused .tablabel").val() === "") {
			   alert('Tab Label is required.');
			   e.preventDefault();
			} else if ($(".ce-block--focused .cpu").val() === "") {
			   alert('CPU is required.');
			   e.preventDefault();
			} else if ($(".ce-block--focused .ram").val() === "") {
			   alert('RAM is required.');
			   e.preventDefault();
			} else if ($(".ce-block--focused .storage").val() === "") {
			   alert('Storage is required.');
			   e.preventDefault();
			} else if ($(".ce-block--focused .bandwidth").val() === "") {
			   alert('Bandwidth is required.');
			   e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

        var saveProduct = function (product, isNew) {
            const updatedProduct = {
                Plan: parseInt($(wrapper).find(".plan").val()),
				'Tab Title': $(wrapper).find(".tablabel").val(),
                CPU: $(wrapper).find(".cpu").val(),
                Ram: $(wrapper).find(".ram").val(),
				Storage: $(wrapper).find(".storage").val(),
				Bandwidth: $(wrapper).find(".bandwidth").val(),
				'Footer Text': $(wrapper).find(".footertext").val()
            };

            if (isNew) $(wrapper).find(".vjsGrid").jsGrid("insertItem", updatedProduct);
            else $(wrapper).find(".vjsGrid").jsGrid("updateItem", product, updatedProduct);

            $(wrapper).find(".modal").modal('hide');
        };
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(wsinput);
        }, 200);
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".boxshadow").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var DisableSwitcher = $(blockContent).find(".disable_switcher").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "btntext": $(blockContent).find(".tablebtntext").val(),
            "bsco": $(blockContent).find(".bscorder").val(),
			"DisableSwitcher": DisableSwitcher,
            "CpuText": $(blockContent).find(".cputext").val(),
            "RamText": $(blockContent).find(".ramtext").val(),
            "StorageText": $(blockContent).find(".storagetext").val(),
            "DataText": $(blockContent).find(".datatext").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "footer": $(blockContent).find(".wsinput").val(),
            "noshadow": status,
			"sechidden": sechidden
        };
    }
}