class features {
    static get toolbox() {
        return {
            title: 'Features',
            icon: '<i class="fas fa-stars"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, 
			subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Features<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Features" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="bg-primary">Primary</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="graphics">Graphic</option>
					</select>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Graphic</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bggraphic" class="form-control bggraphic" value="" />
							<span onclick="PageGraphics('${this.data.id}-bggraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				    <div class="row">
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Opacity</label>
						 <select type="select" class="form-control bgopacity">
						  <option value="">Dark</option>
						  <option value="1">Light</option>
						  <option value="2">None</option>
						 </select>
					   </div>
					 </div>
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Text Color</label>
						 <select type="select" class="form-control textcolor">
						   <option value="">Light</option>
							<option value="text-dark">Dark</option>
						 </select>
					   </div>
					 </div>					   
				    </div>					
				</div>
			</div>
			<div class="sborderinput">
				<div class="heading">
					<h5>Section Border & Spacing</h5>
				</div>
				<div class="sec_groups">			
				  <div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				  </div>
				  <div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				  </div>			  
				</div>
			</div>
			<div class="heading">
				<h5>Features Settings</h5>
			</div>
			<div class="sec_groups">
				<div class="row">					
					<div class="col-md-4">
						<div class="form-group">
							<label>Feature Style</label>
							<select type="select" class="form-control itemtype">
								<option value="">Default</option>
								<option value="1">Boxed</option>
								<option value="2">Bordered</option>
							</select>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label>Feature Icon Style</label>
							<select type="select" class="form-control icontype">
								<option value="">Default</option>
								<option value="circle">Circle</option>
								<option value="square">Square</option>
							</select>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label>Feature Graphic Position</label>
							<select type="select" class="form-control iconposition">
								<option value="">left</option>
								<option value="1">Top</option>
							</select>
							<span class="small">It will always align to the "Top" when centered..</span>
						</div>
					</div>					
					<div class="col-md-4">
						<div class="form-group">
							<label>Feature Graphic Size</label>
							<select type="select" class="form-control itemsize">
								<option value="">Default</option>
								<option value="auto">Auto</option>
								<option value="lg">Large</option>
								<option value="sm">Small</option>
							</select>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
						  <label>list count</label>
						  <input type="text" class="form-control laitems" value="" />
						</div>
					</div>					
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, all feature item will be displayed centered.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success centered" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>			
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Display features on slider instead of grid.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success displayinslider" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
				<div class="SliderOptions">
					<div class="form-group">
						<select type="select" class="form-control slidertype">
							<option value="">Slider with dots or bullet indicators at the bottom</option>
							<option value="1">Slider with "left" and "right" navigation arrows</option>
						</select>
					</div>
				</div>				
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>		
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Features Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-panel">
					<div class="form-group">
						<label>Item Title</label>
						<input type="text" class="form-control feature_title">
					</div>
					<div class="form-group">
						<label>Item Description</label>
						<textarea type="text" type="text" rows="7" class="form-control feature_description"></textarea>
					</div>
					<div class="form-group">
						<label>Item Graphic</label>
						<input type="medialib" class="form-control feature_graphic">
					</div>
					<div class="small">
						<p>The minimum image size is 100px by 100px, and the accepted ratio should be square.</p>
					</div>
				</div>
				<div class="collapsed_panel">
					<div class="heading collapsed" data-toggle="collapse">
						<h5>Item Link</h5>
						<button type="button" class="heading_btn">
							<span class="heading_btn_text">Expand</span>
							<span class="heading_btn_text">Hide</span>
							<span class="fal fa-angle-down"></span>
						</button>
					</div>
					<div class="well collapse">
						<div class="form-group">
							<label>Link Text</label>
							<input type="text" class="form-control itembtntext" />
						</div>
						<div class="form-group">
							<label>Link Type</label>
							<select type="select" class="form-control linktype">
								<option value="">Custom URL</option>
								<option value="1">Page Manager</option>
								<option value="2">Product Group</option>
								<option value="3">Product</option>
							</select>
						</div>
						<div class="curl">
							<div class="form-group">
								<label>Link To</label>
								<input type="text" class="form-control bsblink" placeholder="add custom URL..">
							</div>
						</div>
						<div class="purl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control pagelink">${cmsPages}</select>
							</div>
						</div>
						<div class="gurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control grouplink">${groupSelect}</select>
							</div>
						</div>
						<div class="pdurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control productlink">${productsSelect}</select>
							</div>
						</div>							
					</div>
				</div>				
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
		const bggraphic = this.data && this.data.bggraphic ? this.data.bggraphic : "";
        $(wrapper).find(".bggraphic").val(bggraphic);
		const bgopacity = this.data && this.data.bgopacity ? this.data.bgopacity : "";
        $(wrapper).find(".bgopacity").val(bgopacity);
		const textcolor = this.data && this.data.textcolor ? this.data.textcolor : "";
        $(wrapper).find(".textcolor").val(textcolor);
		const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);		
		const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);		
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        const itemtype = this.data && this.data.itemtype ? this.data.itemtype : "";
        $(wrapper).find(".itemtype").val(itemtype);
		const slidertype = this.data && this.data.slidertype ? this.data.slidertype : "";
        $(wrapper).find(".slidertype").val(slidertype);
        const itemsize = this.data && this.data.itemsize ? this.data.itemsize : "";
        $(wrapper).find(".itemsize").val(itemsize);        
		const icontype = this.data && this.data.icontype ? this.data.icontype : "";
        $(wrapper).find(".icontype").val(icontype);		
		const iconposition = this.data && this.data.iconposition ? this.data.iconposition : "";
        $(wrapper).find(".iconposition").val(iconposition);
        if (this.data.centered === true) {
            $(wrapper).find('.centered').attr('checked', 'checked');
        }		
        if (this.data.DisplayInSlider === true) {
            $(wrapper).find('.displayinslider').attr('checked', 'checked');
        }		
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		function togglePanel(switcher, panel, showOnChecked = true) {
			if ($(wrapper).find(switcher).is(':checked') === showOnChecked) {
				$(wrapper).find(panel).show();
			} else {
				$(wrapper).find(panel).hide();
			}
		}
		$(wrapper).find('.displayinslider').on('change', function() {
			togglePanel('.displayinslider', '.SliderOptions');
		});
		
		togglePanel('.displayinslider', '.SliderOptions');

		
		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
		//
		function secOptions(wrapper, selector, condition) {
			$(wrapper).find(selector).toggleClass('hidden', !condition);
		}
		
		secOptions(wrapper, '.simginput', $(wrapper).find('.blockbgcolor').val() === 'graphics');

		$(wrapper).find('.blockbgcolor').on('change', function () {
			secOptions(wrapper, '.simginput', $(this).val() === 'graphics');
		});
		//
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the feature item </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var features = item;
				var graphicElement = "";
				if (features.graphic) {
					if (features.graphic.includes("fa-")) {
						graphicElement = "<span class='fa-fw " + features.graphic + "'></span>";
					} else {
						graphicElement = "<img src='" + whmcsBaseUrl + "/" + features.graphic + "' class='thumbnail_placeholder feature_icon'>";
					}
				}
				var $config = $("<div>").addClass("panel panel-default")
				
				if (features.title) {
					var itemdescription = features.description || "";
					$config.append(
						$("<div class='panel-heading'><h3 class='panel-title'>").html(graphicElement + " " + features.title)
					);					
				}
				
				if (features.description) {
					var itemdescription = features.description || "";
					$config.append(
						$("<div class='panel-body'>").html("" + features.description)
					);					
				}
				
				if (features.btnText || features.Link) {
					var linkText = features.btnText || "Learn more";
					var linkUrl = features.Link || "#"; 
					$config.append(
						$("<div class='panel-footer'>").html(
							$("<a>").attr("href", linkUrl).text(linkText)
						)
					);					
				}
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block custom-grid jsgrid-align-left").attr("width", "400px").append($config))
					.append($cButtons);
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{name: "title", title: "Feature Items", type: "text", width: 400},
				{name: "description", title: "Description", type: "textarea", visible: false, sorting: false},
                {name: "graphic", title: "Graphic", type: "text", visible: false, sorting: false},
                {name: "btnText", title: "Link Text", type: "text", visible: false, sorting: false},
                {name: "Link", title: "Link", type: "text", visible: false, sorting: false},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;
		var sectionId = this.data?.id || "";

        var showDetailsDialog = function (dialogType, features, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "feature_new_" : "feature_" + itemIndex;
			
			if (isNew) {
				features = {
					title: '',
					description: '',
					graphic: '',
					btnText: '',
					Link: ''
				};
			}

			$(wrapper).find('input[type="medialib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageMedia(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Graphic"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageMedia('" + uniqueId + "')");
				}
			});
			
			$(wrapper).find('.modal-body .collapsed_panel').each(function (index, element) {
				var uniqueId = sectionId + "_heading_" + index;
				var $panel = $(element);
				var $heading = $panel.find('.heading');
				var $well = $panel.find('.well');
				
				if ($heading.length) {
					$heading.attr("aria-controls", uniqueId);
					$heading.attr("href", "#" + uniqueId);
				}
				if ($well.length && $well.hasClass('collapse')) {
					$well.attr("id", uniqueId);
				}
				
				$well.removeClass('in');
				$heading.addClass('collapsed');				
				
			});			
			
            $(wrapper).find(".feature_title").val(features.title);
            $(wrapper).find(".feature_graphic").val(features.graphic);
			$(wrapper).find(".itembtntext").val(features.btnText);
			$(wrapper).find(".linktype").val(features.LinkType);
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $featuresDescription = $('#' + modalId).find('.feature_description');

				if (!$featuresDescription.next('.trumbowyg-box ').length) {
					$featuresDescription.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$featuresDescription.trumbowyg('html', features.description);
			});
			
			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
				{ selector: ".productlink", placeholder: 'Select a product' },
				{ selector: ".grouplink", placeholder: 'Select a products group' },
				{ selector: ".groupprice", placeholder: 'Select a product or group' }
			];

			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});

			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".bsblink").val(features.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(features.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".grouplink").val('');
						break;
					case '2':
						$(wrapper).find(".grouplink").val(features.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					case '3':
						$(wrapper).find(".productlink").val(features.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".grouplink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					default:
						$(wrapper).find(".bsblink").val(features.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//features.LinkType = $(this).val();
				updateLinkFields();
			});

			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl'),
					pdurl: $(wrapper).find('.pdurl'),
					gurl: $(wrapper).find('.gurl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
					case '2':
						LinkInputs.gurl.removeClass('hidden');
						break;
					case '3':
						LinkInputs.pdurl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);			
			
            formSubmitHandler = function () {
                saveFeatures(features, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };

		$(wrapper).find(".savedataid").click(function (e) {
			const title = $(".ce-block--focused .feature_title").val().trim();
			const description = $(".ce-block--focused .feature_description").val().trim();
			
			if (title === '' && description === '') {
				alert('A Title or Description is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
		});

		
        var saveFeatures = function (features, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".bsblink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				case '2':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '3':
					linkValue = $(wrapper).find(".productlink").val();
					break;
				default:
					linkValue = $(wrapper).find(".bsblink").val();
					break;
			}			
            $.extend(features, {
				title: $(wrapper).find(".feature_title").val(),
				description: $(wrapper).find(".feature_description").val(),
				graphic: $(wrapper).find(".feature_graphic").val(),
                btnText: $(wrapper).find(".itembtntext").val(),
                LinkType: $(wrapper).find(".linktype").val(),				
				Link: linkValue
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", features);
            $(wrapper).find(".modal").modal('hide');
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
		var centered = $(blockContent).find(".centered").is(':checked');
		var DisplayInSlider = $(blockContent).find(".displayinslider").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "bggraphic": $(blockContent).find(".bggraphic").val(),
			"bgopacity": $(blockContent).find(".bgopacity").val(),
			"textcolor": $(blockContent).find(".textcolor").val(),			
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),			
			"slidertype": $(blockContent).find(".slidertype").val(),
            "itemtype": $(blockContent).find(".itemtype").val(),
            "icontype": $(blockContent).find(".icontype").val(),
            "iconposition": $(blockContent).find(".iconposition").val(),
            "itemsize": $(blockContent).find(".itemsize").val(),
			"DisplayInSlider": DisplayInSlider,			
            "itemcounts": $(blockContent).find(".laitems").val(),
			"centered" : centered,
			"sechidden": sechidden
        };
    }
}