class tld_table {
    static get toolbox() {
        return {
            title: 'TLDs Table',
            icon: '<i class="fas fa-list"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, title: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>TLDs Table<a class="sec-docs" href="https://docs.thememetro.com/#Sec-TldsTable" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="bg-primary">Primary</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="graphics">Graphic</option>
					</select>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Graphic</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bggraphic" class="form-control bggraphic" value="" />
							<span onclick="PageGraphics('${this.data.id}-bggraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				    <div class="row">
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Opacity</label>
						 <select type="select" class="form-control bgopacity">
						  <option value="">Dark</option>
						  <option value="1">Light</option>
						  <option value="2">None</option>
						 </select>
					   </div>
					 </div>
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Text Color</label>
						 <select type="select" class="form-control textcolor">
						   <option value="">Light</option>
							<option value="text-dark">Dark</option>
						 </select>
					   </div>
					 </div>					   
				    </div>					
				</div>
			</div>
			<div class="sborderinput">
				<div class="heading">
					<h5>Section Border & Spacing</h5>
				</div>
				<div class="sec_groups">			
				  <div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				  </div>
				  <div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				  </div>			  
				</div>
			</div>
			<div class="heading">
				<h5>TLDs Table Settings</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
					<div class="col-md-3">
						<div class="form-group">
							<label>Domains per page</label>
							<select type="select" class="form-control tldpagelength">
								<option value="">10</option>
								<option value="25">25</option>
								<option value="50">50</option>
							</select>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, the shadow effect will be disabled for the TLDs table.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success boxshadow" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>			
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Display Grace & Redemption Period column.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success displaygrace" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>				
			</div>
		</div>
	</div>
</div>		
`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
		const bggraphic = this.data && this.data.bggraphic ? this.data.bggraphic : "";
        $(wrapper).find(".bggraphic").val(bggraphic);
		const bgopacity = this.data && this.data.bgopacity ? this.data.bgopacity : "";
        $(wrapper).find(".bgopacity").val(bgopacity);
		const textcolor = this.data && this.data.textcolor ? this.data.textcolor : "";
        $(wrapper).find(".textcolor").val(textcolor);
		const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);		
		const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);		
		const tldpagelength = this.data && this.data.PageLength ? this.data.PageLength : "";
        $(wrapper).find(".tldpagelength").val(tldpagelength);		        		 		       			        		
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked', 'checked');
        }		
        if (this.data.DisplayGrace === true) {
            $(wrapper).find('.displaygrace').attr('checked', 'checked');
        }		
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		
		//
		function secOptions(wrapper, selector, condition) {
			$(wrapper).find(selector).toggleClass('hidden', !condition);
		}
		
		secOptions(wrapper, '.simginput', $(wrapper).find('.blockbgcolor').val() === 'graphics');

		$(wrapper).find('.blockbgcolor').on('change', function () {
			secOptions(wrapper, '.simginput', $(this).val() === 'graphics');
		});
		//

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        return wrapper;
    }

    save(blockContent) {
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
		var noshadow = $(blockContent).find(".boxshadow").is(':checked');
		var DisplayGrace = $(blockContent).find(".displaygrace").is(':checked');
		
        return {
			"id": this.data.id,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "bggraphic": $(blockContent).find(".bggraphic").val(),
			"bgopacity": $(blockContent).find(".bgopacity").val(),
			"textcolor": $(blockContent).find(".textcolor").val(),			
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),
            "PageLength": $(blockContent).find(".tldpagelength").val(),
			"DisplayGrace": DisplayGrace,
			"noshadow" : noshadow,
			"sechidden": sechidden
        };
    }
}