{if $createSuccess}
    {include file="$template/includes/alert.tpl" type="success" msg="<i class='fas fa-check fa-fw'></i> {$LANG.paymentMethods.addedSuccess}"}
{elseif $createFailed}
    {include file="$template/includes/alert.tpl" type="warning" msg="<i class='fas fa-times fa-fw'></i> {$LANG.paymentMethods.addFailed}"}
{elseif $saveSuccess}
    {include file="$template/includes/alert.tpl" type="success" msg="<i class='fas fa-check fa-fw'></i> {$LANG.paymentMethods.updateSuccess}"}
{elseif $saveFailed}
    {include file="$template/includes/alert.tpl" type="warning" msg="<i class='fas fa-check fa-fw'></i> {$LANG.paymentMethods.saveFailed}"}
{elseif $setDefaultResult === true}
    {include file="$template/includes/alert.tpl" type="success" msg="<i class='fas fa-check fa-fw'></i> {$LANG.paymentMethods.defaultUpdateSuccess}"}
{elseif $setDefaultResult === false}
    {include file="$template/includes/alert.tpl" type="warning" msg="<i class='fas fa-times fa-fw'></i> {$LANG.paymentMethods.defaultUpdateFailed}"}
{elseif $deleteResult === true}
    {include file="$template/includes/alert.tpl" type="success" msg="<i class='fas fa-check fa-fw'></i> {$LANG.paymentMethods.deleteSuccess}"}
{elseif $deleteResult === false}
    {include file="$template/includes/alert.tpl" type="warning" msg="<i class='fas fa-times fa-fw'></i> {$LANG.paymentMethods.deleteFailed}"}
{/if}


{* <p>{$LANG.paymentMethods.intro}</p> *}

{if $client->payMethods->validateGateways()|@count != 0}
	<div class="TM-card card white p-0">
		<div class="cc-input-container">
			<div class="existing-cc-grid">
				<div class="card-list">
					{foreach $client->payMethods->validateGateways() as $payMethod}
						<div class="card-body p-0 border-bottom">
							<div class="card-item">
								<div class="card-item-icon ml-0">
									<i class="{$payMethod->getFontAwesomeIcon()} fa-fw bigger-150"></i>
								</div>
								<div class="card-item-name">
									<strong class="fw-500">{$payMethod->payment->getDisplayName()}</strong><br />
									{if $payMethod->description}
										<span class="small text-muted">{$payMethod->description}</span>
									{else}
										-
									{/if}								
								</div>
								<div class="card-item-status">
									<span class="label status-{$payMethod->getStatus()|lower}">{$payMethod->getStatus()}</span>								
								</div>
								<div class="card-item-actions">
									{if $payMethod->isDefaultPayMethod()}
										<span class="label label-default">{$LANG.paymentMethods.default}</span>
									{elseif !$payMethod->isExpired()}
										<a href="{routePath('account-paymentmethods-setdefault', $payMethod->id)}" class="btn btn-xs btn-default btn-set-default">
											{$LANG.paymentMethods.setAsDefault}
										</a>
									{/if}
									<a href="{routePath('account-paymentmethods-view', $payMethod->id)}" data-toggle="tooltip" data-placement="left" title="{$LANG.paymentMethods.edit}" class="btn btn-icon{if $payMethod->getType() == 'RemoteBankAccount'} disabled{/if}" data-role="edit-payment-method">
										<i class="fas fa-pencil icon-only"></i>
									</a>
									{if $allowDelete}
										<a href="{routePath('account-paymentmethods-delete', $payMethod->id)}" data-toggle="tooltip" data-placement="left" title="{$LANG.paymentMethods.delete}" class="btn btn-icon btn-delete">
											<i class="fas fa-trash icon-only"></i>
										</a>
									{/if}
								</div>
							</div>
						</div>
					{/foreach}
				</div>
			</div>
			<div class="card-footer bg-white border-top-0">	
				{if $allowCreditCard}
					<a href="{routePath('account-paymentmethods-add')}" class="btn btn-primary btn-sm" data-role="add-new-credit-card">
						{$LANG.paymentMethods.addNewCC}
					</a>
				{/if}
				{if $allowBankDetails}
					<a href="{routePathWithQuery('account-paymentmethods-add', null, 'type=bankacct')}" class="btn btn-primary btn-sm">
						{$LANG.paymentMethods.addNewBank}
					</a>
				{/if}
			</div>
		</div>
	</div>

{else}
	
	<div class="alert-lg no-data">
		<div class="icon">
			<i class="fas fa-exclamation-triangle"></i>
		</div>
		<div class="text">
			{$LANG.paymentMethods.noPaymentMethodsCreated}
		</div>
		{if $allowCreditCard}
			<a href="{routePath('account-paymentmethods-add')}" class="btn btn-primary" data-role="add-new-credit-card">
				{$LANG.paymentMethods.addNewCC}
			</a>
		{/if}
		{if $allowBankDetails}
			<a href="{routePathWithQuery('account-paymentmethods-add', null, 'type=bankacct')}" class="btn btn-default">
				{$LANG.paymentMethods.addNewBank}
			</a>
		{/if}
	</div>

{/if}

<form method="post" action="" id="frmDeletePaymentMethod">
	<div class="modal fade" id="modalPaymentMethodDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	  <div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title" id="myModalLabel">{$LANG.paymentMethods.areYouSure}</h5>
			<button type="button" class="close" data-dismiss="modal">
				<span aria-hidden="true">&times;</span>
				<span class="sr-only">{lang key='close'}</span>
			</button>
		  </div>
		  <div class="modal-body">
			<p>{$LANG.paymentMethods.deletePaymentMethodConfirm}</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">{$LANG.no}</button>
			<button type="submit" class="btn btn-primary">{$LANG.yes}</button>
		  </div>
		</div>
	  </div>
	</div>
</form>

<form method="post" action="" id="frmSetDefaultPaymentMethod"></form>

<script>
    jQuery(document).ready(function() {
        jQuery('.btn-set-default').click(function(e) {
            e.preventDefault();
            jQuery('#frmSetDefaultPaymentMethod')
                .attr('action', jQuery(this).attr('href'))
                .submit();
        });
        jQuery('.btn-delete').click(function(e) {
            e.preventDefault();
            jQuery('#frmDeletePaymentMethod')
                .attr('action', jQuery(this).attr('href'));
            jQuery('#modalPaymentMethodDeleteConfirmation').modal('show');
        });
    });
</script>
