{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


{include file="$template/includes/flashmessage.tpl"}

<div class="section">
    <div class="section-header d-flex align-items-center mb-5 border-bottom pb-3">
		<h4 class="m-0 h5">{lang key="userManagement.usersFound" count=$users->count()}</h4>
		<a href="#inviteNewUser" class="btn btn-primary ml-auto" data-toggle="modal">{lang key="userManagement.inviteNewUser"}</a>
	</div>
	<div class="section-body">
		{foreach $users as $user}
		<div class="TM-card white p-0">
			<div class="card-body">
				<div class="user-list">
					<div class="mr-auto">
						<div class="user-list-item">
							{if $themesettings.clientarea.gravatar}
							<div class="user-list-item-avatar">
								<img src="https://www.gravatar.com/avatar/{$user->email|md5}" />
							</div>
							{/if}
							<div class="user-list-item-profile">
								<span class="user-list-item-profile-name">
									<strong>{$user->first_name} {$user->last_name}</strong>
									{if $user->hasTwoFactorAuthEnabled()}
										<i class="fas fa-shield text-success" data-toggle="tooltip" data-placement="right" title="{lang key='twoFactor.enabled'}"></i>
									{else}
										<i class="fas fa-shield text-muted" data-toggle="tooltip" data-placement="right" title="{lang key='twoFactor.disabled'}"></i>
									{/if}
								</span>
								<span class="user-list-item-profile-email">{$user->email}</span>
								<span class="user-list-item-profile-lastlogin">
									{lang key="userManagement.lastLogin"}:
									{if $user->pivot->hasLastLogin()}
										{$user->pivot->getLastLogin()->diffForHumans()}
									{else}
										{$LANG.never}
									{/if}
								</span>
							</div>
						</div>
					</div>
					<div class="user-list-item-actions">
						{if $user->pivot->owner}
							<span class="label label-info">{lang key="clientOwner"}</span>
						{else}
						<div class="btn-group" role="group" aria-label="User list actions">
							<a href="{routePath('account-users-permissions', $user->id)}" class="btn btn-default btn-sm btn-manage-permissions"{if $user->pivot->owner} disabled="disabled"{/if} data-toggle="tooltip" data-placement="left" data-title="{lang key="userManagement.managePermissions"}">
								<i class="far fa-edit icon-only"></i>
							</a>
							<a href="#" class="btn btn-default btn-sm btn-remove-user" data-id="{$user->id}"{if $user->pivot->owner} disabled="disabled"{/if} data-toggle="tooltip" data-placement="left" data-title="{lang key="userManagement.removeAccess"}">
								<i class="far fa-times text-danger icon-only"></i>
							</a>
						</div>
						{/if}
					</div>
					
				</div>
			</div>
		</div>
		{/foreach}
		
		<p class="text-muted">* {lang key="userManagement.accountOwnerPermissionsInfo"}</p>
	</div>
</div>



{if $invites->count() > 0}
<div class="section">
    <div class="section-header mb-4">
		<h4 class="m-0 h5">{lang key="userManagement.pendingInvites"}</h4>
	</div>
	<div class="section-body">
		{foreach $invites as $invite}
		<div class="TM-card white p-0">
			<div class="card-body">
				<div class="user-list">
					<div class="mr-auto">
						<div class="user-list-item">
							{if $themesettings.clientarea.gravatar}
							<div class="user-list-item-avatar">
								<img src="https://www.gravatar.com/avatar/{$invite->email|md5}" />
							</div>
							{/if}
							<div class="user-list-item-profile">
								<span class="user-list-item-profile-email">{$invite->email}
								<span class="user-list-item-profile-lastlogin">
									{lang key="userManagement.inviteSent"}:
									{$invite->created_at->diffForHumans()}
								</span>
							</div>
						</div>
					</div>
					<div class="user-list-item-actions">
						<form method="post" action="{routePath('account-users-invite-resend')}">
							<input type="hidden" name="inviteid" value="{$invite->id}">
							<div class="btn-group" role="group" aria-label="User list actions">
								<button type="submit" class="btn btn-default btn-sm" data-toggle="tooltip" data-placement="left" data-title="{lang key="userManagement.resendInvite"}">
									<i class="far fa-sync"></i>
								</button>
								<button type="button" class="btn btn-default btn-sm btn-cancel-invite" data-id="{$invite->id}" data-toggle="tooltip" data-placement="left" data-title="{lang key="userManagement.cancelInvite"}">
									<i class="far fa-times text-danger icon-only"></i>
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
		{/foreach}
	</div>
</div>
{/if}





<form method="post" action="{routePath('account-users-invite')}">
	<div class="modal fade" id="inviteNewUser">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title m-0">
						{lang key="userManagement.inviteNewUser"}
					</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
					<p>{lang key="userManagement.inviteNewUserDescription"}</p>
					<div class="form-group">
						<input type="email" name="inviteemail" placeholder="name@example.com" class="form-control" value="{$formdata.inviteemail}">
					</div>
					<div class="form-group">
						<div class="radio">
							<label>
								<input class="icheck-control" type="radio" name="permissions" value="all" checked="checked">
								{lang key="userManagement.allPermissions"}
							</label>
						</div>
						<div class="radio">
							<label>
								<input class="icheck-control" type="radio" name="permissions" value="choose">
								{lang key="userManagement.choosePermissions"}
							</label>
						</div>
					</div>
					<div class="card p-3 light w-hidden" id="invitePermissions">
						{foreach $permissions as $permission}
							<div class="checkbox">
								<label>
									<input class="icheck-control" type="checkbox" name="perms[{$permission.key}]" value="1">
									{$permission.title}
										-
									{$permission.description}
								</label>
							</div>
						{/foreach}
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" class="btn btn-primary">
						{lang key="userManagement.sendInvite"}
					</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">
						{lang key="cancel"}
					</button>
				</div>
			</div>
		</div>
	</div>
</form>

<form method="post" action="{routePath('user-accounts')}">
    <input type="hidden" name="id" value="" id="inputSwitchAcctId">
</form>

<form method="post" action="{routePath('account-users-remove')}">
    <input type="hidden" name="userid" id="inputRemoveUserId">
    <div class="modal fade" id="modalRemoveUser">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header card-header">
                    <h4 class="modal-title m-0">
                        {lang key="userManagement.removeAccess"}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <p>{lang key="userManagement.removeAccessSure"}</p>
                    <p>{lang key="userManagement.removeAccessInfo"}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        {lang key="cancel"}
                    </button>
                    <button type="submit" class="btn btn-primary" id="btnRemoveUserConfirm">
                        {lang key="confirm"}
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<form method="post" action="{routePath('account-users-invite-cancel')}">
    <input type="hidden" name="inviteid" id="inputCancelInviteId">
    <div class="modal fade" id="modalCancelInvite">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header card-header">
                    <h4 class="modal-title m-0">
                        {lang key="userManagement.cancelInvite"}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <p>{lang key="userManagement.cancelInviteSure"}</p>
                    <p>{lang key="userManagement.cancelInviteInfo"}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        {lang key="cancel"}
                    </button>
                    <button type="submit" class="btn btn-primary" id="btnCancelInviteConfirm">
                        {lang key="confirm"}
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>


<script>
    jQuery(document).ready(function() {
        jQuery('input:radio[name=permissions]').change(function () {
            if (this.value === 'choose') {
                jQuery('#invitePermissions').slideDown();
            } else {
                jQuery('#invitePermissions').slideUp();
            }
        });
        jQuery('.btn-manage-permissions').click(function(e) {
            if (jQuery(this).attr('disabled')) {
                e.preventDefault();
            }
        });
        jQuery('.btn-remove-user').click(function(e) {
            e.preventDefault();
            if (jQuery(this).attr('disabled')) {
                return;
            }
            jQuery('#inputRemoveUserId').val(jQuery(this).data('id'));
            jQuery('#modalRemoveUser').modal('show');
        });
        jQuery('.btn-cancel-invite').click(function(e) {
            e.preventDefault();
            jQuery('#inputCancelInviteId').val(jQuery(this).data('id'));
            jQuery('#modalCancelInvite').modal('show');
        });
    });
</script>