{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $services}
{include file="$template/includes/tablelist.tpl" tableName="ServicesList" filterColumn="3" noSortColumns="4"}

<script>
    jQuery(document).ready( function () {
        var table = jQuery('#tableServicesList').show().DataTable();
        {if $orderby == 'product'}
            table.order([0, '{$sort}'], [3, 'asc']);
        {elseif $orderby == 'amount' || $orderby == 'billingcycle'}
            table.order(1, '{$sort}');
        {elseif $orderby == 'nextduedate'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'domainstatus'}
            table.order(3, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').hide();
    });
</script>


<div class="table-container clearfix">
	<div class="table-header">
		<label>{lang key='view'}</label>
		<div class="dropdown view-filter-btns">
			<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				<span>{lang key='domainRenewal.showAll'}</span> 
			</button>
			 <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenuButton">
				<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
				{foreach key=statustext item=count from=$services|@array_column:'statustext'|@array_count_values}
					<li><a href="#" class="dropdown-item"><span data-value="{$statustext}">{$statustext}</span></a></li>
                {/foreach}
			</ul>
		</div>		
	</div>
	
    <table id="tableServicesList" class="datatable table table-hover w-hidden">
        <thead>
            <tr>
                <th data-class="expand">{lang key='orderproduct'}</th>
                <th data-hide="phone,tablet">{lang key='clientareaaddonpricing'}</th>
                <th data-hide="phone,tablet">{lang key='clientareahostingnextduedate'}</th>
                <th data-hide="phone">{lang key='clientareastatus'}</th>
                <th class="col-small center"></th>
            </tr>
        </thead>
        <tbody>
            {foreach $services as $service}
                <tr onclick="clickableSafeRedirect(event, 'clientarea.php?action=productdetails&amp;id={$service.id}', false)">
                    <td>
						<b>{$service.group}</b> - {$service.product}
						{if $service.domain}<br />
							<div class="ssl-info" data-element-id="{$service.id}" data-type="service"{if $service.domain} data-domain="{$service.domain}"{/if}>
								{if $service.sslStatus}
									<img src="{$service.sslStatus->getImagePath()}" data-toggle="tooltip" title="{$service.sslStatus->getTooltipContent()}" class="{$service.sslStatus->getClass()}"/>
								{elseif !$service.isActive}
									<img src="{$BASE_PATH_IMG}/ssl/ssl-inactive-domain.png" data-toggle="tooltip" title="{lang key='sslState.sslInactiveService'}">
								{/if}
							</div>
							<a class="text-domain" href="http://{$service.domain}" target="_blank">{$service.domain}</a>
						{/if}						
					
					</td>
                    <td data-order="{$service.amountnum}">{$service.amount} <small class="cycle-text">{$service.billingcycle}</small></td>
                    <td><span class="w-hidden">{$service.normalisedNextDueDate}</span>{$service.nextduedate}</td>
                    <td><span class="label status status-{$service.status|strtolower}">{$service.statustext}</span></td>
                    <td class="col-small center">
						<a href="#" role="button" class="btn btn-link btn-sm" data-toggle="dropdown">
							<i class="fas fa-ellipsis-h"></i>
						</a>	
						<ul class="dropdown-menu dropdown-menu-right" role="menu">                                        
							<li><a class="dropdown-item" href="clientarea.php?action=productdetails&id={$service.id}">{$LANG.clientareaviewdetails}</a></li>
							{if $service.rawstatus == "active" && ($service.downloads || $service.addons || $service.packagesupgrade)}
								<li class="dropdown-divider"></li>
								{if $service.downloads} <li><a class="dropdown-item" href="clientarea.php?action=productdetails&id={$service.id}#tabDownloads">{$LANG.downloadstitle}</a></li>{/if}
								{if $service.addons} <li><a class="dropdown-item" href="clientarea.php?action=productdetails&id={$service.id}#tabAddons">{$LANG.clientareahostingaddons}</a></li>{/if}
								{if $service.packagesupgrade} <li><a class="dropdown-item" href="upgrade.php?type=package&id={$service.id}">{$LANG.upgradedowngradepackage}</a></li>{/if}
							{/if}                                        
						</ul>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
</div>

{else}
<div class="alert-lg no-data">
	<div class="icon">
		<i class="fas fa-exclamation-triangle"></i>
	</div>
	<div class="text">
		{$LANG.clientareaproductsnone}
	</div>
	<a class="btn btn-primary" href="{$WEB_ROOT}/{if $themesettings.orderform.orderopc != ""}order{else}cart{/if}.php">
        {$LANG.navservicesorder}
    </a>
</div>
{/if}