{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $quotes}
{include file="$template/includes/tablelist.tpl" tableName="QuotesList" noSortColumns="5, 6" filterColumn="4"}

<script>
    jQuery(document).ready( function () {
        var table = jQuery('#tableQuotesList').show().DataTable();
        {if $orderby == 'id'}
            table.order(0, '{$sort}');
        {elseif $orderby == 'date'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'validuntil'}
            table.order(3, '{$sort}');
        {elseif $orderby == 'stage'}
            table.order(4, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').hide();
    });
</script>

<div class="table-container clearfix">
	<div class="table-header">
		<label>{lang key='view'}</label>
		<div class="dropdown view-filter-btns">
			<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				<span>{lang key='domainRenewal.showAll'}</span>
			</button>
			<ul class="dropdown-menu" role="menu">
				<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
				{foreach key=stage item=count from=$quotes|@array_column:'stage'|@array_count_values}
					<li><a href="#" class="dropdown-item"><span data-value="{$stage}">{$stage}</span></a></li>
                {/foreach}
			</ul>
		</div>		
	</div>
    <table id="tableQuotesList" class="datatable table table-hover w-hidden">
        <thead>
            <tr>
				<th data-class="expand">{$LANG.quotesubject}</th>
                <th>{$LANG.quotenumber}</th>
                <th data-hide="phone,tablet">{$LANG.quotedatecreated}</th>
                <th data-hide="phone,tablet">{$LANG.quotevaliduntil}</th>
                <th data-hide="phone">{$LANG.quotestage}</th>
                <th>&nbsp;</th>
				<th class="col-small center"></th>
                
            </tr>
        </thead>
        <tbody>
            {foreach $quotes as $quote}
                <tr onclick="clickableSafeRedirect(event, 'viewquote.php?id={$quote.id}', false)">
                    <td>{$quote.subject}</td>
                    <td>{$quote.id}</td>
                    <td><span class="w-hidden">{$quote.normalisedDateCreated}</span>{$quote.datecreated}</td>
                    <td><span class="w-hidden">{$quote.normalisedValidUntil}</span>{$quote.validuntil}</td>
                    <td><span class="label status status-{$quote.stageClass}">{$quote.stage}</span></td>
                    <td class="text-center">
                        <form method="submit" action="dl.php">
                            <input type="hidden" name="type" value="q" />
                            <input type="hidden" name="id" value="{$quote.id}" />
                            <button type="submit" class="btn btn-primary btn-xs">
								<span class="d-none d-sm-block"><i class="fas fa-download"></i> {$LANG.quotedownload}</span>
								<span class="d-block d-sm-none"><i class="fas fa-download icon-only"></i></span>
							</button>
                        </form>
                    </td>
                    <td class="col-small center">
						<div class="action-buttons">
							<a href="viewquote.php?id={$quote.id}" data-toggle="tooltip" title="{$LANG.quoteview}">
								<i class="fal fa-search-plus"></i> 
							</a>
						</div>
                    </td>

                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
</div>

{else}
<div class="alert-lg no-data">
	<div class="icon">
		<i class="fas fa-exclamation-triangle"></i>
	</div>
	<div class="text">
		{$LANG.noquotes}
	</div>
    <a class="btn btn-primary" href="{$WEB_ROOT}/submitticket.php">
     {$LANG.opennewticket}
   </a>
</div>
{/if}
