{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $templatefile == "clientareaaddfunds" && !$addfundsdisabled}
	<div class="panel panel-sidebar panel-info panel-funds">  
		<div class="panel-body">
			<div class="total">
				<span class="total-text">
					{$LANG.invoiceaddcreditdesc1}
				</span> 
				<span class="total-price">
					{$clientsstats.creditbalance}
					<i class="far fa-wallet"></i>
				</span>
			</div>
			<ul class="list-info">
				<li>
					<span class="list-heading">{$LANG.addfundsminimum}</span>
					<span class="list-text bolder">{$minimumamount}</span>
				</li>
				<li>
					<span class="list-heading">{$LANG.addfundsmaximum}</span>
					<span class="list-text bolder">{$maximumamount}</span>
				</li>
				<li>
					<span class="list-heading">{$LANG.addfundsmaximumbalance}</span>
					<span class="list-text bolder">{$maximumbalance}</span>
				</li>
			</ul>
		</div>
	</div>
{/if}

{if $templatefile == "affiliates" && !$inactive}
	<div menuitemname="Client Details" class="panel panel-sidebar panel-info panel-funds">
		<div class="panel-body">
			<div class="total">
				<span class="total-text">{$LANG.affiliatescommissionsavailable}</span>
				<span class="total-price">{$balance}<i class="far fa-university"></i></span>
			</div>
			<ul class="list-info mb-3">
				<li>
					<span class="list-heading">{$LANG.affiliatescommissionspending}</span>
					<span class="list-text bolder">{$pendingcommissions}</span>
				</li>
				<li>
					<span class="list-heading">{$LANG.affiliateswithdrawn}</span>
					<span class="list-text bolder">{$withdrawn}</span>
				</li>
			</ul>
			{if !$withdrawlevel || $withdrawrequestsent}
				<form method="POST" action="{$smarty.server.PHP_SELF}">
					<input type="hidden" name="action" value="withdrawrequest" />
					<button type="submit" class="btn btn-primary btn-sm p-3 btn-block{if !$withdrawlevel || $withdrawrequestsent} disabled" disabled="disabled{/if}">
						<i class="fas fa-university"></i> {lang key='affiliatesrequestwithdrawal'}
					</button>
				</form>
			{else}
				<form method="POST" action="{$smarty.server.PHP_SELF}">
					<input type="hidden" name="action" value="withdrawrequest" />
					<button type="submit" class="btn btn-primary btn-sm p-3 btn-block{if !$withdrawlevel || $withdrawrequestsent} disabled" disabled="disabled{/if}">
						<i class="fas fa-university"></i> {lang key='affiliatesrequestwithdrawal'}
					</button>
				</form>
			{/if}
			
		</div>
	</div>
	{if $withdrawrequestsent}
		<div class="alert alert-success small">
			<p><i class="far fa-info-circle"></i> {$LANG.affiliateswithdrawalrequestsuccessful}</p>
		</div>
	{else}
		{if !$withdrawlevel}
			<div class="alert alert-info small"><i class="far fa-info-circle"></i> {lang key="affiliateWithdrawalSummary" amountForWithdrawal=$affiliatePayoutMinimum}</div>
		{/if}
	{/if}
{/if}

{if $templatefile == "clientareainvoices" && $clientsstats.numdueinvoices !=0}
	<div class="panel panel-sidebar panel-invoice-info">
		<div class="panel-body">
			<div class="total">
				<span class="total-text">{$LANG.invoicesduemsg|sprintf2:$clientsstats.numdueinvoices}</span>
				<span class="total-price">{$clientsstats.dueinvoicesbalance}<i class="fal fa-exclamation-circle"></i></span>
			</div>
		</div>
		<div class="panel-footer clearfix">
			{if $condlinks.masspay && $clientsstats.numdueinvoices !=0}
				<div class="col-6 col-button-left">
					<a href="clientarea.php?action=masspay&all=true" class="btn btn-success btn-sm btn-block">
						{$LANG.invoicespaynow}
					</a>
				</div>
			{/if}
			{if $condlinks.addfunds}
				<div class="col-6 col-button-right">
					<a href="clientarea.php?action=addfunds" class="btn btn-default btn-sm btn-block">
						{$LANG.addfunds}
					</a>
				</div>				
			{/if}
		</div>
	</div>
{/if}

{if $templatefile == "serverstatus"}
	<div menuitemname="Network Status" class="panel panel-sidebar">
		<div class="list-group">
			<a menuitemname="View RSS Feed" href="{$WEB_ROOT}/networkissuesrss.php" class="list-group-item list-group-item-action" id="Primary_Sidebar-Network_Status-View_RSS_Feed">
				<i class="fas fa-rss"></i>&nbsp; {$LANG.announcementsrss} 
			</a>
		</div>
	</div>
{/if}


{if $templatefile == "clientareahome"}
	{if $themesettings.clientarea.sidebars == "2"}
	<div menuitemname="Client Information" class="mb-3 card card-sidebar panel-client-details">
		<div class="card-header">
            <h3 class="card-title m-0">
                <i class="far fa-user"></i>&nbsp;	{$LANG.yourinfo} <i class="fas fa-chevron-up card-minimise float-right"></i>
            </h3>
        </div>		
		<div class="collapsable-card-body">
			<div class="user-profile py-3">
				{if $themesettings.clientarea.gravatar}
					<div class="user-avatar mb-3">
						<img src="https://www.gravatar.com/avatar/{if $cuser}{$cuser->email|md5}{else}{$client.email|md5}{/if}" alt="{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}" />
						<em><b>{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}</b></em>
					</div>
					<div class="px-3">
						{if $client.companyname}<span class="fw-500">{$client.companyname}</span><br />{/if}
						{$client.address1}{if $client.address2}<br /> {$client.address2}{/if}<br />
						{$client.city}, {$client.state}, {$client.postcode}<br />
						{$client.countryname}
					</div>
				{else}
					<div class="px-3">
						{if $client.companyname}<strong>{$client.companyname}</strong><br />{/if}
						<em>{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}</em></br />
						{$client.address1}{if $client.address2}<br /> {$client.address2}{/if}<br />
						{$client.city}, {$client.state}, {$client.postcode}<br />
						{$client.countryname}
					</div>
				{/if}
			</div>
		</div>
		<div class="card-footer px-3">
			<a href="{$WEB_ROOT}/clientarea.php?action=details" class="btn btn-primary btn-block btn-sm">{lang key=update}</a>
		</div>
	</div>
	{else}
	<div menuitemname="Client Information" class="panel panel-sidebar panel-client-details">
		<div class="panel-heading">
            <h3 class="panel-title">
                <i class="far fa-user"></i>&nbsp;	{$LANG.yourinfo} <i class="fas fa-chevron-up panel-minimise pull-right"></i>
            </h3>
        </div>		
		<div class="panel-body">
			<div class="user-profile">
				{if $themesettings.clientarea.gravatar}
					<div class="user-avatar mb-3">
						<img src="https://www.gravatar.com/avatar/{if $cuser}{$cuser->email|md5}{else}{$client.email|md5}{/if}" alt="{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}" />
						<em><b>{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}</b></em>
					</div>
					<div class="px-3">
						{if $client.companyname}<span class="fw-500">{$client.companyname}</span><br />{/if}
						{$client.address1}{if $client.address2}<br /> {$client.address2}{/if}<br />
						{$client.city}, {$client.state}, {$client.postcode}<br />
						{$client.countryname}
					</div>
				{else}
					<div class="px-3">
						{if $client.companyname}<strong>{$client.companyname}</strong><br />{/if}
						<em>{if $cuser}{$cuser->fullName}{else}{$client.fullname}{/if}</em></br />
						{$client.address1}{if $client.address2}<br /> {$client.address2}{/if}<br />
						{$client.city}, {$client.state}, {$client.postcode}<br />
						{$client.countryname}
					</div>
				{/if}
			</div>
		</div>
		<div class="panel-footer px-3">
			<a href="{$WEB_ROOT}/clientarea.php?action=details" class="btn btn-primary btn-block btn-sm">{lang key=update}</a>
		</div>
	</div>
	{/if}
{/if}  