<link href="modules/servers/cpanel/css/client.css?v={$versionHash}" rel="stylesheet">
<script src="modules/servers/cpanel/js/client.js?v={$versionHash}"></script>

<div class="section">
	<div class="product-details">
		<div class="row row-eq-height row-eq-height-sm">
			<div class="col-md-6">
				<div class="product-holder product-status-{$rawstatus|strtolower}">
					<div class="product-content">
						<div class="product-image">
							<span class="fa-stack">
								<i class="fas fa-circle fa-stack-2x"></i>
								<i class="fab fa-cpanel fa-stack-1x fa-inverse"></i>
							</span>
						</div>
						<h4 class="text-center">
							<small>{$groupname}</small> - {$product}
						</h4>
						
						<div class="status-sticker-wrapper">
							<div class="status-sticker product-status-{$rawstatus|strtolower}">
								{$status}
							</div>
						</div>
					</div>
					<div class="product-footer">
						<ul class="list-unstyled list-inline">
							<li><a href="http://{$domain}" target="_blank">www.{$domain}</a></li>
						</ul>
					</div>				
				</div>
			</div>
			
			<div class="col-md-6">
				<div class="product-info cpanel-usage-stats">
					<div class="row">
						<div class="col-md-5 offset-md-1 col-6" id="diskUsage">
							<div class="usage-stats">
								<span>{lang key='diskUsage'}</span>
								<input type="text" value="{$diskpercent|substr:0:-1}" class="usage-dial" data-fgColor="#444" data-angleOffset="-125" data-angleArc="250" data-min="0" data-max="{if substr($diskpercent, 0, -1) > 100}{$diskpercent|substr:0:-1}{else}100{/if}" data-readOnly="true" data-width="100" data-height="80" />
								<span>{$diskusage} M / {$disklimit} M</span>
							</div>
						</div>
						<div class="col-md-5 col-6" id="bandwidthUsage">
							<div class="usage-stats">
								<span>{lang key='bandwidthUsage'}</span>
								<input type="text" value="{$bwpercent|substr:0:-1}" class="usage-dial" data-fgColor="#d9534f" data-angleOffset="-125" data-angleArc="250" data-min="0" data-max="{if substr($bwpercent, 0, -1) > 100}{$bwpercent|substr:0:-1}{else}100{/if}" data-readOnly="true" data-width="100" data-height="80" />
								<span>{$bwusage} M / {$bwlimit} M</span>
							</div>
						</div>
					</div>

					{if $bwpercent|substr:0:-1 > 75}
						<div class="text-danger text-center limit-near">
							{if $bwpercent|substr:0:-1 > 100}
								{lang key='usageStatsBwOverLimit'}
							{else}
								{lang key='usageStatsBwLimitNear'}
							{/if}
							{if $packagesupgrade}
								<a href="upgrade.php?type=package&id={$serviceid}" class="btn btn-xs btn-danger">
									<i class="fas fa-arrow-circle-up"></i>
									{lang key='usageUpgradeNow'}
								</a>
							{/if}
						</div>
					{elseif $diskpercent|substr:0:-1 > 75}
						<div class="text-danger text-center limit-near">
							{if $diskpercent|substr:0:-1 > 100}
								{lang key='usageStatsDiskOverLimit'}
							{else}
								{lang key='usageStatsDiskLimitNear'}
							{/if}
							{if $packagesupgrade}
								<a href="upgrade.php?type=package&id={$serviceid}" class="btn btn-xs btn-danger">
									<i class="fas fa-arrow-circle-up"></i>
									{lang key='usageUpgradeNow'}
								</a>
							{/if}
						</div>
					{else}
						<div class="text-info text-center limit-near">
							{lang key='usageLastUpdated'} {$lastupdate}
						</div>
					{/if}

					<script src="{$BASE_PATH_JS}/jquery.knob.js"></script>
					<script type="text/javascript">
					jQuery(function() {
						jQuery(".usage-dial").knob({
							'format': function (value) {
								return value + '%';
							}
						});
					});
					</script>
					
					{if $availableAddonProducts}
						<div class="cPanelExtrasPurchasePanel" id="cPanelExtrasPurchasePanel">
							<h5>{$LANG.cPanel.addonsExtras}</h5>
							<form method="post" action="cart.php?a=add">
								<input type="hidden" name="serviceid" value="{$serviceid}" />
								<div class="form-group">
									<select name="aid" class="form-control">
									{foreach $availableAddonProducts as $addonId => $addonName}
										<option value="{$addonId}">{$addonName}</option>
									{/foreach}
									</select>
								</div>
								<button type="submit" class="btn btn-primary">
									<i class="fas fa-shopping-cart"></i>
									{lang key='purchaseActivate'}
								</button>
							</form>
						</div>
					{/if}
				</div>
			</div>
		</div>
		
		{if $isSitejetActive}
			<div class="section">
				<h4>{lang key='sitejetBuilder.servicePage.panelTitle'}</h4>
				<div class="panel panel-default card mb-3" id="cPanelPackagePanel">
					<div class="panel-body card-body column light">
						<div class="row">
							<div class="col-sm-6">
								<img class="border rounded card-img-top"
									 id="sitejetPublishPreview"
									 alt="Sitejet Preview"
									 data-serviceid="{$serviceId}"
									 data-src="{fqdnRoutePath('clientarea-sitejet-get-preview', $serviceId)}"
									 src="{fqdnRoutePath('clientarea-sitejet-get-preview', $serviceId)}"
									 onerror="fallbackSitejetPreview(event)"
									 onload="sitejetPreviewLoadComplete(event)"
									 data-publish-in-progress="false"
									 style="max-width: 100%; border: 1px solid #ddd; transition: opacity 0.2s ease-in-out; opacity: 0"
								/>
							</div>
							<div class="col-sm-6 text-center d-flex flex-column">
								<div class="cpanel-package-details">
									<em>{$groupname|escape}</em>
									<h4>{$product|escape}</h4>
									<a href="http://{$domain}" target="_blank">www.{$domain}</a>
								</div>

								<p>
									<a id="sitejetViewLink"
									   href="http://{$domain}"
									   class="btn btn-default d-none"
									   target="_blank"
									>{lang key='sitejetBuilder.servicePage.visitSite'}</a>

									{if $domainId}
										<a href="clientarea.php?action=domaindetails&id={$domainId}" class="btn btn-success" target="_blank">{lang key='managedomain'}</a>
									{/if}

									{if $isSitejetSsoAvailable}
										<button id="sitejetEditBtn"
												class="btn btn-primary btn-custom-action div-service-item"
												data-serviceid="{$serviceId}"
												data-identifier="sitejet"
												data-active="true"
												data-ca-target="_self"
												{if $sitejetPublish}data-do-publish="true"{/if}
												style="display: inline-block"
										>
											{lang key='sitejetBuilder.servicePage.editSite'}
										</button>
									{/if}
								</p>

								<div
									id="sitejetPublishProgressBarWrapper"
									class="progress"
									style="margin-bottom: 10px; display: none;"
								>
									<div class="progress-bar progress-bar-striped progress-bar-animated"
										 role="progressbar"
										 aria-valuenow="0"
										 aria-valuemin="0"
										 aria-valuemax="100"
									></div>
								</div>
								<div id="sitejetAlert"
									 class="alert alert-info"
									 role="alert"
									 data-progress-text="{lang key='sitejetBuilder.servicePage.publishProgress'}"
									 data-success-text="{lang key='sitejetBuilder.servicePage.publishSuccess'}"
									 data-error-text="{lang key='clientareaerroroccured'}"
									 style="display: none"
								></div>
							</div>
						</div>

					</div>
				</div>
			</div>
		{/if}
		
	</div>
</div>		

{if $systemStatus == 'Active'}

	{foreach $hookOutput as $output}
		<div class="section">
			<div>
				{$output}
			</div>
		</div>
	{/foreach}

    {if count($wpInstances) || $allowWpClientInstall}
	<div class="section">
		<h4>WordPress®</h4>
        <div class="panel panel-default mb-3" id="cPanelWordPress" data-service-id="{$serviceId}" data-wp-domain="{$wpDomain}">
            <div class="panel-body py-0">
                <div class="row{if !$allowWpClientInstall} no-margin{/if}" id="wordpressInstanceRow" {if !count($wpInstances)}style="display: none" {/if}>
                    <div class="col-md-4">
                        <select class="form-control" id="wordPressInstances">
                            {foreach $wpInstances as $wpInstance}
                                <option value="{$wpInstance.instanceUrl}">
                                    {$wpInstance.blogTitle}
                                    {if $wpInstance.path} ({$wpInstance.path}){/if}
                                </option>
                            {/foreach}
                        </select>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-default btn-block" id="btnGoToWordPressHome">
                            <i class="fab fa-wordpress"></i>
                            {lang key='wptk.goToWebsite'}
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-default btn-block" id="btnGoToWordPressAdmin">
                            <i class="fas fa-users-cog"></i>
                            {lang key='wptk.goToAdmin'}
                        </button>
                    </div>
                </div>
                <div class="row" {if !$allowWpClientInstall}style="display: none"{/if}>
                    <div class="col-md-12">
                        <h5>{lang key='wptk.createNew'}</h5>
                        <p class="small" id="newWordPressFullUrlPreview">https://{$wpDomain}/</p>
                    </div>
                    <div class="col-md-12" id="wordPressInstallResultRow" style="display: none">
                        <div class="alert alert-success" style="display: none">
                            {lang key='wptk.installationSuccess'}
                        </div>
                        <div class="alert alert-danger" style="display: none">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <input type="text" class="form-control" id="wpNewBlogTitle" placeholder="New Blog Title" />
                    </div>
                    <div class="col-md-3">
                        <input type="text" class="form-control" id="wpNewPath" placeholder="Path (optional)" />
                    </div>
                    <div class="col-md-3">
                        <input type="password" class="form-control" id="wpAdminPass" placeholder="Admin Password" />
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-default btn-block" id="btnInstallWordpress">
                            <i class="far fa-fw fa-plus"></i>
                            {lang key='wptk.installWordPressShort'}
                        </button>
                    </div>
                </div>
            </div>
        </div>
	</div>
    {/if}
	
	<div class="section">
		<h4>{lang key='quickShortcuts'}</h4>
		<div class="panel panel-default" id="cPanelQuickShortcutsPanel">
			<div class="panel-body py-0">
				<div class="row cpanel-feature-row">
					<div class="col-md-3 col-6" id="cPanelEmailAccounts">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_Accounts" target="_blank">
							<i class="fad fa-users fa-fw"></i><span class="text-muted">{$LANG.cPanel.emailAccounts}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelForwarders">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_Forwarders" target="_blank">
							<i class="fad fa-reply fa-fw"></i><span class="text-muted">{$LANG.cPanel.forwarders}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelAutoResponders">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_AutoResponders" target="_blank">
							<i class="fad fa-share fa-fw"></i><span class="text-muted">{$LANG.cPanel.autoresponders}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelFileManager">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=FileManager_Home" target="_blank">
							<i class="fad fa-folders fa-fw"></i><span class="text-muted">{$LANG.fileManager}</span>
						</a>
					</div>
				</div>
				<div class="row cpanel-feature-row">
					<div class="col-md-3 col-6" id="cPanelBackup">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Backups_Home" target="_blank">
							<i class="fad fa-file-archive fa-fw"></i><span class="text-muted">{$LANG.cPanel.backup}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelSubdomains">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Domains_domains" target="_blank">
							<i class="fad fa-globe fa-fw"></i><span class="text-muted">{$LANG.cPanel.domains}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelCronJobs">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Cron_Home" target="_blank">
							<i class="fad fa-clock fa-fw"></i><span class="text-muted">{$LANG.cPanel.cronJobs}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelMySQLDatabases">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Database_MySQL" target="_blank">
							<i class="fad fa-database fa-fw"></i><span class="text-muted">{$LANG.mysqlDatabases}</span>
						</a>
					</div>					
				</div>
				<div class="row cpanel-feature-row">
					<div class="col-md-3 col-6" id="cPanelPhpMyAdmin">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Database_phpMyAdmin" target="_blank">
							<i class="fad fa-browser fa-fw"></i><span class="text-muted">{$LANG.cPanel.phpMyAdmin}</span>
						</a>
					</div>
					<div class="col-md-3 col-6" id="cPanelAwstats">
						<a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Stats_AWStats" target="_blank">
							<i class="fad fa-chart-line fa-fw"></i><span class="text-muted">{$LANG.cPanel.awstats}</span>
						</a>
					</div>
					{if $hasWPTDeluxe}
                    <div class="col-md-3 col-6" id="cPanelWptk">
                        <a href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;addonId={$wptkDeluxeAddonId}&amp;doaddonsignon=1" target="_blank">
                            <i class="fab fa-wordpress fa-fw"></i><span class="text-muted">{$LANG.cPanel.wptk}</span>
                        </a>
                    </div>					
					{/if}
				</div>

			</div>
		</div>
	</div>

	
	<div class="section">
		<h4>{$LANG.cPanel.createEmailAccount}</h4>
		<div class="panel panel-default" id="cPanelQuickEmailPanel">
			<div class="panel-body">

				{include file="$template/includes/alert.tpl" type="success" msg=$LANG.cPanel.emailAccountCreateSuccess textcenter=true hide=true idname="emailCreateSuccess" additionalClasses="email-create-feedback"}

				{include file="$template/includes/alert.tpl" type="danger" msg=$LANG.cPanel.emailAccountCreateFailed|cat:' <span id="emailCreateFailedErrorMsg"></span>' textcenter=true hide=true idname="emailCreateFailed" additionalClasses="email-create-feedback"}

				<form id="frmCreateEmailAccount" onsubmit="doEmailCreate();return false">
					<input type="hidden" name="id" value="{$serviceid}" />
					<input type="hidden" name="email_quota" value="250" />
					<div class="row">
						<div class="col-md-6">
							<label>{$LANG.contactemail}</label>
							<div class="input-group">
								<input type="text" name="email_prefix" class="form-control" placeholder="{$LANG.cPanel.usernamePlaceholder}">
								<div class="input-group-prepend">
									<div class="input-group-text">@{$domain}</div>
								</div>
							</div>
						</div>
						<div class="col-md-3">
							<label>{$LANG.loginpassword}</label>
							<input type="password" name="email_pw" class="form-control" placeholder="{$LANG.cPanel.passwordPlaceholder}">
						</div>
						<div class="col-md-3">
							<label>&nbsp;</label>
							<button type="submit" class="btn btn-primary btn-block" />
								<i class="fas fa-plus" id="btnCreateLoader"></i>
								{$LANG.cPanel.create}
							</button>
						</div>
					</div>
				</form>

			</div>
		</div>
	</div>

{else}

	<div class="alert-lg no-data" id="cPanelSuspendReasonPanel">
		<div class="icon">
			<i class="fas fa-exclamation-triangle"></i>
		</div>
		<div class="text">
			{if $suspendreason}
				<strong>{$suspendreason}</strong><br />
			{/if}
			{$LANG.cPanel.packageNotActive} {$status}.<br />
			{if $systemStatus eq "Pending"}
				{$LANG.cPanel.statusPendingNotice}
			{elseif $systemStatus eq "Suspended"}
				{$LANG.cPanel.statusSuspendedNotice}
			{/if}
		</div>
	</div>
	
{/if}

<div class="section">
	<div class="card panel panel-tabs">
		<div class="card-header">
			<ul class="nav nav-pills card-header-pills flex-column flex-md-row">
				<li class="nav-item">
					<a href="#billingInfo" class="nav-link active" data-toggle="tab" aria-expanded="true">{lang key='billingOverview'}</a>
				</li>
				{if $serverdata.nameserver1 || $serverdata.nameserver2 || $serverdata.nameserver3 || $serverdata.nameserver4 || $serverdata.nameserver5}
					<li class="nav-item"><a href="#serverInfo" class="nav-link" data-toggle="tab" aria-expanded="true">{$LANG.sslserverinfo}</a></li>
				{/if}
				{if $configurableoptions}
					<li class="nav-item"><a href="#configInfo" class="nav-link" data-toggle="tab" aria-expanded="false">{$LANG.orderconfigpackage}</a></li>				
				{/if}
				{if $metricStats}
					<li class="nav-item"><a href="#cPanelMetricStatsPanel" class="nav-link" data-toggle="tab" aria-expanded="false">{$LANG.metrics.title}</a></li>
				{/if}
				{if $customfields}
					<li class="nav-item"><a href="#customInfo" class="nav-link" data-toggle="tab" aria-expanded="false">{$LANG.additionalInfo}</a></li>				
				{/if}
			</ul>
		</div>
	
		<div class="card-body">
			<div class="tab-content">
				<div class="tab-pane fade in show active billingInfo" id="billingInfo">
					<div id="cPanelBillingOverviewPanel">
						<div class="row row-eq-height row-eq-height-sm">
							<div class="col-sm-6 col-md-3">
								<div class="row" id="registrationDate">
									<div class="col-12">
										<span class="text-heading">{$LANG.clientareahostingregdate}</span>
									</div>
									<div class="col-12">
										{$regdate}
									</div>
								</div>
							</div>
							{if $firstpaymentamount neq $recurringamount}
								<div class="col-sm-6 col-md-3">
									<div class="row" id="firstPaymentAmount">
										<div class="col-12" >
											<span class="text-heading">{$LANG.firstpaymentamount}</span>
										</div>
										<div class="col-12">
											{$firstpaymentamount}
										</div>
									</div>
								</div>
							{/if}
							<div class="col-sm-6 col-md-3">
								<div class="row" id="nextDueDate">
									<div class="col-12">
										<span class="text-heading">{$LANG.clientareahostingnextduedate}</span>
									</div>
									<div class="col-12">
										{$nextduedate}
									</div>
								</div>
							</div>
							{if $billingcycle != $LANG.orderpaymenttermonetime && $billingcycle != $LANG.orderfree}
							<div class="col-sm-6 col-md-3">
								<div class="row" id="recurringAmount">
									<div class="col-12">
										<span class="text-heading">{$LANG.recurringamount}</span>
									</div>
									<div class="col-12">
										{$recurringamount}
									</div>
								</div>
							</div>
							{/if}
							<div class="col-sm-6 col-md-3">
								<div class="row" id="paymentMethod">
									<div class="col-12">
										<span class="text-heading">{$LANG.orderpaymentmethod}</span>
									</div>
									<div class="col-12">
										{$paymentmethod}
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-3">
								<div class="row" id="billingCycle">
									<div class="col-12">
										<span class="text-heading">{$LANG.orderbillingcycle}</span>
									</div>
									<div class="col-12">
										{$billingcycle}
									</div>
								</div>
							</div>
						</div>
						{if $domainId}
							<div class="cpanel-domain-overview">
								<a href="https://{$domain}" class="btn btn-default" target="_blank">www.{$domain}</a>
								<a href="clientarea.php?action=domaindetails&id={$domainId}" class="btn btn-default" target="_blank">{$LANG.managedomain}</a>
							</div>
						{/if}
					</div>
				</div>
				
				
				{if $serverdata.nameserver1 || $serverdata.nameserver2 || $serverdata.nameserver3 || $serverdata.nameserver4 || $serverdata.nameserver5}
					<div class="tab-pane fade in" id="serverInfo">
						<div class="row">
							<div class="col-12">
								<span class="text-heading">{$LANG.servername}</span>
							</div>
							<div class="col-12">
								<p>{$serverdata.hostname}</p>
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								<span class="text-heading">{$LANG.domainnameservers}</span>
							</div>
							<div class="col-12">
								{if $producttype=="hostingaccount"}
									{if $serverdata.nameserver1}{$serverdata.nameserver1} ({$serverdata.nameserver1ip})<br />{/if}
									{if $serverdata.nameserver2}{$serverdata.nameserver2} ({$serverdata.nameserver2ip})<br />{/if}
									{if $serverdata.nameserver3}{$serverdata.nameserver3} ({$serverdata.nameserver3ip})<br />{/if}
									{if $serverdata.nameserver4}{$serverdata.nameserver4} ({$serverdata.nameserver4ip})<br />{/if}
									{if $serverdata.nameserver5}{$serverdata.nameserver5} ({$serverdata.nameserver5ip})<br />{/if}
								{else}
									ns1.{$domain} ({$serverdata.nameserver1ip})<br />ns2.{$domain} ({$serverdata.nameserver2ip})
								{/if}
							</div>
						</div>
					</div>
				{/if}
				
				{if $configurableoptions}
					<div class="tab-pane fade in" id="configInfo">
						{foreach from=$configurableoptions item=configoption}
							<div class="row">
								<div class="col-12">
									<span class="text-heading">{$configoption.optionname}</span>
								</div>
								<div class="col-12">
									{if $configoption.optiontype eq 3}{if $configoption.selectedqty}{$LANG.yes}{else}{$LANG.no}{/if}{elseif $configoption.optiontype eq 4}{$configoption.selectedqty} x {$configoption.selectedoption}{else}{$configoption.selectedoption}{/if}
								</div>
							</div>
						{/foreach}
					</div>
				{/if}
				
				{if $metricStats}
					<div class="tab-pane fade in" id="cPanelMetricStatsPanel">
						{include file="$template/clientareaproductusagebilling.tpl"}
					</div>
				{/if}
				
				{if $customfields}
					<div class="tab-pane fade in" id="customInfo">
						{foreach from=$customfields item=field}
							<div class="row">
								<div class="col-12">
									<span class="text-heading">{$field.name}</span>
								</div>
								<div class="col-12">
									{if empty($field.value)}
										{$LANG.blankCustomField}
									{else}
										{$field.value}
									{/if}
								</div>
							</div>
						{/foreach}
					</div>
				{/if}
				

				
				
			</div>
		</div>
		
	</div>
</div>