{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{*
{if $opencount == 0}
    <div class="alert alert-success">
        <i class="fas fa-check fa-fw"></i>
        {"{lang key='networkstatusnone'}"|sprintf:"{lang key='networkissuesstatusopen'}"}
    </div>
{/if}

{if $scheduledcount > 0}
    <div class="alert alert-info">
        <i class="fas fa-exclamation-triangle fa-fw"></i>
        {lang key='networkIssues.scheduled' count=$scheduledcount}
        <a href="serverstatus.php?view=scheduled" class="alert-link">{lang key='learnmore'}...</a>
    </div>
{/if}
*}

<div class="section network-status panel panel-default">
	<div class="panel-heading">
		<div class="network-status-top">
			<label class="text-base">{$LANG.clientareahostingaddonsview}</label>
			<div class="dropdown view-filter-btns">
				<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
					<span>
						{if $smarty.server.REQUEST_URI|strstr:"open"}
							{$LANG.networkissuesstatusopen}
						{elseif $smarty.server.REQUEST_URI|strstr:"scheduled"}
							{$LANG.networkissuesstatusscheduled}
						{elseif $smarty.server.REQUEST_URI|strstr:"resolved"}
							{$LANG.networkissuesstatusresolved}
						{else}
							{lang key='domainRenewal.showAll'}
						{/if}
					</span>
				</button>
				<ul class="dropdown-menu" role="menu">
					<li><a class="dropdown-item" href="{$WEB_ROOT}/serverstatus.php"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>             
					{if $opencount > 0}
						<li><a class="dropdown-item" href="{$WEB_ROOT}/serverstatus.php?view=open"><span>{$LANG.networkissuesstatusopen}</span></a></li>                    
					{/if}
					{if $scheduledcount > 0}
						<li><a class="dropdown-item" href="{$WEB_ROOT}/serverstatus.php?view=scheduled"><span>{$LANG.networkissuesstatusscheduled}</span></a></li>
					{/if}
					{if $resolvedcount > 0}
						<li><a class="dropdown-item" href="{$WEB_ROOT}/serverstatus.php?view=resolved"><span>{$LANG.networkissuesstatusresolved}</span></a></li>
					{/if}
				</ul> 
			</div>
		</div>
	</div>
				
				
	{foreach $issues as $issue}
		<div class="panel-body">
			<div class="status-title">
				<h4>{$issue.title}</h4>
				<span>
					({$issue.status})
					<span id="issuePriorityLabel" class="badge badge-{if $issue.rawPriority == 'Critical'}danger{elseif $issue.rawPriority == 'High'}warning{elseif $issue.rawPriority == 'Low'}success{else}info{/if}">{$issue.priority}</span>
				</span>
			</div>
			
			{if $issue.server || $issue.affecting}
				<div class="mb-2">
					<span class="text-muted">{lang key='networkissuesaffecting'} {$issue.type}</span>
					-
					{if $issue.type eq "{lang key='networkissuestypeserver'}"}
						{$issue.server}
					{else}
						{$issue.affecting}
					{/if}
				</div>
			{/if}
			{if $issue.clientaffected}
				<div class="alert alert-warning p-1 text-center">
					{lang key='networkIssues.affectingYou'}
				</div>
			{/if}
			<div class="py-3">
				{$issue.description}
			</div>
			
			<ul class="list-inline small text-muted mb-0">
				<li class="list-inline-item pr-3">
					<i class="far fa-calendar-alt fa-fw"></i>
					{$issue.startdate}
					{if $issue.enddate} - {$issue.enddate}{/if}
				</li>
				<li class="list-inline-item pr-3">
					<i class="far fa-clock fa-fw"></i>
					{lang key='networkissueslastupdated'}</strong> {$issue.lastupdate}
				</li>
			</ul>
		</div>
	{foreachelse}
		<div class="panel-body">
			<div class="alert alert-success">
				<i class="fas fa-check fa-fw"></i>
				{"{lang key='networkstatusnone'}"|sprintf:"{lang key='networkissuesstatusopen'}"}
			</div>
		</div>
	{/foreach}
	
	
	{if $issues}
	<div class="panel-footer">
		<div class="network-status-pagination navigation">
			<ul class="pagination border-0">
				<li class="page-item{if !$prevpage} disabled{/if}"><a class="page-link" href="?{if $view}view={$view}&amp;{/if}page={$prevpage}">{lang key='previouspage'}</a></li>
				<li class="page-item{if !$nextpage} disabled{/if}"><a class="page-link" href="?{if $view}view={$view}&amp;{/if}page={$nextpage}">{lang key='nextpage'}</a></li>
			</ul>
		</div>
	</div>
	{/if}
	
</div>

{if $servers}
    <div class="card">
        <div class="card-body">
            <h3>{lang key='serverstatustitle'}</h3>

            <p>{lang key='serverstatusheadingtext'}</p>

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>{lang key='servername'}</th>
                            <th class="text-center">{lang key='networkIssues.http'}</th>
                            <th class="text-center">{lang key='networkIssues.ftp'}</th>
                            <th class="text-center">{lang key='networkIssues.pop3'}</th>
                            <th class="text-center">{lang key='serverstatusphpinfo'}</th>
                            <th class="text-center">{lang key='serverstatusserverload'}</th>
                            <th class="text-center">{lang key='serverstatusuptime'}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $servers as $num => $server}
                            <tr>
                                <td>{$server.name}</td>
                                <td class="text-center" id="port80_{$num}">
                                    <span class="fas fa-spinner fa-spin"></span>
                                </td>
                                <td class="text-center" id="port21_{$num}">
                                    <span class="fas fa-spinner fa-spin"></span>
                                </td>
                                <td class="text-center" id="port110_{$num}">
                                    <span class="fas fa-spinner fa-spin"></span>
                                </td>
                                <td class="text-center"><a href="{$server.phpinfourl}" target="_blank">{lang key='serverstatusphpinfo'}</a></td>
                                <td class="text-center" id="load{$num}">
                                    <span class="fas fa-spinner fa-spin"></span>
                                </td>
                                <td class="text-center" id="uptime{$num}">
                                    <span class="fas fa-spinner fa-spin"></span>
                                    <script>
                                    jQuery(document).ready(function() {
                                        checkPort({$num}, 80);
                                        checkPort({$num}, 21);
                                        checkPort({$num}, 110);
                                        getStats({$num});
                                    });
                                    </script>
                                </td>
                            </tr>
                        {foreachelse}
                            <tr>
                                <td colspan="7">{lang key='serverstatusnoservers'}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
{/if}