<div class="landing-page ssl">

    <div class="hero bg-primary">
		<div class="cros-bg-shapes-right"></div>
		<div class="cros-bg-shapes-left"></div>
		
        <div class="container">
            <h1>{lang key="store.ssl.landingPage.title"}</h1>
            <p class="h4 fw-100 d-none">{lang key="store.ssl.landingPage.tagline1"}<br>{lang key="store.ssl.landingPage.tagline2"}</p>
        </div>
    </div>
	
	{include file="$template/store/ssl/shared/nav.tpl" current=""}

    <div class="validation-levels border-bottom">
        <div class="container">
            <h3>{lang key="store.ssl.landingPage.chooseLevel"}</h3>
            <div class="row">
                <div class="col-md-6 col-lg-4">
                    <div class="item border rounded">
                        <h4>{lang key="store.ssl.landingPage.dv"}</h4>
                        <img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/ssl-dv-icon.png" class="rounded">
                        <span>{lang key="store.ssl.landingPage.dvSubtitle"}</span>
                        <p>{lang key="store.ssl.landingPage.dvInformation"}</p>
                        <a href="{routePath('store-product-group', $routePathSlug, 'dv')}" class="btn btn-primary">{lang key="store.ssl.landingPage.buy"}</a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="item border rounded">
                        <h4>{lang key="store.ssl.landingPage.ov"}</h4>
                        <img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/ssl-ov-icon.png" class="rounded">
                        <span>{lang key="store.ssl.landingPage.ovSubtitle"}</span>
                        <p>{lang key="store.ssl.landingPage.ovInformation"}</p>
                        <a href="{routePath('store-product-group', $routePathSlug, 'ov')}" class="btn btn-primary">{lang key="store.ssl.landingPage.buy"}</a>
                    </div>
                </div>
                <div class="col-md-6 offset-md-3 col-lg-4 offset-lg-0">
                    <div class="item border rounded">
                        <h4>{lang key="store.ssl.landingPage.ev"}</h4>
                        <img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/ssl-ev-icon.png" class="rounded">
                        <span>{lang key="store.ssl.landingPage.evSubtitle"}</span>
                        <p>{lang key="store.ssl.landingPage.evInformation"}</p>
                        <a href="{routePath('store-product-group', $routePathSlug, 'ev')}" class="btn btn-primary">{lang key="store.ssl.landingPage.buy"}</a>
                    </div>
                </div>
            </div>
            <p class="help-me-choose m-0">
				<a href="#" class="show-all"><i class="fas fa-arrow-down"></i> {lang key="store.ssl.shared.helpMeChoose"}</a>
			</p>
        </div>
    </div>

    <div class="content-block what-is-ssl standout border-bottom">
        <div class="container">
            <div class="row">
                <div class="content-body-block col-md-6">
                    <h2 class="mb-3">{lang key="store.ssl.landingPage.what"}</h2>
                    <p class="desc">{lang key="store.ssl.landingPage.whatInfo"}</p>
                    <ul>
                        <li>{lang key="store.ssl.landingPage.secureConnection"}</li>
                        <li>{lang key="store.ssl.landingPage.encrypts"}</li>
                        <li>{lang key="store.ssl.landingPage.padlock"}</li>
                        <li>{lang key="store.ssl.landingPage.authenticates"}</li>
                    </ul>
                    <p>{lang key="store.ssl.landingPage.certTypeInfo" dvLink=routePath('store-product-group', $routePathSlug, 'dv') ovLink=routePath('store-product-group', $routePathSlug, 'ov') evLink=routePath('store-product-group', $routePathSlug, 'ev')}</p>
                </div>
				<div class="content-image-block col-md-6">
                     <img src="{$WEB_ROOT}/templates/{$template}/assets/images/img_vas_ssl_securepage.png">
				</div>
            </div>
        </div>
    </div>
	
    <div class="content-block standout border-bottom detailed-info">
        <div class="container">
            <div class="text-center">
				<h2 class="mb-3 fw-900">{lang key="store.ssl.landingPage.benefits.title"}</h2>
				<h4>{lang key="store.ssl.landingPage.benefits.subtitle"}</h4>
				<p>{lang key="store.ssl.landingPage.benefits.higherResults"}</p>
				<p>{lang key="store.ssl.landingPage.benefits.reasons"}:</p>
            </div>
        </div>
    </div>

    <div class="content-block ssl-benefits standout">
        <div class="container">
            <div class="row">
                <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-globe"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.encrypt"}</span>
                </div>
               <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-user"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.privacy"}</span>
                </div>
                <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-credit-card"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.secure"}</span>
                </div>
                <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-lock"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.https"}</span>
                </div>
                <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-trophy"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.legitimacy"}</span>
                </div>
                <div class="col-xs-6 col-sm-4">
                    <i class="fas fa-search"></i>
                    <span>{lang key="store.ssl.landingPage.benefits.seo"}</span>
                </div>
            </div>

        </div>
    </div>

    <div class="standout-1">
        <div class="container browser">
            <h3>{lang key="store.ssl.landingPage.browser.title"}</h3>
            <div class="browser-image">
                <img src="{$WEB_ROOT}/templates/{$template}/assets/images/browser-warning.png">
            </div>
        </div>
        <div class="browser-notice">
            <div class="wrapper-container">
                <div class="wrapper">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/padlock-x.png">
                    {lang key="store.ssl.landingPage.browser.insecureNotice"}
                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>

    <div class="content-block competitive-upgrade-promo mb-0">
        <div class="container">
            {lang key="store.ssl.landingPage.secureInMinutes"}
        </div>
    </div>

    <div class="content-block standout light text-center">
        <div class="container">
			<div class="mw-928 mx-auto">
				<h2 class="mb-3">{lang key="store.ssl.landingPage.evs.upgradeTitle"}</h2>
				<p>{lang key="store.ssl.landingPage.evs.description"}</p>
				<p class="desc">{lang key="store.ssl.landingPage.evs.whatIs"}</p>
				<br>
				<div class="row text-center">
					<div class="col-sm-6 col-md-4">
						<div class="item">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/shopfront-dv.png" class="img-fluid border rounded mb-3">
							<h4>{lang key="store.ssl.landingPage.dv"}</h4>
						</div>
					</div>
					<div class="col-sm-6 col-md-4">
						<div class="item">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/shopfront-ov.png" class="img-fluid border rounded mb-3">
							<h4>{lang key="store.ssl.landingPage.ov"}</h4>
						</div>
					</div>
					<div class="col-sm-6 offset-sm-3 col-md-4 offset-md-0">
						<div class="item">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/shopfront-ev.png" class="img-fluid border rounded mb-3">
							<h4>{lang key="store.ssl.landingPage.ev"}</h4>
						</div>
					</div>
				</div>
				<br>
				<div class="text-center mt-3">
					<a href="{routePath('store-product-group', $routePathSlug, 'ev')}" class="btn btn-primary">{lang key="store.ssl.landingPage.evs.learn"}</a>
				</div>
			</div>
        </div>
    </div>
	
	<div class="content-block standout border-top border-bottom" id="collapseHelpMeChoose">
		<div class="container">
			<div class="mw-928 mx-auto text-center mb-5">
				<h2 class="mb-3 fw-900">
					{lang key="store.ssl.landingPage.help.title"}
				</h2>
				<p>{lang key="store.ssl.landingPage.help.guide"}</p>
				
				<hr class="separator" />
				
				<div class="mt-3 text-center">
					<a data-toggle="modal" data-target="#modalAllPricing" class="btn btn-default" href="#">{lang key="store.ssl.landingPage.viewAll"}</a>
				</div>
			</div>

			<div class="help-me-choose">
				<div class="py-5">
					<div class="row row-eq-height">
						<div class="col-lg-7">
							<div class="mr-5">
								<h3 class="mb-3">{lang key="store.ssl.landingPage.help.dv.title"}</h3>
								<ul>
									<li>{lang key="store.ssl.landingPage.help.dv.verify"}</li>
									<li>{lang key="store.ssl.landingPage.help.dv.issued"}</li>
									<li>{lang key="store.ssl.landingPage.help.dv.compliance"}</li>
								</ul>
								<p class="ideal">{lang key="store.ssl.landingPage.help.dv.for"}</p>
								<p class="ssl-types-expl">{lang key="store.ssl.landingPage.help.dv.type"}</p>
								<a href="{routePath('store-product-group', $routePathSlug, 'dv')}" class="btn btn-primary">{lang key="store.ssl.landingPage.help.dv.browse"}</a>
							</div>
						</div>
						<div class="col-lg-5">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/card-library.png" class="img-fluid m-0">
						</div>
					</div>
				</div>
				
				<hr />
				
				<div class="py-5">
					<div class="row row-eq-height">
						<div class="col-lg-5">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/card-driving.png" class="img-fluid m-0">
						</div>
						<div class="col-lg-7">
							<div class="ml-5">
								<h3 class="mb-3">{lang key="store.ssl.landingPage.help.ov.title"}</h3>
								<ul>
									<li>{lang key="store.ssl.landingPage.help.ov.verify"}</li>
									<li>{lang key="store.ssl.landingPage.help.ov.issued"}</li>
									<li>{lang key="store.ssl.landingPage.help.ov.compliance"}</li>
								</ul>

								<p class="ideal">{lang key="store.ssl.landingPage.help.ov.for"}</p>
								<p class="ssl-types-expl">{lang key="store.ssl.landingPage.help.ov.type"}</p>
								<a href="{routePath('store-product-group', $routePathSlug, 'ov')}" class="btn btn-primary">{lang key="store.ssl.landingPage.help.ov.browse"}</a>
							</div>
						</div>
					</div>
				</div>
				
				<hr />
				
				<div class="py-5">
					<div class="row row-eq-height">
						<div class="col-lg-7">
							<div class="mr-5">
								<h3 class="mb-3">{lang key="store.ssl.landingPage.help.ev.title"}</h3>
								<ul>
									<li>{lang key="store.ssl.landingPage.help.ev.verify"}</li>
									<li>{lang key="store.ssl.landingPage.help.ev.issued"}</li>
									<li>{lang key="store.ssl.landingPage.help.ev.compliance"}</li>
								</ul>
								<p class="ideal">{lang key="store.ssl.landingPage.help.ev.for"}</p>
								<p class="ssl-types-expl">{lang key="store.ssl.landingPage.help.ev.type"}</p>
								<a href="{routePath('store-product-group', $routePathSlug, 'ev')}" class="btn btn-primary">{lang key="store.ssl.landingPage.help.ev.browse"}</a>
							</div>
						</div>
						<div class="col-lg-5">
							<img src="{$WEB_ROOT}/assets/img/marketconnect/symantec/card-passport.png" class="img-fluid m-0">
						</div>
					</div>
				</div>
			
			</div>
		</div>	
	</div>
	
    <div class="content-block faqs" id="faq">
        <div class="container">
			<h2 class="block-title text-center">{lang key="store.emailServices.faqs.title"}</h2>
			<div class="mw-928 mx-auto">
				<div id="accordionFAQs" class="panel-group">
					<div class="panel panel-default">
						<div class="panel-heading" data-toggle="collapse" data-target="#faq-1" aria-expanded="true">
							<h4 class="panel-title">{lang key="store.ssl.landingPage.faq.q1"}</h4>
						</div>
						<div id="faq-1" class="panel-collapse collapse show" data-parent="#accordionFAQs" aria-expanded="true">
							<div class="panel-body">
								<p>{lang key="store.ssl.landingPage.faq.a1"}</p>
							</div>
						</div>        
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" data-toggle="collapse" data-target="#faq-2" aria-expanded="true">
							<h4 class="panel-title">{lang key="store.ssl.landingPage.faq.q2"}</h4>
						</div>
						<div id="faq-2" class="panel-collapse collapse" data-parent="#accordionFAQs" aria-expanded="true">
							<div class="panel-body">
								<p>{lang key="store.ssl.landingPage.faq.a2"}</p>
							</div>
						</div>        
					</div>
					<div class="panel panel-default">
						<div class="panel-heading" data-toggle="collapse" data-target="#faq-3" aria-expanded="true">
							<h4 class="panel-title">{lang key="store.ssl.landingPage.faq.q3"}</h4>
						</div>
						<div id="faq-3" class="panel-collapse collapse" data-parent="#accordionFAQs" aria-expanded="true">
							<div class="panel-body">
								<p>{lang key="store.ssl.landingPage.faq.a3"}</p>
							</div>
						</div>        
					</div>
					{if $certTypes.wildcard > 0 || $inPreview}
					<div class="panel panel-default">
						<div class="panel-heading" data-toggle="collapse" data-target="#faq-4" aria-expanded="true">
							<h4 class="panel-title">{lang key="store.ssl.landingPage.faq.q4"}</h4>
						</div>
						<div id="faq-4" class="panel-collapse collapse" data-parent="#accordionFAQs" aria-expanded="true" style="">
							<div class="panel-body">
								<p>{lang key="store.ssl.landingPage.faq.a4"}</p>
							</div>
						</div>        
					</div>
					{/if}
					{if $certTypes.ev > 0 || $inPreview}
					<div class="panel panel-default">
						<div class="panel-heading" data-toggle="collapse" data-target="#faq-5" aria-expanded="true">
							<h4 class="panel-title">{lang key="store.ssl.landingPage.faq.q5"}</h4>
						</div>
						<div id="faq-5" class="panel-collapse collapse" data-parent="#accordionFAQs" aria-expanded="true">
							<div class="panel-body">
								<p>{lang key="store.ssl.landingPage.faq.a5"}</p>
							</div>
						</div>        
					</div>
					{/if}

				</div>
			</div>
        </div>
    </div>

    {include file="$template/store/ssl/shared/logos.tpl"}

</div>

<div class="modal system-modal fade" id="modalAllPricing" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
				<h5 class="modal-title">{lang key="store.ssl.landingPage.viewAll"}</h5>
				<button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">&times;</span>
					<span class="sr-only">{lang key='close'}</span>
				</button>
            </div>
            <div class="modal-body">
				<ul class="ssl-certs-all list-unstyled">
					{if count($certificates) > 0}
						{foreach $certificates as $type => $products}
							{foreach $products as $product}
								<li class="alert border rounded{if $product->isFeatured} alert-success featured{/if}">
									<div class="row">
										<div class="col-md-12">
											<h4>{$product->name} {if $product->isFeatured}<span class="label status status-active d-inline-block">{{lang key='recommended'}|upper}</span>{/if}</h4>
											<p class="text-base">{$product->description}</p>
										</div>
									</div>
									<div class="row">
										<div class="col-lg-6 mb-3 mb-lg-0">
											{lang key='from'} <strong class="fw-900 bigger-170">{$product->pricing()->best()->yearlyPrice()}</strong>
										</div>
										<div class="col-lg-6">
											<div class="action-btn">
												<form method="post" action="{routePath('cart-order')}">
													<input type="hidden" name="pid" value="{$product->id}">
													<button type="submit" class="btn btn-success mr-1">{lang key="store.ssl.landingPage.buyNow"}</button>
												</form>
												<a href="{routePath("store-product-group", $routePathSlug, $type)}" class="btn btn-default">{lang key="learnmore"}</a>
											</div>
										</div>
									</div>
								</li>
							{/foreach}
						{/foreach}
					{elseif $inPreview}
						<div class="lead text-center">
							{lang key="store.ssl.shared.noProducts"}
						</div>
					{/if}
				</ul>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function() {
    jQuery('p.help-me-choose').click(function(e) {
        e.preventDefault();
        if (!jQuery('#collapseHelpMeChoose').hasClass('show')) {
            jQuery('#collapseHelpMeChoose').collapse('show');
        }
        jQuery('html, body').animate({
            scrollTop: jQuery('#collapseHelpMeChoose').offset().top - 175
        }, 500);
    });
    var hash = location.hash.replace('#', '');
    if (hash == 'helpmechoose') {
        jQuery('html, body').animate({
            scrollTop: jQuery('#collapseHelpMeChoose').offset().top - 175
        }, 500);
    }
});
</script>