{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


{if $errormessage}
    {include file="$template/includes/alert.tpl" type="error" errorshtml=$errormessage}
{/if}

<form method="post" action="{$smarty.server.PHP_SELF}?step=3" enctype="multipart/form-data" role="form">

	<div class="TM-card">
		<div class="row">
			<div class="form-group col-sm-6">
				<label for="inputName">{$LANG.supportticketsclientname}</label>
				<input type="text" name="name" id="inputName" value="{$name}" class="form-control{if $loggedin} disabled{/if}"{if $loggedin} disabled="disabled"{/if} />
			</div>
			<div class="form-group col-sm-6">
				<label for="inputEmail">{$LANG.supportticketsclientemail}</label>
				<input type="email" name="email" id="inputEmail" value="{$email}" class="form-control{if $loggedin} disabled{/if}"{if $loggedin} disabled="disabled"{/if} />
			</div>
		</div>
		<div class="row">
			<div class="form-group col-sm-{if $loggedin}4{else}6{/if}">
				<label for="inputDepartment">{$LANG.supportticketsdepartment}</label>
				<select name="deptid" id="inputDepartment" class="form-control" onchange="refreshCustomFields(this)">
					{foreach from=$departments item=department}
						<option value="{$department.id}"{if $department.id eq $deptid} selected="selected"{/if}>
							{$department.name}
						</option>
					{/foreach}
				</select>
			</div>
			{if $relatedservices}
				<div class="form-group col-sm-{if $loggedin}4{else}6{/if}">
					<label for="inputRelatedService">{$LANG.relatedservice}</label>
					<select name="relatedservice" id="inputRelatedService" class="form-control">
						<option value="">{$LANG.none}</option>
						{foreach from=$relatedservices item=relatedservice}
							<option value="{$relatedservice.id}"{if $relatedservice.id eq $selectedservice} selected="selected"{/if}>
								{$relatedservice.name} ({$relatedservice.status})
							</option>
						{/foreach}
					</select>
				</div>
			{/if}
			<div class="form-group col-sm-{if $loggedin}4{else}6{/if}">
				<label for="inputPriority">{$LANG.supportticketspriority}</label>
				<select name="urgency" id="inputPriority" class="form-control">
					<option value="High"{if $urgency eq "High"} selected="selected"{/if}>
						{$LANG.supportticketsticketurgencyhigh}
					</option>
					<option value="Medium"{if $urgency eq "Medium" || !$urgency} selected="selected"{/if}>
						{$LANG.supportticketsticketurgencymedium}
					</option>
					<option value="Low"{if $urgency eq "Low"} selected="selected"{/if}>
						{$LANG.supportticketsticketurgencylow}
					</option>
				</select>
			</div>
		</div>
	</div>
	
	<div class="TM-card">
		<div class="form-group">
			<label for="inputSubject">{$LANG.supportticketsticketsubject}</label>
			<input type="text" name="subject" id="inputSubject" value="{$subject}" class="form-control" />
		</div>
		<div class="form-group">
			<label for="inputMessage">{$LANG.contactmessage}</label>
			<textarea name="message" id="inputMessage" rows="12" class="form-control markdown-editor" data-auto-save-name="client_ticket_open">{$message}</textarea>
		</div>
	</div>
	
	

	
	<div class="TM-card">
        <div class="form-group">
            <label for="inputAttachments">{lang key='supportticketsticketattachments'}</label>
            <div class="input-group mb-1 attachment-group">
                <div class="custom-file">
                    <label class="custom-file-label text-truncate" for="inputAttachment1" data-default="Choose file">
                        {lang key='chooseFile'}
                    </label>
                    <input type="file" class="custom-file-input" name="attachments[]" id="inputAttachment1">
                </div>
                <div class="input-group-append">
                    <button class="btn btn-default" type="button" id="btnTicketAttachmentsAdd">
                        <i class="fas fa-plus"></i>
                        {lang key='addmore'}
                    </button>
                </div>
            </div>
            <div class="file-upload w-hidden">
                <div class="input-group mb-1 attachment-group">
                    <div class="custom-file">
                        <label class="custom-file-label text-truncate">
                            {lang key='chooseFile'}
                        </label>
                        <input type="file" class="custom-file-input" name="attachments[]">
                    </div>
                </div>
            </div>
            <div id="fileUploadsContainer"></div>
            <div class="text-muted">
                <small>{lang key='supportticketsallowedextensions'}: {$allowedfiletypes} ({lang key="maxFileSize" fileSize="$uploadMaxFileSize"})</small>
            </div>
        </div>
	</div>
	
	<div id="customFieldsContainer">
		{include file="$template/supportticketsubmit-customfields.tpl"}
	</div>
	
    <div id="autoAnswerSuggestions" class="w-hidden"></div>

    <div class="text-center margin-bottom">
        {include file="$template/includes/captcha.tpl"}
    </div>

    <div class="form-actions">
		<button type="submit" id="openTicketSubmit" class="btn btn-primary disable-on-click{$captcha->getButtonClass($captchaForm)}">
			{lang key='supportticketsticketsubmit'}
		</button>
        <a href="supporttickets.php" class="btn btn-default">{lang key='cancel'}</a>
    </div>

</form>

{if $kbsuggestions}
    <script>
        jQuery(document).ready(function() {
            getTicketSuggestions();
        });
    </script>
{/if}
