{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


<section class="section upgrade">
   <div class="card">
       <div class="card-body">
           {if !$serviceToBeUpgraded && $errorMessage}
           <div class="alert alert-warning">
               {$errorMessage}
           </div>
           {else}
           <h4>{lang key="upgradeService.serviceBeingUpgraded"}</h4>

           <div class="product-to-be-upgraded bg-light border rounded">
               <div class="row">
                   <div class="col-sm-9">
                       <h5>
                           {if $serviceToBeUpgraded->isService()}
                               {$serviceToBeUpgraded->product->productGroup->name} - {$serviceToBeUpgraded->product->name}
                           {else}
                               {$serviceToBeUpgraded->productAddon->name}
                           {/if}
                           <br>
                           <small>
                               {if $serviceToBeUpgraded->domain}
                                   {$serviceToBeUpgraded->domain}
                               {elseif $serviceToBeUpgraded->isAddon() && $serviceToBeUpgraded->service->domain}
                                   {$serviceToBeUpgraded->service->domain}
                               {else}
                                   {lang key="noDomain"}
                               {/if}
                           </small>
                       </h5>
                   </div>
                   <div class="col-sm-3 text-right">
                       <a href="{$WEB_ROOT}/clientarea.php?action=productdetails&id={if $serviceToBeUpgraded->isService()}{$serviceToBeUpgraded->id}{elseif $serviceToBeUpgraded->isAddon()}{$serviceToBeUpgraded->service->id}{/if}" class="btn btn-primary">
                           {lang key="manage"}
                       </a>
                   </div>
               </div>
           </div>

       </div>
   </div>
</section>


<section class="section">
	
        {if $errorMessage}
            <div class="alert alert-warning">
                {$errorMessage}
            </div>
		{else}
        
        <h4 class="pb-3 border-bottom mb-5">{lang key="upgradeService.chooseNew"}</h4>
			
        <div class="cros-pricing-container">
            <div class="row row-eq-height" id="upgrades">
				{foreach $upgradeProducts as $key => $product}
				<div class="pl-2 pr-2 col-lg-{if count($upgradeProducts) >= 4}3{elseif count($upgradeProducts) == 3}4{else}6{/if}">
					<div class="card upgrade-plans">
						<div class="card-body">
							<h4 class="card-title">{$product->name}</h4>

							
							<div class="desc">
								{$product->description}
							</div>
							
							{if $product->id == $serviceToBeUpgraded->productId}
								<div class="px-3 py-1 mb-3 current bg-primary rounded text-center">
									{lang key="upgradeService.currentProduct"}
								</div>
							
							{elseif $product->productKey == $recommendedProductKey}
								<div class="px-2 py-1 mb-3 recommended bg-secondary rounded text-center">
									{lang key="upgradeService.recommended"}
								</div>
							{else}
							
								<div class="px-2 py-1 mb-2">
									&nbsp;
								</div>						
							
							{/if}
							
							<ul class="list-unstyled list-inine"> 
								{foreach $product->features as $label => $value}
									<li>
									
									   {if is_bool($value)}
											<span class="feature-label">{$label}</span>
											<span class="feature-value">
												<i class="fas fa-{if $value}check text-success{else}times text-danger{/if}"></i>
											</span>
									   {else}
											<span class="feature-label">{$label}</span>
											<span class="feature-value"><b>{$value}</b></span> 
									   {/if}
									</li>
								{/foreach}
							</ul>
						</div>	
                        <div class="card-footer">
                            <form method="post" action="{routePath('upgrade-add-to-cart')}">
                                <input type="hidden" name="isproduct" value="{$isService}">
                                <input type="hidden" name="serviceid" value="{$serviceToBeUpgraded->id}">
                                <input type="hidden" name="productid" value="{$product->id}">
                                {if $allowMultipleQuantities}
                                    <div class="text-right pb-1">
                                        {lang key='orderForm.qty'}
                                        <input type="number" name="qty" min="{$minimumQuantity}" value="{$currentQuantity}" class="form-control input-inline input-inline-100">
                                    </div>
                                {/if}
                                <select name="billingcycle" class="form-control custom-select">
                                    {foreach $product->pricing()->allAvailableCycles() as $cycle}
                                        {if $permittedBillingCycles->showCycleForProduct($cycle->cycle())}
                                            <option value="{$cycle->cycle()}"
                                                    {if $permittedBillingCycles->isCycleDisabledForProduct(
                                                            $product->id,
                                                            $cycle->cycle()
                                                    )}
                                                        disabled
                                                    {/if}
                                            >
                                                {if $cycle->isRecurring()}
                                                    {if $cycle->isYearly()}
                                                        {$cycle->cycleInYears()}
                                                    {else}
                                                        {$cycle->cycleInMonths()}
                                                    {/if}
                                                    -
                                                {/if}
                                                {$cycle->toFullString()}
                                            </option>
                                        {/if}
                                    {/foreach}
                                </select>
                                <button type="submit" class="btn btn-primary btn-block mt-2" id="btnUpgradeSelect-{$product->productKey}"{if !$product->eligibleForUpgrade} disabled="disabled"{/if}>
                                    {lang key="upgradeService.select"}
                                </button>
                            </form>
                        </div>
							
					</div>
				</div>
				{if count($upgradeProducts) >= 4 && (($key + 1) % 4 == 0)}				
			</div>
			<div class="pricing-slider row">
				{/if}
				{/foreach}
			</div>
			{/if}
		</div>
		{/if}
</section>




