{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}


{include file="$template/includes/flashmessage.tpl"}

<div class="section">
	<form method="post" action="{routePath('user-profile-save')}">
		<div class="TM-card">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-group">
						<label for="inputFirstName" class="control-label">
							{lang key='clientareafirstname'}
						</label>
						<input
							type="text"
							name="firstname"
							id="inputFirstName"
							value="{$user->firstName}"
							class="form-control"
							{if in_array('firstname', $uneditableFields)}disabled="disabled"{/if}
						>
					</div>
				</div>
				<div class="col-sm-6">
					<div class="form-group">
						<label for="inputLastName" class="control-label">
							{lang key='clientarealastname'}
						</label>
						<input
							type="text"
							name="lastname"
							id="inputLastName"
							value="{$user->lastName}"
							class="form-control"
							{if in_array('lastname', $uneditableFields)}disabled="disabled"{/if}
						>
					</div>
				</div>
			</div>
		</div>
		<div class="form-actions">
			<input class="btn btn-primary" type="submit" name="save" value="{lang key='clientareasavechanges'}" />
			<input class="btn btn-default" type="reset" value="{lang key='cancel'}" />
		</div>
	</form>

</div>

<div class="section">
	<h4>{lang key='userProfile.changeEmail'}</h4>
	<p>
		{if $user->needsToCompleteEmailVerification()}
			<span class="label label-default">{lang key='userProfile.notVerified'}</span>
		{elseif $user->emailVerified()}
			<span class="label label-success">{lang key='userProfile.verified'}</span>
		{/if}
	</p>

	<form method="post" action="{routePath('user-profile-email-save')}">
		<div class="TM-card">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-group">
						<label for="inputEmail" class="control-label">
							{lang key='clientareaemail'}
						</label>
						<input
							type="email"
							name="email"
							id="inputEmail"
							value="{$user->email}"
							class="form-control"
							{if in_array('email', $uneditableFields)}disabled="disabled"{/if}
						>
					</div>
				</div>
			</div>
		</div>
		<div class="form-actions">
			<input class="btn btn-primary" type="submit" name="save" value="{lang key='clientareasavechanges'}" />
			<input class="btn btn-default" type="reset" value="{lang key='cancel'}" />
		</div>
	</form>
</div>
