{if $selectedAccountId === $client->id}
	<div class="card-list">
		{foreach $client->payMethods->validateGateways()->sortByExpiryDate() as $payMethod}
			{assign "payMethodExpired" 0}
			{assign "expiryDate" ""}
			{if $payMethod->isCreditCard()}
				{if ($payMethod->payment->isExpired())}
					{assign "payMethodExpired" 1}
				{/if}

				{if $payMethod->payment->getExpiryDate()}
					{assign "expiryDate" $payMethod->payment->getExpiryDate()->format('m/Y')}
				{/if}
			{/if}
			<label class="card-item border rounded{if $payMethodExpired} disabled{/if}" data-paymethod-id="{$payMethod->id}" for="existing-card">
				<div class="card-item-checkbox ml-0">
					<div class="paymethod-info no-border p-0 radio-inline" data-paymethod-id="{$payMethod->id}">
						<input type="radio"
							   name="ccinfo"
							   class="existing-card"
							   {if $payMethodExpired}disabled{/if}
							   data-payment-type="{$payMethod->getType()}"
							   data-payment-gateway="{$payMethod->gateway_name}"
							   data-order-preference="{$payMethod->order_preference}"
							   value="{$payMethod->id}">
					</div>
				</div>
				<div class="card-item-icon">
					<div class="paymethod-info no-border p-0" data-paymethod-id="{$payMethod->id}">
						<i class="{$payMethod->getFontAwesomeIcon()} fa-fw bigger-150"></i>
					</div>
				</div>
				<div class="card-item-name">
					<div class="paymethod-info no-border p-0" data-paymethod-id="{$payMethod->id}">
						{if $payMethod->isCreditCard() || $payMethod->isRemoteBankAccount()}
							{$payMethod->payment->getDisplayName()}
						{else}
							<span class="type">
							{$payMethod->payment->getAccountType()}
						</span>
							{substr($payMethod->payment->getAccountNumber(), -4)}
						{/if}
					</div>
					{if $payMethod->getDescription()}
						<span class="small text-muted" data-paymethod-id="{$payMethod->id}">{$payMethod->getDescription()}</span>
					{else}
						-
					{/if}
				</div>
				<div class="card-item-status text-muted">
					<div class="paymethod-info no-border p-0" data-paymethod-id="{$payMethod->id}">
						{$expiryDate}{if $payMethodExpired}<br><small>{$LANG.clientareaexpired}</small>{else}<span class="label status status-{$payMethod->getStatus()|lower}">{$payMethod->getStatus()}</span>{/if}
					</div>
				</div>
			</label>
		{/foreach}
	</div>
{/if}
