{foreach $renewableItems as $renewableItem}
    <div class="service-renewal card{if !empty($renewableItem.addons)} bg-white{else} bg-light{/if}"
         data-product-name="{$renewableItem.product->name}"
         data-service-id="{$renewableItem.serviceId}"
         data-service-domain="{$renewableItem.domain}"
         {if $renewableItem.renewable === false}style="display: none;" data-is-renewable="false" {else}data-is-renewable="true"{/if}
    >
		<div class="card-body p-3">
			<div class="pull-right float-right">
				{if $renewableItem.renewable === false}
					<span class="label label-info">
						{lang key='renewService.renewalUnavailable'}
					</span>
				{else}
					<span class="label label-warning">
						{lang key='renewService.renewingIn' days=$renewableItem.nextDueDate->diffInDays()}
					</span>
				{/if}
			</div>
			<h4 class="m-0">{$renewableItem.product->name}</h4>
			<p class="text-muted">{$renewableItem.domain}</p>
			<p>
				{if is_null($renewableItem.nextDueDate)}
					{lang key='renewService.serviceNextDueDateBasic' nextDueDate={lang key='na'}}
				{else}
					{lang key='renewService.serviceNextDueDateExtended' nextDueDate=$renewableItem.nextDueDate->toClientDateFormat() nextDueDateFormatted=$renewableItem.nextDueDate->diffForHumans()}
				{/if}
			</p>
		</div>
		<div class="card-footer d-flex space-between flex-column flex-md-row">
            <div class="">
                {if $renewableItem.renewable === false}
                    <div class="div-renewal-ineligible">
                        <i class="fas fa-info-circle"></i>{$renewableItem.reason}
                    </div>
                {else}
                    <div class="div-renewal-period-label">
                        {lang key='renewService.renewalPeriodLabel'}
                    </div>
                    <div>
                        {lang key='renewService.renewalPeriod' nextDueDate=$renewableItem.nextDueDate->toClientDateFormat() nextPayUntilDate=$renewableItem.nextPayUntilDate->toClientDateFormat() renewalPrice=$renewableItem.price}
                    </div>
                {/if}
            </div>
            {if $renewableItem.renewable === true}
                <button id="renewService{$renewableItem.serviceId}" class="btn btn-primary btn-add-renewal-to-cart mt-md-0 mt-3" data-service-id="{$prefix}{$renewableItem.serviceId}">
                    <span class="to-add">
                        <i class="fas fa-fw fa-spinner fa-spin"></i>
                        {lang key='addtocart'}
                    </span>
                    <span class="added">
                        {lang key='domaincheckeradded'}
                    </span>
                </button>
            {/if}
		</div>
		{if !empty($renewableItem.addons)}
			<div class="addon-renewals m-3"
				 {if $renewableItem.renewableCount <= 0}style="display: none;" data-is-renewable="false" {else}data-is-renewable="true"{/if}
			>
				<h4><strong>{lang key='cartaddons'}</strong></h4>
				<div>
					{include file="orderforms/{$carttpl}/service-renewal-item.tpl" renewableItems=$renewableItem.addons prefix='a-'}
				</div>
			</div>
		{/if}
    </div>

{/foreach}