class SectionWithItems {
    static get toolbox() {
        return {
            title: 'Key Features',
            icon: '<i class="fas fa-list"></i>'
        };
    }
    constructor( {data}){
        this.data = data;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, 
			subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Key Features<a class="sec-docs" href="https://docs.thememetro.com/#Sec-KeyFeatures" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control wsinput" placeholder="i.e., All Plans Included" value=""/>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="row">
				  <div class="col-md-6">
					 <div class="form-group">
					   <label>Background Type</label>
					   <select type="select" class="form-control blockbgcolor">
						 <option value="">None</option>
						 <option value="light">Light</option>
					   </select>
					 </div>
				  </div>
				  <div class="col-md-6">
					 <div class="form-group">
						<label>Border</label>
						<select type="select" class="form-control blockborders">
						  <option value="">None</option>
						  <option value="border-top">Top Border</option>
						  <option value="border-bottom">Bottom Border</option>
						</select>
					</div>
				  </div>
				  <div class="col-md-6">
					 <div class="form-group">
						<label>Padding Top</label>
						<select type="select" class="form-control blocktheight">
						  <option value="">Default</option>
						  <option value="1">60px</option>
						  <option value="2">30px</option>
						  <option value="3">No Space</option>
						</select>
					</div>
				  </div>
				  <div class="col-md-6">
					 <div class="form-group">
						<label>Padding Bottom</label>
						<select type="select" class="form-control blockbheight">
						  <option value="">Default</option>
						  <option value="1">60px</option>
						  <option value="2">30px</option>
						  <option value="3">No Space</option>
						</select>
					</div>
				  </div>
				</div>
			</div>
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>`);
 
		const title = this.data && this.data.title ? this.data.title : "";
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);		
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);		
        const blocktheight = this.data && this.data.btheight ? this.data.btheight : "";
        $(wrapper).find(".blocktheight").val(blocktheight);	
        const blockbheight = this.data && this.data.bbheight ? this.data.bbheight : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the feature <b> \"" + args.item.Feature + "\" </b> wfrom this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Feature", type: "text", width: 200, validate: {validator: "required", message: "The Feature is required."}},
				{name: "Value", type: "text", width: 200, validate: {validator: "required", message: "The Value is required."}},
                //{type: "control"}
                //changed input to buttons
                {type: "control", width: 50, editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                clickHandler(grid, e);
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
	
				
              } //changed input to buttons
            ],
			invalidNotify: function(args) {
				args.errors.forEach(function(error) {
					alert(error.message);
				});
			},
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(title);
        }, 200);            
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
            "table": items,
            "title": $(blockContent).find(".wsinput").val(),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "btheight": $(blockContent).find(".blocktheight").val(),
            "bbheight": $(blockContent).find(".blockbheight").val(),
			"sechidden": sechidden
        };
    }
}