class featured_tlds {
    static get toolbox() {
        return {
            title: 'Featured TLDs',
            icon: '<i class="fas fa-list"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, title: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Featured TLDs<a class="sec-docs" href="https://docs.thememetro.com/#Sec-FeaturedTlds" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="bg-primary">Primary</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="graphics">Graphic</option>
					</select>
				</div>
				<div class="simginput">
					<div class="form-group">
						<label>Graphic</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bggraphic" class="form-control bggraphic" value="" />
							<span onclick="PageGraphics('${this.data.id}-bggraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				    <div class="row">
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Opacity</label>
						 <select type="select" class="form-control bgopacity">
						  <option value="">Dark</option>
						  <option value="1">Light</option>
						  <option value="2">None</option>
						 </select>
					   </div>
					 </div>
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Text Color</label>
						 <select type="select" class="form-control textcolor">
						   <option value="">Light</option>
							<option value="text-dark">Dark</option>
						 </select>
					   </div>
					 </div>					   
				    </div>					
				</div>
			</div>
			<div class="sborderinput">
				<div class="heading">
					<h5>Section Border & Spacing</h5>
				</div>
				<div class="sec_groups">			
				  <div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					 </select>
				  </div>
				  <div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				  </div>			  
				</div>
			</div>
			<div class="heading">
				<h5>TLDs Settings</h5>
			</div>
			<div class="sec_groups">
				<div class="row">					
					<div class="col-md-4">
						<div class="form-group">
							<label>TLDs List Type</label>
							<select type="select" class="form-control tldstype">
								<option value="">Default</option>
								<option value="1">Centered</option>
								<option value="2">Small Inline</option>
							</select>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label>TLDs List Pricing</label>
							<select type="select" class="form-control itempricing">
								<option value="">Register</option>
								<option value="1">Register + Renewal</option>
								<option value="2">Transfer</option>
								<option value="3">Transfer + Renewal</option>
								<option value="4">Renewal</option>
							</select>
						</div>
					</div>					
					<div class="col-md-4">
						<div class="form-group">
						  <label>list count</label>
						  <input type="text" class="form-control laitems" value="" />
						</div>
					</div>					
				</div>
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">When enabled, the shadow effect will be disabled for the TLDs list.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success boxshadow" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>			
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Display tlds on slider instead of grid.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success displayinslider" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
				<div class="SliderOptions">
					<div class="form-group">
						<select type="select" class="form-control slidertype">
							<option value="">Slider with dots or bullet indicators at the bottom</option>
							<option value="1">Slider with "left" and "right" navigation arrows</option>
						</select>
					</div>
				</div>				
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-1">
				<h5>TLDs Linked Page</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-1" class="collapse">			
				<div class="sec_groups">
					<div class="form-group">
						<label>Button Text</label>
						<input type="text" class="form-control btnText" />
					</div>
					<div class="form-group">
						<label>Button Link Type</label>
						<select type="select" class="form-control linktype">
							<option value="">Custom URL</option>
							<option value="1">Page Manager</option>
							<option value="2">Product Group</option>
							<option value="3">Product</option>
						</select>
					</div>
					<div class="curl">
						<div class="form-group">
							<label>Link To</label>
							<input type="text" class="form-control bgclink" placeholder="add custom URL..">
						</div>
					</div>
					<div class="purl">
						<div class="form-group">
							<label>Link To</label>
							<select type="select" class="form-control pagelink">${cmsPages}</select>
						</div>
					</div>
					<div class="gurl">
						<div class="form-group">
							<label>Link To</label>
							<select type="select" class="form-control grouplink">${groupSelect}</select>
						</div>
					</div>
					<div class="pdurl">
						<div class="form-group">
							<label>Link To</label>
							<select type="select" class="form-control productlink">${productsSelect}</select>
						</div>
					</div>
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>		
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-panel">
					<div class="form-group">
						<label>Select TLD </label><select type="select" class="form-control tlds">${tldSelect}</select>
					</div>								
					<div class="form-group">
						<label>TLD Graphic</label>
						<input type="medialib" class="form-control tlds_graphic">
					</div>
				</div>				
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
		const bggraphic = this.data && this.data.bggraphic ? this.data.bggraphic : "";
        $(wrapper).find(".bggraphic").val(bggraphic);
		const bgopacity = this.data && this.data.bgopacity ? this.data.bgopacity : "";
        $(wrapper).find(".bgopacity").val(bgopacity);
		const textcolor = this.data && this.data.textcolor ? this.data.textcolor : "";
        $(wrapper).find(".textcolor").val(textcolor);
		const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);		
		const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);		
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);        
		const itempricing = this.data && this.data.itempricing ? this.data.itempricing : "";
        $(wrapper).find(".itempricing").val(itempricing);		
		const tldstype = this.data && this.data.type ? this.data.type : "";
        $(wrapper).find(".tldstype").val(tldstype); 		
		const slidertype = this.data && this.data.slidertype ? this.data.slidertype : "";
        $(wrapper).find(".slidertype").val(slidertype);        			        
		const btnText = this.data && this.data.btnText ? this.data.btnText : "";
        $(wrapper).find(".btnText").val(btnText);
        const linkType = this.data && this.data.LinkType ? this.data.LinkType : "";
        $(wrapper).find(".linktype").val(linkType);
        const clink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".bgclink").val(clink)		
        const PageLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".pagelink").val(PageLink);
        const GroupLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".grouplink").val(GroupLink);
        const ProductLink = this.data && this.data.link ? this.data.link : "";
        $(wrapper).find(".productlink").val(ProductLink);		
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked', 'checked');
        }		
        if (this.data.DisplayInSlider === true) {
            $(wrapper).find('.displayinslider').attr('checked', 'checked');
        }		
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }

		function togglePanel(switcher, panel, showOnChecked = true) {
			if ($(wrapper).find(switcher).is(':checked') === showOnChecked) {
				$(wrapper).find(panel).show();
			} else {
				$(wrapper).find(panel).hide();
			}
		}
		$(wrapper).find('.displayinslider').on('change', function() {
			togglePanel('.displayinslider', '.SliderOptions');
		});
		
		togglePanel('.displayinslider', '.SliderOptions');

		
		const select2Elements = [
			{ selector: ".pagelink", placeholder: 'Select a page' },
			{ selector: ".productlink", placeholder: 'Select a product' },
			{ selector: ".grouplink", placeholder: 'Select a products group' }
		];

		select2Elements.forEach(function(item) {
			$(wrapper).find(item.selector).select2({
				placeholder: item.placeholder,
				allowClear: true
			});
		});

		function btnLinkVisibility(wrapper, value) {
			$(wrapper).find('.curl, .purl, .gurl, .pdurl').addClass('hidden');
			switch (value) {
				case '':
					$(wrapper).find('.curl').removeClass('hidden');
					break;
				case '1':
					$(wrapper).find('.purl').removeClass('hidden');
					break;
				case '2':
					$(wrapper).find('.gurl').removeClass('hidden');
					break;
				case '3':
					$(wrapper).find('.pdurl').removeClass('hidden');
					break;
			}
		}
		
		btnLinkVisibility(wrapper, $(wrapper).find('.linktype').val());
		$(wrapper).find('.linktype').on('change', function () {
			btnLinkVisibility(wrapper, $(this).val());
		});		
		
		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
		//
		function secOptions(wrapper, selector, condition) {
			$(wrapper).find(selector).toggleClass('hidden', !condition);
		}
		
		secOptions(wrapper, '.simginput', $(wrapper).find('.blockbgcolor').val() === 'graphics');

		$(wrapper).find('.blockbgcolor').on('change', function () {
			secOptions(wrapper, '.simginput', $(this).val() === 'graphics');
		});
		//
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the <b> \"" + args.item.tld + "\" </b> </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var tlds = item;
				var graphicElement = "";
				if (tlds.graphic) {
					if (tlds.graphic.includes("fa-")) {
						graphicElement = "<span class='fa-fw " + tlds.graphic + "'></span>";
					} else {
						graphicElement = "<img src='" + whmcsBaseUrl + "/" + tlds.graphic + "' class='thumbnail_placeholder feature_icon'>";
					}
				}
				var $config = $("<div>").addClass("panel panel-default")
                .append($("<div class='panel-heading'><h3 class='panel-title'>").html(graphicElement + " " + tlds.tld));

				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block custom-grid jsgrid-align-left").attr("width", "400px").append($config))
					.append($cButtons);
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{name: "tld", title: "TLDs", type: "select", width: 400, items: bycdomains, valueField: "extension", textField: "extension", align: "left", css: "grid-info-block"},
                {name: "graphic", title: "Graphic", type: "text", visible: false, sorting: false},
                //{type: "control"}
                //changed input to buttons
                {type: "control", editButton: false,	
                 _createGridButton: function(cls, tooltip, clickHandler) {
                      var grid = this._grid;

                      return $("<button>").addClass(this.buttonClass)
                         .addClass(cls)
                           .attr({
                                type: "button",
                                title: tooltip
                               })
                            .on("click", function(e) {
                                //clickHandler(grid, e);
								showDetailsDialog("Add", {});
                            });
                     },

                    editValue: function() {
                       return "";
                   }				
				
				
              } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;
		var sectionId = this.data?.id || "";

        var showDetailsDialog = function (dialogType, tlds, itemIndex) {
			
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "tlds_new_" : "tlds_" + itemIndex;
			
			if (isNew) {
				tlds = {
					tld: '',
					graphic: ''
				};
			}

			$(wrapper).find('input[type="medialib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageMedia(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Graphic"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageMedia('" + uniqueId + "')");
				}
			});			

            $(wrapper).find(".tlds").val(tlds.tld);
			$(wrapper).find(".tlds").select2().trigger("change");
            $(wrapper).find(".tlds_graphic").val(tlds.graphic);
			
            formSubmitHandler = function () {
                saveTlds(tlds, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .tlds").prop("selectedIndex") === -1) {
			  alert('Please select a tld from the list.');
			  e.preventDefault();
			} else {
			  formSubmitHandler();
			}
        });

		
        var saveTlds = function (tlds, isNew) {			
            $.extend(tlds, {
				tld: $(wrapper).find(".tlds").val(),
				graphic: $(wrapper).find(".tlds_graphic").val()
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", tlds);
            $(wrapper).find(".modal").modal('hide');
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
		var noshadow = $(blockContent).find(".boxshadow").is(':checked');
		var DisplayInSlider = $(blockContent).find(".displayinslider").is(':checked');
		
		function getLinkBasedOnLinkType(LinkType) {
			switch (LinkType) {
				case "1":
					return $(blockContent).find(".pagelink").val();
				case "2":
					return $(blockContent).find(".grouplink").val();
				case "3":
					return $(blockContent).find(".productlink").val();
				default:
					return $(blockContent).find(".bgclink").val();
			}
		}
		
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "bggraphic": $(blockContent).find(".bggraphic").val(),
			"bgopacity": $(blockContent).find(".bgopacity").val(),
			"textcolor": $(blockContent).find(".textcolor").val(),			
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),			
            "type": $(blockContent).find(".tldstype").val(),
            "slidertype": $(blockContent).find(".slidertype").val(),
            "itempricing": $(blockContent).find(".itempricing").val(),
            "btnText": $(blockContent).find(".btnText").val(),
			"LinkType": $(blockContent).find(".linktype").val(),
			"link": getLinkBasedOnLinkType($(blockContent).find(".linktype").val()),
			"DisplayInSlider": DisplayInSlider,			
            "itemcounts": $(blockContent).find(".laitems").val(),
			"noshadow" : noshadow,
			"sechidden": sechidden
        };
    }
}