class gallery {
    static get toolbox() {
        return {
            title: 'Gallery',
            icon: '<i class="fas fa-images"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }, subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Gallery<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Gallery" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Description</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
				   <label>Title</label>
				   <input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="bg-primary">Primary</option>
						<option value="light">Light</option>
						<option value="dark">Dark</option>
						<option value="graphics">Graphic</option>
					</select>
				</div>
				 <div class="simginput">					 
					 <div class="form-group">
						<label>Graphic</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bggraphic" class="form-control bggraphic" value="" />
							<span onclick="PageGraphics('${this.data.id}-bggraphic')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				    <div class="row">
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Opacity</label>
						 <select type="select" class="form-control bgopacity">
						  <option value="">Dark</option>
						  <option value="1">Light</option>
						  <option value="2">None</option>
						 </select>
					   </div>
					 </div>
					 <div class="col-sm-6">
					   <div class="form-group">
						<label>Text Color</label>
						 <select type="select" class="form-control textcolor">
						   <option value="">Light</option>
							<option value="text-dark">Dark</option>
						 </select>
					   </div>
					 </div>					   
				    </div>					
				</div>
			</div>
			<div class="sborderinput">
				<div class="heading">
					<h5>Section Border & Spacing</h5>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<label>Border</label>
						<select type="select" class="form-control blockborders">
							<option value="">None</option>
							<option value="border-top">Top Border</option>
							<option value="border-bottom">Bottom Border</option>
						</select>
					</div>
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label>Padding Top</label>
								<select type="select" class="form-control blocktheight">
									<option value="">Default</option>
									<option value="1">60px</option>
									<option value="2">30px</option>
									<option value="3">No Space</option>
								</select>
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<label>Padding bottom</label>
								<select type="select" class="form-control blockbheight">
									<option value="">Default</option>
									<option value="1">60px</option>
									<option value="2">30px</option>
									<option value="3">No Space</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Gallery Settings</h5>
			</div>
			<div class="sec_groups">
				
				<div class="form-group">
					<div class="flex-checkbox">
						<span class="control-label">Display features on slider instead of grid.</span>
						<label class="switch">
							<input type="checkbox" class="form-control success displayinslider" />
							<span class="slider round"></span>
						</label>
					</div>
				</div>
				<div class="SliderOptions">
					<div class="form-group">
						<select type="select" class="form-control slidertype">
							<option value="">Slider with dots or bullet indicators at the bottom</option>
							<option value="1">Slider with "left" and "right" navigation arrows</option>
						</select>
					</div>
				</div>			
				<div class="form-group">
					<label>list count</label>
					<input type="text" class="form-control laitems" value="" />
				</div>
			</div>			
			<div class="vjsGrid"></div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit gallery item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
				<div class="form-group">
					<label>Item Graphic</label>
					<input type="imagelib" class="form-control graphic">
				</div>
				<div class="form-group">
					<label>Alt Tag</label>
					<input type="text" class="form-control alttag">
				</div>
				<div class="form-group">
					<label>Graphic Title</label>
					<input type="text" class="form-control itemTitle">
				</div>
                <div class="form-group">
					<div class="flex-checkbox">
					<span class="control-label">Enable this option to display a zoom icon when hovering over the gallery item.</span>
                      <label class="switch">
					    <input type="checkbox" class="success zoomin">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
				<div class="form-group zoominput">
					<input type="imagelib" class="form-control largeGraphic">
					<span class="help-block">This is an optional field. Use it to display an alternative grpahic instead of the main graphic when zoomed in.</span>
				</div>
				<div class="form-group">
					<label>Link Type</label>
					<select type="select" class="form-control linktype">
						<option value="">Custom URL</option>
						<option value="1">Page Manager</option>
						<option value="2">Product Group</option>
						<option value="3">Product</option>
					</select>
				</div>
				<div class="curl">
					<div class="form-group">
						<label>Link To</label>
						<input type="text" class="form-control bsblink" placeholder="add custom URL..">
					</div>
				</div>
				<div class="purl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control pagelink">${cmsPages}</select>
					</div>
				</div>
				<div class="gurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control grouplink">${groupSelect}</select>
					</div>
				</div>
				<div class="pdurl">
					<div class="form-group">
						<label>Link To</label>
						<select type="select" class="form-control productlink">${productsSelect}</select>
					</div>
				</div>				
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);

        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
        const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);
        const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);
        const bggraphic = this.data && this.data.bggraphic ? this.data.bggraphic : "";
        $(wrapper).find(".bggraphic").val(bggraphic);
		const bgopacity = this.data && this.data.bgopacity ? this.data.bgopacity : "";
        $(wrapper).find(".bgopacity").val(bgopacity);
		const textcolor = this.data && this.data.textcolor ? this.data.textcolor : "";
        $(wrapper).find(".textcolor").val(textcolor);
		const slidertype = this.data && this.data.slidertype ? this.data.slidertype : "";
        $(wrapper).find(".slidertype").val(slidertype);		
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        if (this.data.DisplayInSlider === true) {
            $(wrapper).find('.displayinslider').attr('checked', 'checked');
        }			
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
		function togglePanel(switcher, panel, showOnChecked = true) {
			if ($(wrapper).find(switcher).is(':checked') === showOnChecked) {
				$(wrapper).find(panel).show();
			} else {
				$(wrapper).find(panel).hide();
			}
		}
		$(wrapper).find('.displayinslider').on('change', function() {
			togglePanel('.displayinslider', '.SliderOptions');
		});
		
		togglePanel('.displayinslider', '.SliderOptions');		

		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 3;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter the number ${min} OR ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('4');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('4'); 
			}
		});
		
        //
		function secOptions(wrapper, selector, condition) {
			$(wrapper).find(selector).toggleClass('hidden', !condition);
		}
		
		secOptions(wrapper, '.simginput', $(wrapper).find('.blockbgcolor').val() === 'graphics');

		$(wrapper).find('.blockbgcolor').on('change', function () {
			secOptions(wrapper, '.simginput', $(this).val() === 'graphics');
		});
        //
		
		//
        if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
			$(wrapper).find('.sborderinput').removeClass('hidden');
        } else {
            $(wrapper).find('.sborderinput').addClass('hidden');
        }
        $(wrapper).find('.blockbgcolor').on('change', function () {
            if ($(wrapper).find('.blockbgcolor').val() == 'light' || $(wrapper).find('.blockbgcolor').val() == '') {
                $(wrapper).find('.sborderinput').removeClass('hidden');
            } else {
                $(wrapper).find('.sborderinput').addClass('hidden');
            }
        });
		//

        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the below item from this section?<br> <img src=\"" + whmcsBaseUrl + "/" + args.item.graphic + "\" class=\"thumbnail_placeholder_alert\">",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
				{
					name: "graphic",
					title: "Gallery",
					type: "text",
					width: 400,
					align: "left",
					css: "grid-info-block",		  
					itemTemplate: function(value, item) {
					  var $graphic = $("<div>").addClass("");
					  var $image = $("<img>").attr("src", whmcsBaseUrl.replace(/\/?$/, '/') + value).addClass("thumbnail_placeholder");
					  
					  // Handle image load error
					  $image.on("error", function() {
						$(this).replaceWith('<span class="fas fa-image fa-3x fa-fw"></span>');
					  });
					  
					  var $preview = $("<div>").addClass("").append($image);
					  $graphic.append($preview);
					  
					  return $graphic;
					}
				},
                {name: "itemTitle", title: "Caption/Description", type: "textarea", width: 100, visible: false, sorting: false},
                {name: "LargeGraphic", title: "Full Image", type: "text", width: 200, visible: false, sorting: false},
				{name: "AltTag", title: "Link", type: "text", width: 100, visible: false, sorting: false},
				{name: "Zooming", type: "checkbox", title: "Zoom", visible: false, sorting: false},
                {type: "control", editButton: false, width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
									showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }


                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, gallery, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "gallery_new_" : "gallery_" + itemIndex;
			
			if (isNew) {
				gallery = {
					Zooming: 0,
					itemTitle: '',
					graphic: '',
					LargeGraphic: '',
					alttag: '',
					LinkType: '',
					Link: ''
				};
			}		

			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".itemTitle").val(gallery.itemTitle);
            $(wrapper).find(".graphic").val(gallery.graphic);
            $(wrapper).find(".largeGraphic").val(gallery.LargeGraphic);
			$(wrapper).find(".linktype").val(gallery.LinkType);
			$(wrapper).find(".alttag").val(gallery.AltTag);
			$(wrapper).find(".zoomin").prop('checked', gallery.Zooming ? true : false);

			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
				{ selector: ".productlink", placeholder: 'Select a product' },
				{ selector: ".grouplink", placeholder: 'Select a products group' },
				{ selector: ".groupprice", placeholder: 'Select a product or group' }
			];

			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});

			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".bsblink").val(gallery.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".grouplink").val('');
						break;
					case '2':
						$(wrapper).find(".grouplink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					case '3':
						$(wrapper).find(".productlink").val(gallery.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".grouplink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					default:
						$(wrapper).find(".bsblink").val(gallery.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//gallery.LinkType = $(this).val();
				updateLinkFields();
			});
			
			if ($(wrapper).find('.zoomin').is(':checked')) {
				$(wrapper).find('.zoominput').removeClass('hidden');
			} else {
				$(wrapper).find('.zoominput').addClass('hidden');
			}
			$(wrapper).find('.zoomin').change(function() {
			  if ($(this).is(':checked')) {
				$(wrapper).find('.zoominput').removeClass('hidden');
			  } else {
				$(wrapper).find('.zoominput').addClass('hidden');
			  }
			});
			
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl'),
					pdurl: $(wrapper).find('.pdurl'),
					gurl: $(wrapper).find('.gurl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
					case '2':
						LinkInputs.gurl.removeClass('hidden');
						break;
					case '3':
						LinkInputs.pdurl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);
			
            formSubmitHandler = function () {
                saveGallery(gallery, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .graphic").val() === '') {
				alert('Image is required.');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
		
        var saveGallery = function (gallery, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".bsblink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				case '2':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '3':
					linkValue = $(wrapper).find(".productlink").val();
					break;
				default:
					linkValue = $(wrapper).find(".bsblink").val();
					break;
			}
			$.extend(gallery, {			
				graphic: $(wrapper).find(".graphic").val(),
                LargeGraphic: $(wrapper).find(".largeGraphic").val(),
                itemTitle: $(wrapper).find(".itemTitle").val(),
				LinkType: $(wrapper).find(".linktype").val(),
				AltTag: $(wrapper).find(".alttag").val(),
				Link: linkValue,
				Zooming: $(wrapper).find(".zoomin").is(':checked')
            });
			
			$(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", gallery);
            $(wrapper).find(".modal").modal('hide');
        };
		
        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        return wrapper;
    }
    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
		var DisplayInSlider = $(blockContent).find(".displayinslider").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
			"subtitle": subtitle,
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),
			"slidertype": $(blockContent).find(".slidertype").val(),
            "bggraphic": $(blockContent).find(".bggraphic").val(),
			"bgopacity": $(blockContent).find(".bgopacity").val(),
			"textcolor": $(blockContent).find(".textcolor").val(),
			"DisplayInSlider": DisplayInSlider,			
            "itemcounts": $(blockContent).find(".laitems").val(),
			"sechidden": sechidden
        };
    }
}