class products {
    static get toolbox() {
        return {
            title: 'Products',
            icon: '<i class="fas fa-server"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            subtitle: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
            },
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('simple-image');
        $(wrapper).append(`<div class="register-form">
	<div class="form">
		<div class="section_header">
			<label>Products<a class="sec-docs" href="https://docs.thememetro.com/#Sec-Products" target="_blank">Docs</a></label>
            <input type="text" value="" readonly="readonly"/>			
		</div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
		<div class="form-content llbld">
			<div class="heading">
				<h5>Section Descriptions</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Caption</label>
					<input type="text" class="form-control sectioncaption" value="" />
				</div>			
				<div class="form-group">
					<label>Title</label>
					<input type="text" class="form-control sectiontitle" value="" />
				</div>
				<div class="form-group">
					<label>Subitle</label>
					<textarea class="form-control sectionsubtitle" rows="6"></textarea>
				</div>				
			</div>
			<div class="heading">
				<h5>Section Background</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Background Type</label>
					<select type="select" class="form-control blockbgcolor">
						<option value="">None</option>
						<option value="light">Light</option>
					</select>
				</div>
			</div>
			<div class="heading">
				<h5>Section Border & Spacing</h5>
			</div>			
			<div class="sec_groups">
				<div class="form-group">
					<label>Border</label>
					<select type="select" class="form-control blockborders">
						<option value="">None</option>
						<option value="border-top">Top Border</option>
						<option value="border-bottom">Bottom Border</option>
					</select>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Top</label>
							<select type="select" class="form-control blocktheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label>Padding Bottom</label>
							<select type="select" class="form-control blockbheight">
								<option value="">Default</option>
								<option value="1">60px</option>
								<option value="2">30px</option>
								<option value="3">No Space</option>
							</select>
						</div>
					</div>
				</div>				
			</div>
			<div class="heading">
				<h5>Product Type</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Select Display Type</label>
					<select type="select" class="form-control pt_styles">
					  <option value="">Type 1 - Vertical aligned products</option>
					  <option value="pts_1">Type 2 - Horizontal aligned products</option>
					  <option value="pts_2">Type 3 - Products comparison</option>
					  <option value="pts_3">Type 4 - Graphic product, No description</option>
					</select>
				</div>				
			</div>
			<div class="heading collapsed" data-toggle="collapse" href="#${this.data.id}-1">
				<h5>Products Settings</h5>
				<button type="button" class="heading_btn">
					<span class="heading_btn_text">Expand</span>
					<span class="heading_btn_text">Hide</span>
					<span class="fal fa-angle-down"></span>
				</button>
			</div>
			<div id="${this.data.id}-1" class="collapse">
				<div class="sec_groups">
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label>Button Text</label>
								<input type="text" class="form-control tablebtntext" placeholder="i.e., Add to Cart" value="" />
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<label>Products Background Color</label>
								<select type="select" class="form-control tablebgcolor">
									<option value="">None</option>
									<option value="light">Light</option>
									<option value="primary">Primary</option>
									<option value="dark">Dark</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="pt_cont">
					<div class="sec_groups">
						<div class="form-group">
							<label>list count</label>
							<input type="text" class="form-control laitems" value="" />
						</div>
					</div>
				</div>
				<div class="sec_groups">
					<div class="pt_st">
						<div class="form-group">
							<label>Featured Sticker Style</label>
							<select type="select" class="form-control stickerstyle">
								<option value="">Type 1</option>
								<option value="st_s-2">Type 2</option>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label>Featured Item Text</label>
						<input type="text" class="form-control wsinput" placeholder="i.e., Most Popular" value="" />
					</div>
				</div>
				<div class="sec_groups pt_flg">
					<div class="pt_fd">
					   <div class="form-group">
						 <label>Features Description Position</label>
						 <select type="select" class="form-control blockdesc">
							<option value="">Above pricing</option>
							<option value="1">Below pricing</option>
							<option value="2">Before feature descriptions</option>
						  </select>
						</div>
						<div class="form-group">
							<div class="flex-checkbox">
								<span class="control-label">Display order button in last.</span>
								<label class="switch">
									<input type="checkbox" class="form-control success dobp" />
									<span class="slider round"></span>
								</label>
							</div>
						</div>						
					</div>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">Override the <b>Monthly Pricing Breakdown</b> option if it is enabled in the WHMCS configuration.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success disable_brekdown" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>				
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">Disable the billing cycle switcher and display the pricing for the first available billing cycle.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success disable_switcher" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>					
					<div class="PricingOptionsPanel">
						<div class="form-group">
							<div class="flex-checkbox">
								<span class="control-label">Disable the inline billing cycle switcher and display a single billing cycle switcher showing the selected cycle(s).</span>
								<label class="switch">
									<input type="checkbox" class="form-control success display_switcher_option" />
									<span class="slider round"></span>
								</label>
							</div>
						</div>
						<div class="cyclePanel">
							<div class="form-group">
								<select type="select" class="form-control scycles" multiple="multiple">${cycleOptions}</select>
							</div>
						</div>
						<div class="pt_bs_order">
							<div class="form-group">
								<div class="flex-checkbox">
									<span class="control-label">Reverse billing cycle order.</span>
									<label class="switch">
										<input type="checkbox" class="form-control success bscorder" />
										<span class="slider round"></span>
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="pt_centered">
						<div class="form-group">
							<div class="flex-checkbox">
								<span class="control-label">When enabled, all products will be displayed centered.</span>
								<label class="switch">
									<input type="checkbox" class="form-control success centered" />
									<span class="slider round"></span>
								</label>
							</div>
						</div>
					</div>
					<div class="pt_fds">
						<div class="form-group">
							<div class="flex-checkbox">
								<span class="control-label">Display products on grid instead of slider.</span>
								<label class="switch">
									<input type="checkbox" class="form-control success displayingrid" />
									<span class="slider round"></span>
								</label>
							</div>
						</div>
						<div class="SliderOptions">
							<div class="form-group">
								<select type="select" class="form-control slidertype">
									<option value="">Slider with dots or bullet indicators at the bottom</option>
									<option value="1">Slider with "left" and "right" navigation arrows</option>
								</select>
							</div>
						</div>						
					</div>
					<div class="pt_fdo">
						<div class="form-group">
							<div class="flex-checkbox">
								<span class="control-label">Disable the auto-collapse option for the product features list on small devices.</span>
								<label class="switch">
									<input type="checkbox" class="form-control success collapsed_option" />
									<span class="slider round"></span>
								</label>
							</div>
						</div>						
					</div>					
					<div class="form-group">
						<div class="flex-checkbox">
							<span class="control-label">When enabled, the shadow effect will be disabled for the products.</span>
							<label class="switch">
								<input type="checkbox" class="form-control success boxshadow" />
								<span class="slider round"></span>
							</label>
						</div>
					</div>
				</div>
			</div>
			<div style="margin-top: 10px;">
				<div class="vjsGrid"></div>
			</div>
		</div>
	</div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit product</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Product</label>
					<select type="select" class="form-control plan">${productsSelect}</select>
                </div>
				<div class="form-group">
					<label>Graphic for this product</label>
					<input type="medialib" class="form-control productgraphics">
				</div>
                <div class="form-group">
					<div class="flex-checkbox">
					  <span class="control-label">Enable this if you want display a featured banner on this product.</span>
                      <label class="switch">
					    <input type="checkbox" class="success featured">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
				<div class="pclink">
					<div class="form-group">
						<div class="flex-checkbox">
						  <span class="control-label">Replace default order button with custom link.</span>
						  <label class="switch">
							<input type="checkbox" class="success productlink">
							<span class="slider round"></span>
						  </label>
						</div>
					</div>
					<div class="well ProductLinkPanel">
						<div class="form-group">
							<label>Button Text</label>
							<input type="text" class="form-control itembtntext" />
						</div>
						<div class="form-group">
							<label>Button Link Type</label>
							<select type="select" class="form-control linktype">
								<option value="">Custom URL</option>
								<option value="1">Page Manager</option>
							</select>
						</div>
						<div class="curl">
							<div class="form-group">
								<label>Link To</label>
								<input type="text" class="form-control clink" placeholder="add custom URL..">
							</div>
						</div>
						<div class="purl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control pagelink">${cmsPages}</select>
							</div>
						</div>
					</div>
				</div>
				<div class="plan-help">
				  <div class="heading">
					<h5>Features and values for product comparison table</h5>
				  </div>
				  <div class="well">
					  <div class="form-group">
						<label>Features</label>
						<textarea type="text" rows="5" class="form-control features"></textarea>
					  </div>
					  <div class="form-group">
						<label>Values</label>
						<textarea type="text" rows="5" class="form-control values"></textarea>
					  </div>
				  </div>
				  <hr />
                 <p class="help-block">Please use the following format to add <strong>Features</strong> and <strong>Values</strong>. Enter the information directly in this section as it will not be pulled from the WHMCS product description.</p>
                    <h5><strong>Features:</strong> <span class="text-muted small">(should be same for all plans)</span></h5>
                    <code>&lt;div class=&quot;plan__cell&quot;&gt;Disk Space&lt;/div&gt;<br />&lt;div class=&quot;plan__cell&quot;&gt;Bandwidth&lt;/div&gt;</code>
                    <hr />
					<h5><strong>Values:</strong></h5>
                    <code>&lt;div class=&quot;plan__cell&quot;&gt;10,000MB&lt;/div&gt;<br />&lt;div class=&quot;plan__cell&quot;&gt;1000GB&lt;/div&gt;</code>							  
				</div>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary savedataid">Submit</button> 
			</div>
		</div>
	</div>
</div>`);
	
        const pt_styles = this.data && this.data.ptstyle ? this.data.ptstyle : "";
        $(wrapper).find(".pt_styles").val(pt_styles);
        const scycles = this.data && this.data.switcherCycles ? this.data.switcherCycles : "all";
        $(wrapper).find(".scycles").val(scycles);
        const blockbgcolor = this.data && this.data.bgcolor ? this.data.bgcolor : "";
        $(wrapper).find(".blockbgcolor").val(blockbgcolor);
        const blockborders = this.data && this.data.borders ? this.data.borders : "";
        $(wrapper).find(".blockborders").val(blockborders);
		const blocktheight = this.data && this.data.toppadding ? this.data.toppadding : "";
        $(wrapper).find(".blocktheight").val(blocktheight);		
		const blockbheight = this.data && this.data.bottompadding ? this.data.bottompadding : "";
        $(wrapper).find(".blockbheight").val(blockbheight);			
        const blockdesc = this.data && this.data.descp ? this.data.descp : "";
        $(wrapper).find(".blockdesc").val(blockdesc);
        const tablebgcolor = this.data && this.data.tablebg ? this.data.tablebg : "";
        $(wrapper).find(".tablebgcolor").val(tablebgcolor);
        const stickerstyle = this.data && this.data.ststyle ? this.data.ststyle : "";
        $(wrapper).find(".stickerstyle").val(stickerstyle);
        const laitems = this.data && this.data.itemcounts ? this.data.itemcounts : "3";
        $(wrapper).find(".laitems").val(laitems);
        const tablebtntext = this.data && this.data.btntext ? this.data.btntext : "";
        $(wrapper).find(".tablebtntext").val(tablebtntext);
        const sectioncaption = this.data && this.data.caption ? this.data.caption : "";
        $(wrapper).find(".sectioncaption").val(sectioncaption);		
        const sectiontitle = this.data && this.data.sectitle ? this.data.sectitle : "";
        $(wrapper).find(".sectiontitle").val(sectiontitle);
		const slidertype = this.data && this.data.slidertype ? this.data.slidertype : "";
        $(wrapper).find(".slidertype").val(slidertype);		
        const sectionsubtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(wrapper).find(".sectionsubtitle").val(sectionsubtitle);		
        if (this.data.noshadow === true) {
            $(wrapper).find('.boxshadow').attr('checked', 'checked');
        }
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
        if (this.data.centered === true) {
            $(wrapper).find('.centered').attr('checked', 'checked');
        }
        if (this.data.SbSwitcher === true) {
            $(wrapper).find('.display_switcher_option').attr('checked', 'checked');
        }
        if (this.data.featurescollapsed === true) {
            $(wrapper).find('.collapsed_option').attr('checked', 'checked');
        }
        if (this.data.orderLinkinLast === true) {
            $(wrapper).find('.dobp').attr('checked', 'checked');
        }
        if (this.data.DisplayInGrid === true) {
            $(wrapper).find('.displayingrid').attr('checked', 'checked');
        }
		if (this.data.DisableSwitcher === true) {
            $(wrapper).find('.disable_switcher').attr('checked', 'checked');
        }		
		if (this.data.DisableBrekdown === true) {
            $(wrapper).find('.disable_brekdown').attr('checked', 'checked');
        }		
        if (this.data.bsco === true || this.data.bsco == "1") {
            $(wrapper).find('.bscorder').attr('checked', 'checked');
        }
        const wsinput = this.data && this.data.featured ? this.data.featured : "";
		
		const cycleSwitcher = [
			{ selector: ".scycles", placeholder: 'Select Billing Cycles'},
		];
		
		cycleSwitcher.forEach(function(item) {
			$(wrapper).find(item.selector).select2({
				placeholder: item.placeholder,
				allowClear: true
			}).on('change', function() {
				var selectedValues = $(this).val() || [];

				if (selectedValues.includes("all")) {
					$(this).val(["all"]);
				} else {
					$(this).val(selectedValues.filter(value => value !== "all"));
				}
				$(this).trigger('change.select2');
			});
		});

		$(wrapper).find(".laitems").on('input', function() {
			const value = $(this).val();
			const min = 2;
			const max = 4;
			if (/^\d+$/.test(value)) {
				const numberValue = parseInt(value, 10);
				
				if (numberValue < min || numberValue > max) {
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
						text: `Please enter a number between ${min} and ${max}.`,
						confirmButtonColor: "#c1c1c1",
						html: true,
						buttons: true,
						dangerMode: true,
					});
					$(this).val('3');
				}
			} else {
				swal({
					title: "<i class='far fa-info-circle fa-fw text-danger'></i> Error",
					text: "Please enter a valid number.",
					confirmButtonColor: "#c1c1c1",
					html: true,
					buttons: true,
					dangerMode: true,
				});
				$(this).val('3'); 
			}
		});

        //
        if ($(wrapper).find('.pt_styles').val() == '') {
            $(wrapper).find('.pt_fd, .pt_cont, .pt_flg, .pt_st, .pt_fdo, .pt_fds, .pt_centered').removeClass('hidden');
            $(wrapper).find('.plan-help, .pclink').addClass('hidden');
        } else if ($(wrapper).find('.pt_styles').val() == 'pts_1') {
            $(wrapper).find('.pt_fd, .pt_cont, .plan-help, .pt_fdo, .pt_fds, .pt_centered, .pclink').addClass('hidden');
        } else if ($(wrapper).find('.pt_styles').val() == 'pts_2') {
            $(wrapper).find('.pt_fd, .pt_flg, .pt_st, .pt_fdo, .pt_fds, .pclink').addClass('hidden');
            $(wrapper).find('.pt_cont, .plan-help, .pt_centered').removeClass('hidden');
        } else if ($(wrapper).find('.pt_styles').val() == 'pts_3') {
            $(wrapper).find('.pt_cont, .pt_st, .pt_fds, .pclink').removeClass('hidden');
            $(wrapper).find('.pt_fd, .pt_flg, .pt_fdo, .plan-help, .pt_centered').addClass('hidden');			
        }

        $(wrapper).find('.pt_styles').on('change', function () {
			 if ($(wrapper).find('.pt_styles').val() == '') {
				$(wrapper).find('.pt_fd, .pt_cont, .pt_flg, .pt_st, .pt_fdo, .pt_fds, .pt_centered').removeClass('hidden');
				$(wrapper).find('.plan-help, .pclink').addClass('hidden');
			} else if ($(wrapper).find('.pt_styles').val() == 'pts_1') {
				$(wrapper).find('.pt_fd, .pt_cont, .plan-help, .pt_fdo, .pt_fds, .pt_centered, .pclink').addClass('hidden');
			} else if ($(wrapper).find('.pt_styles').val() == 'pts_2') {
				$(wrapper).find('.pt_fd, .pt_flg, .pt_st, .pt_fdo, .pt_fds, .pclink').addClass('hidden');
				$(wrapper).find('.pt_cont, .plan-help, .pt_centered').removeClass('hidden');
			} else if ($(wrapper).find('.pt_styles').val() == 'pts_3') {
				$(wrapper).find('.pt_cont, .pt_st, .pt_fds, .pclink').removeClass('hidden');
				$(wrapper).find('.pt_fd, .pt_flg, .pt_fdo, .plan-help, .pt_centered').addClass('hidden');			
			}
        });

		function togglePanel(switcher, panel, showOnChecked = true) {
			if ($(wrapper).find(switcher).is(':checked') === showOnChecked) {
				$(wrapper).find(panel).show();
			} else {
				$(wrapper).find(panel).hide();
			}
		}
		$(wrapper).find('.display_switcher_option').on('change', function() {
			togglePanel('.display_switcher_option', '.cyclePanel');
		});
		$(wrapper).find('.disable_switcher').on('change', function() {
			togglePanel('.disable_switcher', '.PricingOptionsPanel', false);
		});
		$(wrapper).find('.displayingrid').on('change', function() {
			togglePanel('.displayingrid', '.SliderOptions', false);
		});		
		
		togglePanel('.display_switcher_option', '.cyclePanel');
		togglePanel('.disable_switcher', '.PricingOptionsPanel', false);
		togglePanel('.displayingrid', '.SliderOptions', false);

		
        //	
		
		function getPlanNameById(plans, id) {
			var plan = plans.find(function(plan) {
				return plan.id === id;
			});
			return plan ? plan.name : "Unknown Plan";
		}
         
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
						var planId = args.item.Plan;
						var planName = getPlanNameById(plans, planId);
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the product <b> \"" + planName + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {name: "Plan", title: "Products", type: "select", width: 400, items: plans, valueField: "id", textField: "name", align: "left", css: "grid-info-block"},
                {name: "featurelist", type: "textarea", title: "Features", width: 200, visible: false, sorting: false},
                {name: "featuresvalues", type: "textarea", title: "Values", width: 200, visible: false, sorting: false},
                {name: "Featured", type: "checkbox", title: "Featured", visible: false, sorting: false},
                {name: "link", type: "text", width: 200, visible: false, sorting: false},
				{name: "ProductLink", type: "checkbox", title: "ProductLink", visible: false, sorting: false},
				{type: "control", editButton: false,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                            .addClass(cls)
                            .attr({
                                type: "button",
                                title: tooltip
                            })
                            .on("click", function (e) {
                                // clickHandler(grid, e);
                                showDetailsDialog("Add", {});
                            });
                    },

                    editValue: function () {
                        return "";
                    }
                }
            ],	
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });

        var formSubmitHandler = $.noop;

        var showDetailsDialog = function (dialogType, product, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "product_new_" : "product_" + itemIndex;
			
            if (dialogType === "Add") product = {
                Plan: 0,
                Featured: 0,
				ProductbtnText: '',
				ProductLink: 0,
				LinkType: '',
				link: '',
				Graphic: '',
                featurelist: '',
                featuresvalues: ''
            };
			$(wrapper).find('input[type="medialib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageMedia(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageMedia('" + uniqueId + "')");
				}
			});
			
            $(wrapper).find(".plan").val(product.Plan);
            $(wrapper).find(".features").val(product.featurelist);
            $(wrapper).find(".values").val(product.featuresvalues);
            $(wrapper).find(".productgraphics").val(product.Graphic);
            $(wrapper).find(".featured").prop('checked', product.Featured);
			$(wrapper).find(".itembtntext").val(product.ProductbtnText);
			$(wrapper).find(".productlink").prop('checked', product.ProductLink ? true : false);
			$(wrapper).find(".linktype").val(product.LinkType);
			$(wrapper).find(".plan").select2().trigger("change");
			
			$(wrapper).find(".productlink").each(function() {
				var checkboxId = uniqueIDPrefix + "_productlink";
				var panelClass = ".ProductLinkPanel";

				$(this).attr("id", checkboxId);

				$(this).on("change", function() {
					let isChecked = this.checked;
					$(panelClass).toggleClass("hidden", !isChecked, {
						duration: 300
					});
				}).trigger("change");
			});			

			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
			];
			
			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});
			
			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".clink").val(product.link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(product.link).trigger('change');
						$(wrapper).find(".clink").val('');
						break;
					default:
						$(wrapper).find(".clink").val(product.link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//product.LinkType = $(this).val();
				updateLinkFields();
			});
			
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);

		
            formSubmitHandler = function () {
                saveProduct(product, dialogType === "Add");
            };

            $(wrapper).find(".modal").modal('show');
        };

        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .plan").prop("selectedIndex") === -1) {
				alert('Please select a product from list');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });

        var saveProduct = function (product, isNew) {			
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".clink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				default:
					linkValue = $(wrapper).find(".clink").val();
					break;
			}

            $.extend(product, {
                Plan: parseInt($(wrapper).find(".plan").val()),
				ProductbtnText: $(wrapper).find(".itembtntext").val(),
				LinkType: $(wrapper).find(".linktype").val(),
				link: linkValue,
                featurelist: $(wrapper).find(".features").val(),
                featuresvalues: $(wrapper).find(".values").val(),
                Graphic: $(wrapper).find(".productgraphics").val(),
                Featured: $(wrapper).find(".featured").is(':checked'),
				ProductLink: $(wrapper).find(".productlink").is(':checked')
            });			

            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", product);
            $(wrapper).find(".modal").modal('hide');
        };

        $(wrapper).find(".sectionsubtitle").trumbowyg({
            semantic: false,
			btns: [
				['strong', 'em', 'del', 'underline'],
				['unorderedList', 'orderedList'],
				['viewHTML']
			],
        });
		
        setTimeout(function () {
            $(wrapper).find(".wsinput").val(wsinput);
        }, 200);
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".boxshadow").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var centered = $(blockContent).find(".centered").is(':checked');
		var SbSwitcher = $(blockContent).find(".display_switcher_option").is(':checked');
		var DisableSwitcher = $(blockContent).find(".disable_switcher").is(':checked');
		var DisableBrekdown = $(blockContent).find(".disable_brekdown").is(':checked');
		var featurescollapsed = $(blockContent).find(".collapsed_option").is(':checked');
		var DisplayInGrid = $(blockContent).find(".displayingrid").is(':checked');
		var orderLinkinLast = $(blockContent).find(".dobp").is(':checked');
		var bsco = $(blockContent).find(".bscorder").is(':checked');
		var subtitle = $(blockContent).find('.sectionsubtitle').trumbowyg('html');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
            "table": items,
            "ptstyle": $(blockContent).find(".pt_styles").val(),
            "switcherCycles": $(blockContent).find(".scycles").val(),
            "bgcolor": $(blockContent).find(".blockbgcolor").val(),
            "btntext": $(blockContent).find(".tablebtntext").val(),
			"caption": $(blockContent).find(".sectioncaption").val(),
            "sectitle": $(blockContent).find(".sectiontitle").val(),
            "borders": $(blockContent).find(".blockborders").val(),
            "toppadding": $(blockContent).find(".blocktheight").val(),
            "bottompadding": $(blockContent).find(".blockbheight").val(),
            "tablebg": $(blockContent).find(".tablebgcolor").val(),
            "ststyle": $(blockContent).find(".stickerstyle").val(),
            "descp": $(blockContent).find(".blockdesc").val(),
            "itemcounts": $(blockContent).find(".laitems").val(),
            "featured": $(blockContent).find(".wsinput").val(),
			"slidertype": $(blockContent).find(".slidertype").val(),
			"subtitle": subtitle,
            "noshadow": status,
			"sechidden": sechidden,
			"SbSwitcher": SbSwitcher,
			"DisableSwitcher": DisableSwitcher,
			"DisableBrekdown": DisableBrekdown,
			"featurescollapsed": featurescollapsed,
			"orderLinkinLast": orderLinkinLast,
			"DisplayInGrid": DisplayInGrid,
			"bsco": bsco,
			"centered" : centered
			
        };
    }
}