class slider {
    static get toolbox() {
        return {
            title: 'Slider (Deprecate)',
            icon: '<i class="fas fa-sliders-h"></i>'
        };
    }
    constructor( {data, config, api}) {
		this.api = api;
        this.data = data;
		
        if (!this.data.id) {
            this.data.id = `sec-${Math.random().toString(36).substr(2, 9)}`;
        }
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            code: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            },
            table: {
                b: true,
                bold: true,
                i: true,
                a: true,
                s: true,
				u: true,
                img: true,
                small: true,
				strike: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render() {
        const wrapper = document.createElement('div');
        wrapper.classList.add('slider-block');
        $(wrapper).append(`<div class="register-form">
    <div class="form">
        <div class="section_header">
			<label>Slider<span class="sec-docs text-danger" href="#" data-container="body" data-toggle="popover" data-trigger="hover" data-html="true" data-content="This section will be removed in the upcoming release. You will need to migrate the contents into the <strong>Banner</strong> section.">Deprecated</span></label>
            <input type="text" value="" readonly="readonly"/>
        </div>
		<div class="section_header_switch" title="Show/Hide Section" data-toggle="tooltip" data-container="body" data-html="true" data-placement="bottom">
			<label class="switch">
				<input type="checkbox" class="success sechidden" />
				<span class="slider round"></span>
			</label>
		</div>
        <div class="form-content llbld">
			<div class="sec_groups">
				<div class="form-group">
					<label>Slider Type</label>
					<select type="select" class="form-control slstyle">
						<option value="">Type 1</option>
						<option value="1">Type 2</option>
					</select>
				</div>
			</div>
			<div class="bg_st_1">
				<div class="heading">
					<h5>Section Background</h5>
				</div>
				<div class="sec_groups">
					<div class="form-group">
						<label>Background Image</label>
						<div class="input-group">
							<input type="text" id="${this.data.id}-bbgimage" class="form-control bbgimage" value="" />
							<span onclick="PageGraphics('${this.data.id}-bbgimage')" class="input-group-addon" data-toggle="tooltip" data-container="body" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>
						</div>
					</div>
				</div>
			</div>
			<div class="heading">
				<h5>Section Action</h5>
			</div>
			<div class="sec_groups">
				<div class="form-group">
					<label>Button Text</label>
					<input type="text" class="form-control tablebtntext" placeholder="i.e., View Plans & Features" value="" />
					<span class="help-block">You can set a single button text for all items if you prefer not to create separate button texts for each item.</span>
				</div>
			</div>
			<div style="margin: 10px 0;">
				<div class="vjsGrid nottbf"></div>
			</div>
			<div class="form-group">
				<div class="flex-checkbox">
					<span class="control-label">When enabled, the slider will automatically start playing.</span>
					<label class="switch">
						<input type="checkbox" class="form-control success sautoplay" />
						<span class="slider round"></span>
					</label>
				</div>
			</div>
			<div class="form-group">
				<div class="flex-checkbox">
					<span class="control-label">Overlay section below on this screen.</span>
					<label class="switch">
						<input type="checkbox" class="form-control success secoverlay" />
						<span class="slider round"></span>
					</label>
				</div>
			</div>			
        </div>
    </div>
</div>
<div id="${this.data.id}" class="modal" role="dialog">
    <div class="modal-dialog modal-scroll">
        <!-- Modal content-->
        <div class="modal-content slider-modal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">×</span>
					<span class="sr-only">Close</span>
				</button>
                <h4 class="modal-title">Add/Edit Item</h4>
            </div>
            <div class="modal-body" style="padding:30px;">
                <div class="form-group">
                    <label>Heading</label>
					<input type="text" class="form-control bsbsubtitle" placeholder="Heading">
                </div>
                <div class="form-group">
                    <label>Sub Heading</label>
					<input type="text" class="form-control bsbtitle" placeholder="Sub Heading">
                </div>
                <div class="form-group">
					<div class="flex-checkbox">
					  <span class="control-label">Display starting price of selected product group</span>
                      <label class="switch">
					    <input type="checkbox" class="success displaypricing">
						<span class="slider round"></span>
					  </label>
					</div>
                </div>
				<div class="groupPanel">
					<div class="form-group">
						<label></label>
						<select type="select" class="form-control groupprice">${groupSelect}</select>
					</div>
				</div>
                <div class="form-group">
                    <label>Description</label>
					<textarea type="text" rows="3" class="form-control bsbdesc"></textarea>
                </div>
				<div class="s1groups">
					<div class="form-group">
						<label>Section Image</label>
						<input type="imagelib" class="form-control cpimage" placeholder="">
					</div>
                   <hr />
                   <div class="form-group">
                       <label>Background Type</label>
					     <select type="select" class="form-control sliderbg">
					        <option value="">Image</option>
						    <option value="bg-primary">Primary</option>
							<option value="primary">Primary (Gradient)</option>
							<option value="dark">Dark</option>
							<option value="light">Light</option>
							<option value="nobg">None</option>
					     </select>
                   </div>
                   <div class="form-panel simginput">
					<div class="form-group">
						<label>Background Image</label>
						<input type="imagelib" class="form-control bsbimage"  placeholder="">
						<span class="help-block">If its empty it will show default slider image.</span>
					</div>
					 <hr />
					 <p class="help-block small">If your background image is in light color, you can disable opacity and change the text color from here.</p>
					 <div class="row">
					   <div class="col-sm-6">
                         <div class="form-group">
                          <label>Opacity</label>
					       <select type="select" class="form-control sopacity">
					         <option value="">Yes</option>
						      <option value="1">No</option>
					       </select>
                         </div>
					   </div>
					   <div class="col-sm-6">
                         <div class="form-group">
                          <label>Text Color</label>
					       <select type="select" class="form-control textcolor">
					         <option value="">Light</option>
						      <option value="text-dark">Dark</option>
					       </select>
                         </div>
					   </div>
					 </div>
				   </div>
				</div>
				<div class="collapsed_panel">
					<div class="heading collapsed" data-toggle="collapse">
						<h5>Action Button</h5>
						<button type="button" class="heading_btn">
							<span class="heading_btn_text">Expand</span>
							<span class="heading_btn_text">Hide</span>
							<span class="fal fa-angle-down"></span>
						</button>
					</div>
					<div class="well collapse">
						<div class="form-group">
							<label>Button Text</label>
							<input type="text" class="form-control itembtntext" />
						</div>
						<div class="form-group">
							<label>Button Link Type</label>
							<select type="select" class="form-control linktype">
								<option value="">Custom URL</option>
								<option value="1">Page Manager</option>
								<option value="2">Product Group</option>
								<option value="3">Product</option>
							</select>
						</div>
						<div class="curl">
							<div class="form-group">
								<label>Link To</label>
								<input type="text" class="form-control bsblink" placeholder="add custom URL..">
							</div>
						</div>
						<div class="purl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control pagelink">${cmsPages}</select>
							</div>
						</div>
						<div class="gurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control grouplink">${groupSelect}</select>
							</div>
						</div>
						<div class="pdurl">
							<div class="form-group">
								<label>Link To</label>
								<select type="select" class="form-control productlink">${productsSelect}</select>
							</div>
						</div>
					</div>
				</div>
            </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary savedataid">Submit</button> 
        </div>
    </div>
  </div>
</div>`);
		
		
        const image = this.data && this.data.image ? this.data.image : "";
        const slstyle = this.data && this.data.sliderStyle ? this.data.sliderStyle : "";
        $(wrapper).find(".slstyle").val(slstyle);
        const tablebtntext = this.data && this.data.btntext ? this.data.btntext : "";
        $(wrapper).find(".tablebtntext").val(tablebtntext);
        if (this.data.autoplay === true) {
            $(wrapper).find('.sautoplay').attr('checked', 'checked');
        }
		if (this.data.SecOverlay === true) {
            $(wrapper).find('.secoverlay').attr('checked', 'checked');
        }		
        if (this.data.sechidden === true) {
            $(wrapper).find('.sechidden').attr('checked', 'checked');
        }
		
        if ($(wrapper).find('.slstyle').val() === '') {
            $(wrapper).find('.bg_st_1').removeClass('hidden');
			$(wrapper).find('.s1groups').addClass('hidden');
        } else {
            $(wrapper).find('.bg_st_1').addClass('hidden');
			$(wrapper).find('.s1groups').removeClass('hidden');
        }
        $(wrapper).find('.slstyle').on('change', function () {
            if ($(wrapper).find('.slstyle').val() === '') {
                $(wrapper).find('.bg_st_1').removeClass('hidden');
				$(wrapper).find('.s1groups').addClass('hidden');
            } else {
                $(wrapper).find('.bg_st_1').addClass('hidden');
				$(wrapper).find('.s1groups').removeClass('hidden');
            }
        });
		
        $(wrapper).find(".vjsGrid").jsGrid({
            width: "100%",
            height: "auto",
            inserting: true,
            editing: true,
            sorting: true,
            paging: false,
			confirmDeleting: false,
			onItemDeleting: function (args) {
				if (!args.item.deleteConfirmed) {
					args.cancel = true;
					swal({
						title: "<i class='far fa-info-circle fa-fw text-danger'></i> Remove Item",
						text: "Are you sure you want to remove the slider <b> \"" + args.item.SubTitle + "\" </b> from this section?",
						showCancelButton: true,
						html: true,
						confirmButtonColor: "#d9534f",
						confirmButtonText: "Yes, delete it!",
						cancelButtonText: "Cancel"
					}, function(isConfirm) {
						if (isConfirm) {
							args.item.deleteConfirmed = true;
							$(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
						}
					});
				}
			},
            rowClick: function (args) {
                if (args.event.target.title === 'Delete') {
                    $(wrapper).find(".modal").modal('hide');
                    $(wrapper).find(".vjsGrid").jsGrid("deleteItem", args.item);
                } else {
                    showDetailsDialog("Edit", args.item, args.itemIndex);
                }
            },
			rowRenderer: function(item) {
				var $cButtons = $("<td>").addClass("jsgrid-cell jsgrid-control-field jsgrid-align-center").attr("width", "50px").append($("<button>").addClass("jsgrid-button jsgrid-delete-button").attr("type", "button").attr("title", "Delete"));
				
				$cButtons.on("click", function() {
					showDetailsDialog("Delete", {});
				});
				
				var slider = item;
				var $info = slider.SubTitle;
				
				var $config = $("<div>").addClass("hidden d-none")
                .append($("<div>").html("<strong>SubTitle:</strong><br />" + slider.Title))
				.append($("<div>").html("<strong>Slider Image Link:</strong><br />" + slider['Slider Image']))
				.append($("<div>").html("<strong>Description:</strong><br />" + slider.Description))
				.append($("<div>").html("<strong>Link Type:</strong><br />" + slider.LinkType))
				.append($("<div>").html("<strong>Link:</strong><br />" + slider.Link))
				.append($("<div>").html("<strong>Page Link:</strong><br />" + slider.PageLink))
				.append($("<div>").html("<strong>Slider Background:</strong><br />" + slider.SliderBg))
				.append($("<div>").html("<strong>Caption Image:</strong><br />" + slider.cPimage))
				.append($("<div>").html("<strong>Button Text:</strong><br />" + slider.btnText))
				.append($("<div>").html("<strong>Text Color:</strong><br />" + slider.TextColor))
				.append($("<div>").html("<strong>Image Background Opacity:</strong><br />" + slider.sOpacity));
				
				return $("<tr>")
					.append($("<td>").addClass("jsgrid-cell grid-info-block jsgrid-align-left").attr("width", "400px").append($info).append($config))
					.append($cButtons);
			},			
            data: this.data && this.data.table ? this.data.table : [],
            fields: [
                {title: "Sliders", width: 400},
                {type: "control", width: 50,
                    _createGridButton: function (cls, tooltip, clickHandler) {
                        var grid = this._grid;

                        return $("<button>").addClass(this.buttonClass)
                                .addClass(cls)
                                .attr({
                                    type: "button",
                                    title: tooltip
                                })
                                .on("click", function (e) {
                                    //clickHandler(grid, e);
                                    showDetailsDialog("Add", {});
                                });
                    },

                    editValue: function () {
                        return "";
                    }
					
                } //changed input to buttons
            ],
            rowClass: function (item, itemIndex) {
                return "client-" + itemIndex;
            },
            controller: {
                loadData: function () {
                    return db.clients.slice(0, 15);
                }
            },
            onRefreshed: function () {
                var $gridData = $(wrapper).find(".vjsGrid .jsgrid-grid-body tbody");
                $gridData.sortable({
                    update: function (e, ui) {
                        // array of indexes
                        var clientIndexRegExp = /\s*client-(\d+)\s*/;
                        var indexes = $.map($gridData.sortable("toArray", {attribute: "class"}), function (classes) {
                            return clientIndexRegExp.exec(classes)[1];
                        });
                        // arrays of items
                        var items = $.map($gridData.find("tr"), function (row) {
                            return $(row).data("JSGridItem");
                        });
                    }
                });
            }
        });
		
        var formSubmitHandler = $.noop;
		var sectionId = this.data?.id || "";

        var showDetailsDialog = function (dialogType, slider, itemIndex) {
			var isNew = dialogType === "Add";
			var uniqueIDPrefix = isNew ? "slider_new_" : "slider_" + itemIndex;
			
			if (isNew) {
				slider = {
					Title: '',
					SubTitle: '',
					Description: '',
					displayPricing: 0,
					Group: '',
					'Slider Image': '',
					LinkType: '',
					cPimage: '',
					SliderBg: '',
					TextColor: '',
					sOpacity: '',
					btnText: '',
					Link: ''
				};
			}
			
			$(wrapper).find('input[type="imagelib"]').each(function (index, element) {
				var uniqueId = uniqueIDPrefix + "_item_" + index;
				var $element = $(element);

				$element.attr({
					"id": uniqueId,
					"name": uniqueId
				});
				
				if (!$element.closest('.input-group').length) {
					var $inputGroup = $element.wrap('<div class="input-group"></div>').parent();
					$inputGroup.find('span.input-group-addon').remove();

					var $span = $('<span onclick="PageGraphics(\'' + uniqueId + '\')" class="input-group-addon" data-toggle="tooltip" data-placement="top" data-html="true" title="Select Image"><i class="fas fa-images"></i></span>');
					$inputGroup.append($span);
				} else {
					var $span = $element.siblings('span.input-group-addon');
					$span.attr("onclick", "PageGraphics('" + uniqueId + "')");
				}
			});
			
			$(wrapper).find('.modal-body .collapsed_panel').each(function (index, element) {
				var uniqueId = sectionId + "_heading_" + index;
				var $panel = $(element);
				var $heading = $panel.find('.heading');
				var $well = $panel.find('.well');
				
				if ($heading.length) {
					$heading.attr("aria-controls", uniqueId);
					$heading.attr("href", "#" + uniqueId);
				}
				if ($well.length && $well.hasClass('collapse')) {
					$well.attr("id", uniqueId);
				}
				
				$well.removeClass('in');
				$heading.addClass('collapsed');				
				
			});

			
            $(wrapper).find(".bsbtitle").val(slider.Title);
            $(wrapper).find(".bsbsubtitle").val(slider.SubTitle);
            $(wrapper).find(".bsbimage").val(slider['Slider Image']);
			$(wrapper).find(".itembtntext").val(slider.btnText);
            $(wrapper).find(".linktype").val(slider.LinkType);
			$(wrapper).find(".cpimage").val(slider.cPimage);
			$(wrapper).find(".sliderbg").val(slider.SliderBg);
			$(wrapper).find(".textcolor").val(slider.TextColor);
			$(wrapper).find(".sopacity").val(slider.sOpacity);
			$(wrapper).find(".displaypricing").prop('checked', slider.displayPricing ? true : false);
			$(wrapper).find(".groupprice").val(slider.Group);
			$(wrapper).find(".groupprice").select2().trigger("change");
			
			$(wrapper).find('.modal').off('shown.bs.modal').on('shown.bs.modal', function () {
				var modalId = $(this).attr('id');
				var $sliderDescription = $('#' + modalId).find('.bsbdesc');

				if (!$sliderDescription.next('.trumbowyg-box ').length) {
					$sliderDescription.trumbowyg({
						semantic: false,
						btns: [
							['strong', 'em', 'del', 'underline'],
							['unorderedList', 'orderedList'],
							['viewHTML']
						],
					});
				}
				$sliderDescription.trumbowyg('html', slider.Description);
			});
			
			$(wrapper).find(".displaypricing").each(function() {
				var checkboxId = uniqueIDPrefix + "_dp";
				var panelClass = ".groupPanel";

				$(this).attr("id", checkboxId);

				$(this).on("change", function() {
					let isChecked = this.checked;
					$(panelClass).toggleClass("hidden", !isChecked, {
						duration: 300
					});
				}).trigger("change");
			});
			
			const select2Elements = [
				{ selector: ".pagelink", placeholder: 'Select a page' },
				{ selector: ".productlink", placeholder: 'Select a product' },
				{ selector: ".grouplink", placeholder: 'Select a products group' },
				{ selector: ".groupprice", placeholder: 'Select a products group' }
			];

			select2Elements.forEach(function(item) {
				$(wrapper).find(item.selector).select2({
					placeholder: item.placeholder,
					allowClear: true
				});
			});

			
			function updateLinkFields() {
				var linkType = $(wrapper).find('.linktype').val();

				switch (linkType) {
					case '':
						$(wrapper).find(".bsblink").val(slider.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
					case '1':
						$(wrapper).find(".pagelink").val(slider.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".grouplink").val('');
						break;
					case '2':
						$(wrapper).find(".grouplink").val(slider.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".productlink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					case '3':
						$(wrapper).find(".productlink").val(slider.Link).trigger('change');
						$(wrapper).find(".bsblink").val('');
						$(wrapper).find(".grouplink").val('');
						$(wrapper).find(".pagelink").val('');
						break;
					default:
						$(wrapper).find(".bsblink").val(slider.Link);
						$(wrapper).find(".pagelink").val(null).trigger('change');
						$(wrapper).find(".productlink").val(null).trigger('change');
						$(wrapper).find(".grouplink").val(null).trigger('change');
						break;
				}
			}

			
			updateLinkFields();

			$(wrapper).find('.linktype').on('change', function () {
				//slider.LinkType = $(this).val();
				updateLinkFields();
			});
			
			//
			if ($(wrapper).find('.sliderbg').val() === '') {
				$(wrapper).find('.simginput').removeClass('hidden');
			} else {
				$(wrapper).find('.simginput').addClass('hidden');
			}
			$(wrapper).find('.sliderbg').on('change', function () {
				if ($(wrapper).find('.sliderbg').val() === '') {
					$(wrapper).find('.simginput').removeClass('hidden');
				} else {
					$(wrapper).find('.simginput').addClass('hidden');
				}
			});
			//
			
			//
			function LinkInputsVisibility() {
				const linktypeVal = $(wrapper).find('.linktype').val();
				const LinkInputs = {
					curl: $(wrapper).find('.curl'),
					purl: $(wrapper).find('.purl'),
					pdurl: $(wrapper).find('.pdurl'),
					gurl: $(wrapper).find('.gurl')
				};
				Object.values(LinkInputs).forEach(el => el.addClass('hidden'));

				switch (linktypeVal) {
					case '':
						LinkInputs.curl.removeClass('hidden');
						break;
					case '1':
						LinkInputs.purl.removeClass('hidden');
						break;
					case '2':
						LinkInputs.gurl.removeClass('hidden');
						break;
					case '3':
						LinkInputs.pdurl.removeClass('hidden');
						break;
				}
			}
			LinkInputsVisibility();
			$(wrapper).find('.linktype').on('change', LinkInputsVisibility);
			//
		
            formSubmitHandler = function () {
                saveslider(slider, dialogType === "Add");
            };
            $(wrapper).find(".modal").modal('show');
        };
        $(wrapper).find(".savedataid").click(function (e) {
			if ($(".ce-block--focused .bsbsubtitle").val() === '') {
				alert('Heading is required for slider');
				e.preventDefault();
			} else {
				formSubmitHandler();
			}
        });
        var saveslider = function (slider, isNew) {
			var linkType = $(wrapper).find('.linktype').val();
			var linkValue;
			switch (linkType) {
				case '':
					linkValue = $(wrapper).find(".bsblink").val();
					break;
				case '1':
					linkValue = $(wrapper).find(".pagelink").val();
					break;
				case '2':
					linkValue = $(wrapper).find(".grouplink").val();
					break;
				case '3':
					linkValue = $(wrapper).find(".productlink").val();
					break;
				default:
					linkValue = $(wrapper).find(".bsblink").val();
					break;
			}
            $.extend(slider, {
                Title: $(wrapper).find(".bsbtitle").val(),
                SubTitle: $(wrapper).find(".bsbsubtitle").val(),
                Description: $(wrapper).find(".bsbdesc").val(),
                'Slider Image': $(wrapper).find(".bsbimage").val(),
                btnText: $(wrapper).find(".itembtntext").val(),
                LinkType: $(wrapper).find(".linktype").val(),
				cPimage: $(wrapper).find(".cpimage").val(),
				SliderBg: $(wrapper).find(".sliderbg").val(),
				TextColor: $(wrapper).find(".textcolor").val(),
				Group: parseInt($(wrapper).find(".groupprice").val()),
				sOpacity: $(wrapper).find(".sopacity").val(),
				Link: linkValue,
				displayPricing: $(wrapper).find(".displaypricing").is(':checked')
				
            });
            $(wrapper).find(".vjsGrid").jsGrid(isNew ? "insertItem" : "updateItem", slider);
            $(wrapper).find(".modal").modal('hide');
        };
        setTimeout(function () {
            $(wrapper).find(".bbgimage").val(image);
        }, 200);
        return wrapper;
    }

    save(blockContent) {
        var grid = $(blockContent).find(".vjsGrid").data("JSGrid");
        var status = $(blockContent).find(".sautoplay").is(':checked');
		var sechidden = $(blockContent).find(".sechidden").is(':checked');
		var SecOverlay = $(blockContent).find(".secoverlay").is(':checked');
        var $gridData = $(blockContent).find(".vjsGrid .jsgrid-grid-body tbody");
        var items = $.map($gridData.find("tr"), function (row) {
            return $(row).data("JSGridItem");
        });
        return {
			"id": this.data.id,
            "table": items,
            "image": $(blockContent).find(".bbgimage").val(),
            "sliderStyle": $(blockContent).find(".slstyle").val(),
            "btntext": $(blockContent).find(".tablebtntext").val(),
            "autoplay": status,
			"SecOverlay": SecOverlay,
			"sechidden": sechidden 
        };
    }
}