{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $inactive}

    {include file="$template/includes/alert.tpl" type="danger" msg=$LANG.affiliatesdisabled textcenter=true}

{else}
	<div class="tiles swiper" id="tiles">
		<div class="swiper-wrapper my-3 my-md-0">
			<div class="swiper-slide">
				<div class="tile">
					<div class="no-link">
						<div class="icon"><i class="fas fa-users"></i></div>
						<div class="stat text-primary">{$visitors}</div>
						<div class="title">{$LANG.affiliatesclicks}</div>
					</div>
				</div>
			</div>

			<div class="swiper-slide">
				<div class="tile">
					<div class="no-link">
						<div class="icon"><i class="fas fa-shopping-cart"></i></div>
						<div class="stat text-primary">{$signups}</div>
						<div class="title">{$LANG.affiliatessignups}</div>
					</div>
				</div>
			</div>
			
			<div class="swiper-slide">
				<div class="tile">
					<div class="no-link">
						<div class="icon"><i class="far fa-chart-bar"></i></div>
						<div class="stat text-primary">{if $conversionrate|string_format:"%d" < 100}{$conversionrate}{else}{$conversionrate|string_format:"%.1f"}{/if}%</div>
						<div class="title">{$LANG.affiliatesconversionrate}</div>
					</div>
				</div>
			</div>
		</div>
		<div class="swiper-pagination"></div>
	</div>
	
	{*
	<div class="section">
		{if $withdrawrequestsent}
			<div class="alert alert-success">
				<p>{$LANG.affiliateswithdrawalrequestsuccessful}</p>
			</div>
		{else}
			{if !$withdrawrequestsent}
				<div class="text-center">
					<form method="POST" action="{$smarty.server.PHP_SELF}">
						<input type="hidden" name="action" value="withdrawrequest" />
						<button type="submit" class="btn btn-lg btn-danger{if !$withdrawlevel} disabled" disabled="disabled{/if}">
							<i class="fas fa-university"></i> {lang key='affiliatesrequestwithdrawal'}
						</button>
					</form>
				</div>
				{if !$withdrawlevel}
					<p class="text-muted text-center">{lang key="affiliateWithdrawalSummary" amountForWithdrawal=$affiliatePayoutMinimum}</p>
				{/if}
			{/if}
		{/if}
	</div>
	*}
	
	
	{include file="$template/includes/flashmessage.tpl"}
	
	<div class="section">
        <div class="panel panel-default panel-affiliate-referral-link">
             <div class="panel-body">
                 <div class="input-group input-group-lg">
                      <div class="input-group-prepend">
						<div class="input-group-text">
							{$LANG.affiliatesreferallink}
						</div>
					  </div>
                      <input class="form-control" type="text" readonly value="{$referrallink}"> 
                  </div>
              </div>
          </div>
	</div>
	
	<div class="section">
		{if $referrals}
			<div class="d-flex space-between align-items-center">
				<h4>{$LANG.affiliatesreferals}</h4>
				{if $referrals}
					<div class="search-group">
						<input type="text" class="form-control" id="table-search" placeholder="{$LANG.tableentersearchterm}"> 
					</div>
				{/if}
			</div>
			
			{include file="$template/includes/tablelist.tpl" tableName="AffiliatesList" filterColumn="4"}
			
			<script>
				jQuery(document).ready( function () {
					var table = jQuery('#tableAffiliatesList').show().DataTable();
					{if $orderby == 'regdate'}
						table.order(0, '{$sort}');
					{elseif $orderby == 'product'}
						table.order(1, '{$sort}');
					{elseif $orderby == 'amount'}
						table.order(2, '{$sort}');
					{elseif $orderby == 'status'}
						table.order(4, '{$sort}');
					{/if}
					table.draw();
					jQuery('#tableLoading').hide();
				});
			</script>
			

			<div class="table-container clearfix">
			
				<div class="table-header">
					<label>{lang key='view'}</label>
					<div class="dropdown view-filter-btns">
						<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<span>{lang key='domainRenewal.showAll'}</span>
						</button>
						 <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenuButton">
							<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
							{foreach key=status item=count from=$referrals|@array_column:'status'|@array_count_values}
								<li><a href="#" class="dropdown-item"><span data-value="{$status|strip_tags}">{$status|strip_tags}</span></a></li>
							{/foreach}
						</ul>
					</div>		
				</div>
				
				<table id="tableAffiliatesList" class="datatable table table-hover w-hidden">
					<thead>
						<tr>
							<th data-class="expand">{$LANG.orderproduct}</th>
							<th data-hide="phone">{$LANG.affiliatessignupdate}</th>
							<th data-hide="phone,tablet">{$LANG.affiliatesamount}</th>
							<th data-hide="phone,tablet">{$LANG.affiliatescommission}</th>
							<th>{$LANG.affiliatesstatus}</th>
						</tr>
					</thead>
					<tbody>
					{foreach from=$referrals item=referral}
						<tr>
							<td>{$referral.service}</td>
							<td><span class="w-hidden">{$referral.datets}</span>{$referral.date}</td>
							<td data-order="{$referral.amountnum}">{$referral.amountdesc}</td>
							<td data-order="{$referral.commissionnum}">{$referral.commission}</td>
							<td><span class='label status status-{$referral.rawstatus|strtolower}'>{$referral.status}</span></td>
						</tr>
					{/foreach}
					</tbody>
				</table>
				<div class="text-center" id="tableLoading">
					<p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
				</div>
			</div>
		{/if}
		
	</div>	 			
	
	
	
    {if $affiliatelinkscode}
		<div class="section">
			<h4>{$LANG.affiliateslinktous}</h4>
			<div class="margin-bottom">
				{$affiliatelinkscode}
			</div>
		</div>
    {/if}
	
	<script>
		jQuery(document).ready(function () {
			var swiper = new Swiper('#tiles', {
			  slidesPerView: 1,
			  spaceBetween: 20,
			  pagination: {
				el: '.swiper-pagination',
				clickable: true,
			  },

			  breakpoints: {
				0: {
					slidesPerView: 1
				},
				768: {
				  slidesPerView: 3
				},
			  }
			  
			});
		});
	</script>

{/if}
