{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $clientsstats.incredit}
	<div class="alert alert-info">
		<button class="close" data-dismiss="alert"><i class="fal fa-times"></i></button>
		<p class="m-0">{$LANG.availcreditbaldesc|sprintf2:$clientsstats.creditbalance}</p>
	</div>
{/if}

{include file="$template/includes/flashmessage.tpl"}

<div class="tiles clearfix swiper" id="tiles">
    <div class="swiper-wrapper my-3 my-md-0">
		<div class="swiper-slide">
			<div class="tile" onclick="window.location='clientarea.php?action=services'">
				<a class="stats" href="clientarea.php?action=services">
					<div class="icon"><i class="fad fa-server"></i></div>
					<div class="stat">{$clientsstats.productsnumactive}</div>
					<div class="title">{lang key='navservices'}</div>
				</a>
			</div>
        </div>
        {if $registerdomainenabled || $transferdomainenabled}
			<div class="swiper-slide">
				<div class="tile" onclick="window.location='clientarea.php?action=domains'">
					<a class="stats" href="clientarea.php?action=domains">
						<div class="icon"><i class="fad fa-globe"></i></div>
						<div class="stat">{$clientsstats.numactivedomains}</div>
						<div class="title">{lang key='navdomains'}</div>
					</a>
				</div>
			</div>
        {elseif $condlinks.affiliates && $clientsstats.isAffiliate}
			<div class="swiper-slide">
				<div class="tile" onclick="window.location='affiliates.php'">
					<a class="stats" href="affiliates.php">
						<div class="icon"><i class="fad fa-shopping-cart"></i></div>
						<div class="stat">{$clientsstats.numaffiliatesignups}</div>
						<div class="title">{lang key='affiliatessignups'}</div>
					</a>
				</div>
			</div>
        {else}
			<div class="swiper-slide">
				<div class="tile" onclick="window.location='clientarea.php?action=quotes'">
					<a class="stats" href="clientarea.php?action=quotes">
						<div class="icon"><i class="fad fa-file-alt"></i></div>
						<div class="stat">{$clientsstats.numquotes}</div>
						<div class="title">{lang key='quotes'}</div>
					</a>
				</div>
			</div>
        {/if}
		
		<div class="swiper-slide">
			<div class="tile" onclick="window.location='supporttickets.php'">
				<a class="stats" href="supporttickets.php">
					<div class="icon"><i class="fad fa-comments"></i></div>
					<div class="stat">{$clientsstats.numactivetickets}</div>
					<div class="title">{lang key='navtickets'}</div>
				</a>
			</div>
		</div>
		<div class="swiper-slide">
			<div class="tile" onclick="window.location='clientarea.php?action=invoices'">
				<a class="stats" href="clientarea.php?action=invoices">
					<div class="icon"><i class="fad fa-credit-card"></i></div>
					{if $clientsstats.numdueinvoices > 0}
						<div class="stat text-danger">{$clientsstats.numdueinvoices}</div>
						<div class="title">{lang key='clientHomePanels.unpaidInvoices'}</div>
					{else}
						<div class="stat"><i class="fas fa-thumbs-up"></i></div>
						<div class="title">{lang key='navinvoices'}</div>					
					{/if}
				</a>
			</div>
		</div>
    </div>
	<div class="swiper-pagination"></div>
</div>

<form role="form" method="post" action="clientarea.php?action=kbsearch">
    <div class="row">
        <div class="col-md-12 home-kb-search">
            <input type="text" name="search" class="form-control input-lg" placeholder="{$LANG.clientHomeSearchKb}" />
            <i class="fas fa-search"></i>
        </div>
    </div>
</form>

{foreach $addons_html as $addon_html}
    <div>
        {$addon_html}
    </div>
{/foreach}

<div class="client-home-panels">
    <div class="row">
        <div class="col-12">

            {function name=outputHomePanels}
                <div menuItemName="{$item->getName()}" class="panel {if $item->getName() == "Overdue Invoices" or $item->getName() == "Domains Expiring Soon"}panel-warning{else}panel-default{/if} {if $item->getName() == "Register a New Domain"}panel-domain-register{/if}{if $item->getName() == "Active Products/Services"}panel-services{/if}" {if $item->getAttribute('id')} id="{$item->getAttribute('id')}"{/if}>
					{if $item->getName() == "Register a New Domain"}
						<span class="fal fa-globe"></span>
					{/if}
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            {if $item->getExtra('btn-link') && $item->getExtra('btn-text')}
                                <div class="float-right">
                                    <a href="{$item->getExtra('btn-link')}" data-toggle="tooltip" data-title="{$item->getExtra('btn-text')}" data-container="body">
                                        {if $item->getExtra('btn-icon')}<i class="{$item->getExtra('btn-icon')}"></i>{/if}
                                        {*{$item->getExtra('btn-text')}*}
                                    </a>
                                </div>
                            {/if}
                            {if $item->getName() !== "Register a New Domain"}{if $item->hasIcon()}<i class="{$item->getIcon()}"></i>&nbsp;{/if}{/if}
                            {$item->getLabel()}
                            {if $item->hasBadge()}&nbsp;<span class="badge">{$item->getBadge()}</span>{/if}
                        </h3>
                    </div>
                    {if $item->hasBodyHtml()}
                        <div class="panel-body">
							{if $item->getName() == "Register a New Domain"}
								{$item->getBodyHtml()|replace:'name="domain"':'name="domain" placeholder="domain name"'|replace:'domain name':{$LANG.findyourdomain}}
								 <p>{$LANG.orderForm.transferExtend}*</p>
							{else}
								{$item->getBodyHtml()}
							{/if}
                        </div>
                    {/if}
                    {if $item->hasChildren()}
                        <div class="list-group{if $item->getChildrenAttribute('class')} {$item->getChildrenAttribute('class')}{/if}">
                            {foreach $item->getChildren() as $childItem}
                                {if $childItem->getUri()}
                                    <a menuItemName="{$childItem->getName()}" href="{$childItem->getUri()}" class="list-group-item list-group-item-action{if $childItem->getClass()} {$childItem->getClass()}{/if}{if $childItem->isCurrent()} active{/if}"{if $childItem->getAttribute('dataToggleTab')} data-toggle="tab"{/if}{if $childItem->getAttribute('target')} target="{$childItem->getAttribute('target')}"{/if} id="{$childItem->getId()}">
                                        {if $childItem->hasIcon()}<i class="{$childItem->getIcon()}"></i>&nbsp;{/if}
                                        {$childItem->getLabel()}
                                        {if $childItem->hasBadge()}&nbsp;<span class="badge">{$childItem->getBadge()}</span>{/if}
                                    </a>
                                {else}
                                    <div menuItemName="{$childItem->getName()}" class="list-group-item list-group-item-action{if $childItem->getClass()} {$childItem->getClass()}{/if}" id="{$childItem->getId()}">
                                        {if $childItem->hasIcon()}<i class="{$childItem->getIcon()}"></i>&nbsp;{/if}
                                        {$childItem->getLabel()}
                                        {if $childItem->hasBadge()}&nbsp;<span class="badge">{$childItem->getBadge()}</span>{/if}
                                    </div>
                                {/if}
                            {/foreach}
                        </div>
                    {/if}
                    
                    {if $item->hasFooterHtml()}
						<div class="panel-footer">
							{$item->getFooterHtml()}
						</div>
                    {/if}
                    
                </div>
            {/function}

            {foreach $panels as $item}
                {if $item->getExtra('colspan')}
                    {outputHomePanels}
                    {assign "panels" $panels->removeChild($item->getName())}
                {/if}
            {/foreach}

        </div>
        <div class="col-md-6 col-12">

            {foreach $panels as $item}
                {if $item@iteration is odd}
                    {outputHomePanels}
                {/if}
            {/foreach}

        </div>
        <div class="col-md-6 col-12">

            {foreach $panels as $item}
                {if $item@iteration is even}
                    {outputHomePanels}
                {/if}
            {/foreach}

        </div>
    </div>
</div>

<script>
	jQuery(document).ready(function () {
		var swiper = new Swiper('#tiles', {
		  slidesPerView: 1,
		  spaceBetween: 20,
		  pagination: {
			el: '.swiper-pagination',
			clickable: true,
		  },
		  breakpoints: {
			0: {
				slidesPerView: 1
			},
			768: {
			  slidesPerView: 4
			},
		  }
		  
		});
	});
</script>
