{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $invoices}
{include file="$template/includes/tablelist.tpl" tableName="InvoicesList" filterColumn="4" noSortColumns="5"}
<script>
    jQuery(document).ready( function () {
        var table = jQuery('#tableInvoicesList').show().DataTable();
        {if $orderby == 'default'}
            table.order([4, 'desc'], [2, 'asc']);
        {elseif $orderby == 'invoicenum'}
            table.order(0, '{$sort}');
        {elseif $orderby == 'date'}
            table.order(1, '{$sort}');
        {elseif $orderby == 'duedate'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'total'}
            table.order(3, '{$sort}');
        {elseif $orderby == 'status'}
            table.order(4, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').hide();
    });
</script>

<div class="table-container clearfix">
	<div class="table-header">
		<label>{lang key='view'}</label>
		<div class="dropdown view-filter-btns">
			<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				<span>{lang key='domainRenewal.showAll'}</span>
			</button>
			 <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenuButton">
				<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
				{foreach key=status item=count from=$invoices|@array_column:'status'|@array_count_values}
					<li><a href="#" class="dropdown-item"><span data-value="{$status|strip_tags|substr:1:-1}">{$status|strip_tags|substr:1:-1}</span></a></li>
                {/foreach}
			</ul>
		</div>		
	</div>
    <table id="tableInvoicesList" class="datatable table table-hover w-hidden">
        <thead>
            <tr>
                <th data-class="expand">{$LANG.invoicestitle}</th>
                <th data-hide="phone,tablet">{$LANG.invoicesdatecreated}</th>
                <th data-hide="phone">{$LANG.invoicesdatedue}</th>
                <th>{$LANG.invoicestotal}</th>
                <th>{$LANG.invoicesstatus}</th>
                <th class="col-small center"></th>
            </tr>
        </thead>
        <tbody>
            {foreach $invoices as $invoice}
                <tr onclick="clickableSafeRedirect(event, 'viewinvoice.php?id={$invoice.id}', false)">
                    <td><a href="viewinvoice.php?id={$invoice.id}" style="word-break: normal;">{$invoice.invoicenum}</a></td>
                    <td><span class="w-hidden">{$invoice.normalisedDateCreated}</span>{$invoice.datecreated}</td>
                    <td><span class="w-hidden">{$invoice.normalisedDateDue}</span>{$invoice.datedue}</td>
                    <td data-order="{$invoice.totalnum}">{$invoice.total}</td>
                    <td><span class="label status status-{$invoice.statusClass}">{$invoice.status|strip_tags|substr:1:-1}</span></td>
                    <td class="col-small center">
						<div class="action-buttons">
							<a href="viewinvoice.php?id={$invoice.id}" data-toggle="tooltip" title="{if $invoice.statusClass == 'unpaid'}{$LANG.invoicespaynow}{else}{$LANG.invoicesview}{/if}">
								<i class="fal fa-search-plus {if $invoice.statusClass == 'unpaid'}text-danger{/if}"></i> 
							</a>
						</div>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
         <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
</div>

{else}
<div class="alert-lg no-data">
	<div class="icon">
		<i class="fas fa-exclamation-triangle"></i>
	</div>
	<div class="text">
		{$LANG.norecordsfound}
	</div>
</div>
{/if}
