{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $modulecustombuttonresult}
    {if $modulecustombuttonresult == "success"}
        {include file="$template/includes/alert.tpl" type="success" msg=$LANG.moduleactionsuccess textcenter=true idname="alertModuleCustomButtonSuccess"}
    {else}
         {include file="$template/includes/alert.tpl" type="error" msg=$LANG.moduleactionfailed|cat:' ':$modulecustombuttonresult textcenter=true idname="alertModuleCustomButtonFailed"}
    {/if}
{/if}

{if $pendingcancellation}
    {include file="$template/includes/alert.tpl" type="error" msg=$LANG.cancellationrequestedexplanation textcenter=true idname="alertPendingCancellation"}
{/if}

{if $unpaidInvoice}
    <div class="alert alert-{if $unpaidInvoiceOverdue}danger{else}warning{/if}" id="alert{if $unpaidInvoiceOverdue}Overdue{else}Unpaid{/if}Invoice">
        <div class="pull-right">
            <a href="viewinvoice.php?id={$unpaidInvoice}" class="btn btn-xs btn-default">
                {lang key='payInvoice'}
            </a>
        </div>
        {$unpaidInvoiceMessage}
    </div>
{/if}

<div class="tab-content margin-bottom">
    <div class="tab-pane fade show active" id="tabOverview">

        {if $tplOverviewTabOutput}
			{$tplOverviewTabOutput}
        {else}

		
		
		
		
		
		
			<div class="section">
				<div class="product-details">
					<div class="row row-eq-height row-eq-height-sm">
						<div class="col-md-6">
							<div class="product-holder product-status-{$rawstatus|strtolower}">
								<div class="product-content">
									<div class="product-image">
										<span class="fa-stack">
											<i class="fas fa-circle fa-stack-2x"></i>
											<i class="fas fa-{if $type eq "hostingaccount" || $type == "reselleraccount"}hdd{elseif $type eq "server"}database{else}archive{/if} fa-stack-1x fa-inverse"></i>
										</span>
									</div>
									<h4><small>{$groupname}</small> - {$product}</h4>
									
									<div class="status-sticker-wrapper">
										<div class="status-sticker product-status-{$rawstatus|strtolower}">
											{$status}
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="product-info">
								<ul class="list-info list-v">
									<li>
										<span class="list-heading">{$LANG.clientareahostingregdate}</span>
										<span class="list-text">{$regdate}</span>
									</li>
									{if $firstpaymentamount neq $recurringamount}
										<li>
											<span class="list-heading">{$LANG.firstpaymentamount}</span>
											<span class="list-text">{$firstpaymentamount}</span>
											
										</li>
									{/if}
									{if $billingcycle != $LANG.orderpaymenttermonetime && $billingcycle != $LANG.orderfree}
										<li>
											<span class="list-heading">{$LANG.recurringamount}</span>
											<span class="list-text">{$recurringamount}</span>
											
										</li>
									{/if}
									<li>
										<span class="list-heading">{$LANG.orderbillingcycle}</span>
										<span class="list-text">{$billingcycle}</span>
									</li>
									{if $nextduedate == '-'}{else}
										<li>
											<span class="list-heading">{$LANG.clientareahostingnextduedate}</span>
											<span class="list-text">{$nextduedate}</span>
										</li>
									{/if}
									<li>
										<span class="list-heading">{$LANG.orderpaymentmethod}</span>
										<span class="list-text">{$paymentmethod}</span>
									</li>
								</ul>
							</div>
						</div>
					</div>

				</div>
			</div>
			
			{*
			{if $showRenewServiceButton === true || $showcancelbutton === true || $packagesupgrade === true}
				<div class="row">
					{if $packagesupgrade}
						<div class="col-md-4">
							<a href="upgrade.php?type=package&amp;id={$id}" class="btn btn-block btn-success">
								<i class="fas fa-level-up"></i>
								{lang key='upgrade'}
							</a>
						</div>
					{/if}
					{if $showRenewServiceButton === true}
						<div class="col-md-4">
							<a href="{routePath('service-renewals-service', $id)}" class="btn btn-block btn-primary">
								<i class="fas fa-sync"></i>
								{lang key='renewService.titleSingular'}
							</a>
						</div>
					{/if}
					{if $showcancelbutton}
						<div class="col-md-4">
							<a href="clientarea.php?action=cancel&amp;id={$id}" class="btn btn-block btn-danger {if $pendingcancellation}disabled{/if}">
								<i class="fas fa-ban"></i>
								{if $pendingcancellation}
									{lang key='cancellationrequested'}
								{else}
									{lang key='clientareacancelrequestbutton'}
								{/if}
							</a>
						</div>
					{/if}
				</div>
			{/if}
			*}
			
		{if $systemStatus == 'Active'}
		

			{foreach $hookOutput as $output}
				<div class="section">
					<div>
						{$output}
					</div>
					<div class=" clearfix"></div>
				</div>
			{/foreach}

            {if $domain || $moduleclientarea || $configurableoptions || $customfields || $lastupdate}
			<div class="section">
				<div class="card panel panel-tabs">
					<div class="card-header">
						<ul class="nav nav-pills card-header-pills flex-column flex-md-row">
							{if $domain}
								<li class="nav-item">
									<a href="#domain" data-toggle="tab" class="nav-link active"><i class="fas fa-globe fa-fw"></i> {if $type eq "server"}{lang key='sslserverinfo'}{elseif ($type eq "hostingaccount" || $type eq "reselleraccount") && $serverdata}{lang key='hostingInfo'}{else}{lang key='clientareahostingdomain'}{/if}</a>
								</li>
							{elseif $moduleclientarea}
								<li class="nav-item">
									<a href="#manage" data-toggle="tab" class="nav-link active"><i class="fas fa-globe fa-fw"></i> {lang key='manage'}</a>
								</li>
							{/if}
							{if $configurableoptions}
								<li class="nav-item">
									<a href="#configoptions" data-toggle="tab" class="nav-link{if !$domain && !$moduleclientarea} active{/if}"><i class="fas fa-cubes fa-fw"></i> {lang key='orderconfigpackage'}</a>
								</li>
							{/if}
							{if $metricStats}
								<li class="nav-item">
									<a href="#metrics" data-toggle="tab" class="nav-link{if !$domain && !$moduleclientarea && !$configurableoptions} active{/if}"><i class="fas fa-chart-line fa-fw"></i> {lang key='metrics.title'}</a>
								</li>
							{/if}
							{if $customfields}
								<li class="nav-item">
									<a href="#additionalinfo" data-toggle="tab" class="nav-link{if !$domain && !$moduleclientarea && !$metricStats && !$configurableoptions} active{/if}"><i class="fas fa-info fa-fw"></i> {lang key='additionalInfo'}</a>
								</li>
							{/if}
							{if $lastupdate}
								<li class="nav-item">
									<a href="#resourceusage" data-toggle="tab" class="nav-link{if !$domain && !$moduleclientarea && !$configurableoptions && !$customfields} active{/if}"><i class="fas fa-inbox fa-fw"></i> {lang key='resourceUsage'}</a>
								</li>
							{/if}
						</ul>
					</div>
					<div class="card-body">
						<div class="tab-content">
							{if $domain}
								<div class="tab-pane fade show active" role="tabpanel" id="domain">
									<ul class="list-info list-info-50">
									{if $type eq "server"}
										<li>
											<span class="list-heading">{lang key='serverhostname'}</span>
											<span class="list-text">{$domain}</span>
										</li>
										{if $dedicatedip}
											<li>
												<span class="list-heading">{lang key='primaryIP'}</span>
												<span class="list-text">{$dedicatedip}</span>
											</li>
										{/if}
										{if $assignedips}
											<li>
												<span class="list-heading">{lang key='assignedIPs'}</span>
												<span class="list-text">{$assignedips|nl2br}</span>
											</li>
										{/if}
										{if $ns1 || $ns2}
											<li>
												<span class="list-heading">{lang key='domainnameservers'}</span>
												<span class="list-text">{$ns1}<br />{$ns2}</span>
											</li>
										{/if}
									{else}
										{if $domain}
											<li>
												<span class="list-heading">{lang key='orderdomain'}</span>
												<span class="list-text">{$domain}</span>
											</li>
										{/if}
										{if $username}
											<li>
												<span class="list-heading">{lang key='serverusername'}</span>
												<span class="list-text">{$username}</span>
											</li>
										{/if}
										{if $serverdata}
											<li>
												<span class="list-heading">{lang key='servername'}</span>
												<span class="list-text">{$serverdata.hostname}</span>
											</li>
											<li>
												<span class="list-heading">{lang key='domainregisternsip'}</span>
												<span class="list-text">{$serverdata.ipaddress}</span>
											</li>
											{if $serverdata.nameserver1 || $serverdata.nameserver2 || $serverdata.nameserver3 || $serverdata.nameserver4 || $serverdata.nameserver5}
												<li>
													<span class="list-heading">{lang key='domainnameservers'}</span>
													<span class="list-heading">
															{if $serverdata.nameserver1}{$serverdata.nameserver1}{if $serverdata.nameserver1ip} ({$serverdata.nameserver1ip}){/if}<br />{/if}
															{if $serverdata.nameserver2}{$serverdata.nameserver2}{if $serverdata.nameserver2ip} ({$serverdata.nameserver2ip}){/if}<br />{/if}
															{if $serverdata.nameserver3}{$serverdata.nameserver3}{if $serverdata.nameserver3ip} ({$serverdata.nameserver3ip}){/if}<br />{/if}
															{if $serverdata.nameserver4}{$serverdata.nameserver4}{if $serverdata.nameserver4ip} ({$serverdata.nameserver4ip}){/if}<br />{/if}
															{if $serverdata.nameserver5}{$serverdata.nameserver5}{if $serverdata.nameserver5ip} ({$serverdata.nameserver5ip}){/if}<br />{/if}									
													</span>
												</li>
											{/if}
										{/if}
										{if $domain && $sslStatus}
											<li>
												<span class="list-heading">{lang key='sslState.sslStatus'}</span>
												<span class="list-text{if $sslStatus->isInactive()} ssl-inactive{/if}">
													<img src="{$sslStatus->getImagePath()}" width="12" data-type="service" data-domain="{$domain}" data-showlabel="1" class="{$sslStatus->getClass()}"/>
													<span id="statusDisplayLabel">
														{if !$sslStatus->needsResync()}
															{$sslStatus->getStatusDisplayLabel()}
														{else}
															{lang key='loading'}
														{/if}
													</span>
												</span>
											</li>
											
											{if $sslStatus->isActive() || $sslStatus->needsResync()}
												<li>
													<span class="list-heading">{lang key='sslState.startDate'}</span>
													<span class="list-text" id="ssl-startdate">
														{if !$sslStatus->needsResync() || $sslStatus->startDate}
															{$sslStatus->startDate->toClientDateFormat()}
														{else}
															{lang key='loading'}
														{/if}
													</span>
												</li>
												<li>
													<span class="list-heading">{lang key='sslState.expiryDate'}</span>
													<span class="list-text" id="ssl-expirydate">
														{if !$sslStatus->needsResync() || $sslStatus->expiryDate}
															{$sslStatus->expiryDate->toClientDateFormat()}
														{else}
															{lang key='loading'}
														{/if}
													</span>
												</li>
												<li>
													<span class="list-heading">{lang key='sslState.issuerName'}</span>
													<span class="list-text" id="ssl-issuer">
														{if !$sslStatus->needsResync() || $sslStatus->issuerName}
															{$sslStatus->issuerName}
														{else}
															{lang key='loading'}
														{/if}
													</span>
												</li>
											{/if}
										{/if}
										
									</ul>
										<br>
										<div class="p-3 light border rounded">
											<a href="https://{$domain}" class="btn btn-default btn-xs" target="_blank">{lang key='visitwebsite'}</a>
											{if $domainId}
												<a href="clientarea.php?action=domaindetails&id={$domainId}" class="btn btn-default btn-xs" target="_blank">{lang key='managedomain'}</a>
											{/if}
										</div>
									{/if}
									{if $moduleclientarea}
										<hr class="separator" />
										<div class="text-center module-client-area">
											{$moduleclientarea}
										</div>
										<hr class="separator" />
									{/if}
								</div>
								{if $sslStatus}
									<div class="tab-pane fade" role="tabpanel" id="ssl-info">
										{if $sslStatus->isActive()}
											<div class="alert alert-success" role="alert">
												{lang key='sslActive' expiry=$sslStatus->expiryDate->toClientDateFormat()}
											</div>
										{else}
											<div class="alert alert-warning ssl-required" role="alert">
												{lang key='sslInactive'}
											</div>
										{/if}
									</div>
								{/if}
							{elseif $moduleclientarea}
								<div class="tab-pane fade{if !$domain} show active{/if}" role="tabpanel" id="manage">
									{if $moduleclientarea}
										<hr class="separator" />
										<div class="text-center module-client-area">
											{$moduleclientarea}
										</div>
										<hr class="separator" />
									{/if}
								</div>
							{/if}
							{if $configurableoptions}
								<div class="tab-pane fade{if !$domain && !$moduleclientarea} show active{/if}" role="tabpanel" id="configoptions">
									{foreach from=$configurableoptions item=configoption}
										<h6 class="heading">{$configoption.optionname}</h6>
										<div class="light border p-2 mb-2 mt-1">
											{if $configoption.optiontype eq 3}{if $configoption.selectedqty}{$LANG.yes}{else}{$LANG.no}{/if}{elseif $configoption.optiontype eq 4}{$configoption.selectedqty} x {$configoption.selectedoption}{else}{$configoption.selectedoption}{/if}
										</div>
									{/foreach}
								</div>
							{/if}
							{if $metricStats}
								<div class="tab-pane fade{if !$domain && !$moduleclientarea && !$configurableoptions} show active{/if}" role="tabpanel" id="metrics">
									{include file="$template/clientareaproductusagebilling.tpl"}
								</div>
							{/if}
							{if $customfields}
								<div class="tab-pane fade{if !$domain && !$moduleclientarea && !$configurableoptions && !$metricStats} show active{/if}" role="tabpanel" id="additionalinfo">
									{foreach from=$customfields item=field}
										<h6 class="heading">{$field.name}</h6>
										<div class="light border p-2 mb-2 mt-1">
											{$field.value}
										</div>
									{/foreach}
								</div>
							{/if}
							{if $lastupdate}
								<div class="tab-pane fade" role="tabpanel" id="resourceusage">
									<div class="row">
										<div class="col-sm-10 offset-sm-1">
											<div class="row">
												<div class="col-sm-6">
													<h4>{lang key='diskSpace'}</h4>
													<input type="text" value="{$diskpercent|substr:0:-1}" class="dial-usage" data-width="100" data-height="100" data-min="0" data-readOnly="true" />
													<p>{$diskusage}MB / {$disklimit}MB</p>
												</div>
												<div class="col-sm-6">
													<h4>{lang key='bandwidth'}</h4>
													<input type="text" value="{$bwpercent|substr:0:-1}" class="dial-usage" data-width="100" data-height="100" data-min="0" data-readOnly="true" />
													<p>{$bwusage}MB / {$bwlimit}MB</p>
												</div>
											</div>
										</div>
									</div>
									<p class="text-muted mb-0">{lang key='clientarealastupdated'}: {$lastupdate}</p>
									<script src="{$BASE_PATH_JS}/jquery.knob.js"></script>
									<script>
										jQuery(function() {
											jQuery(".dial-usage").knob({
												'format': function(v) {
													alert(v);
												}
											});
										});
									</script>
								</div>
							{/if}
						</div>
					</div>
				</div>
			</div>
            {/if}

        
		
		
		{else}
		
			<div class="alert-lg no-data">
				<div class="icon">
					<i class="fas fa-exclamation-triangle"></i>
				</div>
				<div class="text">
					{if $suspendreason}
						<strong>{$suspendreason}</strong><br />
					{/if}
					{$LANG.cPanel.packageNotActive} {$status}.<br />
					{if $systemStatus eq "Pending"}
						{$LANG.cPanel.statusPendingNotice}
					{elseif $systemStatus eq "Suspended"}
						{$LANG.cPanel.statusSuspendedNotice}
					{/if}
				</div>
			</div>
				
        {/if}
	
	
	{/if}
    </div>
    <div class="tab-pane fade in" id="tabDownloads">
		
		<div class="section">
			<div class="section-header">
				<h3>{$LANG.downloadstitle}</h3>
				<p class="desc">{lang key="clientAreaProductDownloadsAvailable"}</p>
			</div>
			<div class="section-body">
				
				<div class="kbarticles kbdownloads">
					{foreach from=$downloads item=download}
						<a href="{$download.link}">
							{$download.title}                            
							<p>{$download.description|unescape:"entity"}</p>
						</a>
					{/foreach}
				</div>
			</div>
		</div>
		


    </div>
    <div class="tab-pane fade in" id="tabAddons">
		<div class="section">
			<div class="section-header">
			<h3>{$LANG.clientareahostingaddons}</h3>
				{if $addonsavailable}
					<p class="desc">{$LANG.clientAreaProductAddonsAvailable}</p>
				{/if}
			</div>
			<div class="section-body">
				<div class="row">
					{foreach from=$addons item=addon}
						<div class="col-sm-6">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h3 class="panel-title">{$addon.name}</h3>
								</div>
								<div class="panel-body p-0">
									<ul class="list-info list-info-50 list-info-bordered">
										<li>
											<span class="list-heading">{$LANG.clientareastatus}</span>
											<span class="list-text"><span class="label status-{$addon.rawstatus|strtolower}">{$addon.status}</span></span>
										</li>
										<li>
                                              <span class="list-heading">{$LANG.recurringamount}</span>
                                              <span class="list-text">{$addon.pricing}</span>
										</li>
										<li>
											<span class="list-heading">{$LANG.registered}</span>
											<span class="list-text">{$addon.regdate}</span>
										</li>
										<li>
											<span class="list-heading">{$LANG.clientareahostingnextduedate}</span>
											<span class="list-text">{$addon.nextduedate}</span>
										</li>
									</ul>
								</div>
								{if $addon.managementActions}
									<div class="panel-footer">
										{$addon.managementActions}
									</div>
								{/if}
							</div>
						</div>
					{/foreach}
				</div>
			</div>
		</div>
		
    </div>
    <div class="tab-pane fade in" id="tabChangepw">
		<div class="section">
			<div class="section-header">
				<h3>{$LANG.serverchangepassword}</h3>
				<p class="desc">{$LANG.serverchangepasswordintro}</p>
			</div>
		
			<div class="section-body">
				{if $modulechangepwresult}
					{if $modulechangepwresult == "success"}
						{include file="$template/includes/alert.tpl" type="success" msg=$modulechangepasswordmessage textcenter=true}
					{elseif $modulechangepwresult == "error"}
						{include file="$template/includes/alert.tpl" type="error" msg=$modulechangepasswordmessage|strip_tags textcenter=true}
					{/if}
				{/if}

				<div class="row">
					<div class="col-sm-7">
						<form class=" using-password-strength" method="post" action="{$smarty.server.PHP_SELF}?action=productdetails#tabChangepw" role="form">
							<input type="hidden" name="id" value="{$id}" />
							<input type="hidden" name="modulechangepassword" value="true" />
							<div class="TM-card">
								<div id="newPassword1" class="form-group has-feedback">
									<label for="inputNewPassword1" class="control-label">{$LANG.newpassword}</label>
									<input type="password" class="form-control" id="inputNewPassword1" name="newpw" autocomplete="off" />
									<span class="form-control-feedback glyphicon"></span>
									{include file="$template/includes/pwstrength.tpl"}
								</div>
								<div class="form-group">
									<button type="button" class="btn btn-default generate-password" data-targetfields="inputNewPassword1,inputNewPassword2">
										{$LANG.generatePassword.btnLabel}
									</button>
								</div>
								
								<div id="newPassword2" class="form-group has-feedback">
									<label for="inputNewPassword2" class="control-label">{$LANG.confirmnewpassword}</label>
									<input type="password" class="form-control" id="inputNewPassword2" name="confirmpw" autocomplete="off" />
									<span class="form-control-feedback glyphicon"></span>
									<div id="inputNewPassword2Msg">
									</div>
								</div>
							</div>
							<div class="form-actions">
								<input class="btn btn-primary" type="submit" value="{$LANG.clientareasavechanges}" />
								<input class="btn" type="reset" value="{$LANG.cancel}" />
							</div>
						</form>
					</div>
				</div>
				
			</div>
		</div>

    </div>
</div>