{*
 **********************************************************
 * Developed by: Team Theme Metro
 * Website: http://www.thememetro.com
 **********************************************************
*}

{if $themesettings.clientarea.contactuspage neq "1"}
{if $sent}
	{include file="$template/includes/alert.tpl" type="success" msg=$LANG.contactsent textcenter=true}
{/if}

{if $errormessage}
	{include file="$template/includes/alert.tpl" type="error" errorshtml=$errormessage}
{/if}

{if !$sent}
	<form method="post" action="contact.php" role="form">
		<input type="hidden" name="action" value="send" />
		<div class="TM-card">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-group">
						<label for="inputName">{$LANG.supportticketsclientname}</label>
						<input type="text" name="name" value="{$name}" class="form-control" id="inputName" />
					</div>
				</div>
				<div class="col-sm-6">
					<div class="form-group">
						<label for="inputEmail">{$LANG.supportticketsclientemail}</label>
						<input type="email" name="email" value="{$email}" class="form-control" id="inputEmail" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label for="inputSubject">{$LANG.supportticketsticketsubject}</label>
				<input type="subject" name="subject" value="{$subject}" class="form-control" id="inputSubject" />
			</div>	  
			<div class="form-group">
				<label for="inputMessage">{$LANG.contactmessage}</label>
				<textarea name="message" rows="10" class="form-control" id="inputMessage">{$message}</textarea>
			</div>
		</div>
		{if $captcha}
			{include file="$template/includes/captcha.tpl"}
		{/if}		
		<div class="form-actions text-center">
			<button type="submit" class="btn btn-lg btn-primary{$captcha->getButtonClass($captchaForm)}">{$LANG.contactsend}</button>
		</div>
	</form>
{/if}

{else}
				
<section class="section">
	<h2 class="h3 d-none">{lang key='howCanWeHelp'}</h2>
	<div class="tiles">
		<div class="row">
			<div class="col-md-4">
				<div class="tile" onclick="window.location='{routePath('knowledgebase-index')}'">
					<a class="stats" href="{routePath('knowledgebase-index')}">
						<div class="icon"><i class="fal fa-book"></i></div>
						<div class="stat"><i class="fad fa-book"></i></div>
						<div class="title">
							<span class="text-base">{lang key='knowledgebasetitle'}</span>
							<span class="decs mt-1">{lang key='knowledgebasedescription'}</span>
						</div>
					</a>
				</div>
			</div>
			<div class="col-md-4">
				<div class="tile" onclick="window.location='submitticket.php'">
					<a class="stats" href="submitticket.php">
						<div class="icon"><i class="fal fa-life-ring"></i></div>
						<div class="stat"><i class="fad fa-life-ring"></i></div>
						<div class="title">
							<span class="text-base">{lang key='getsupport'}</span>
							<span class="decs mt-1">{lang key='subaccountpermstickets'}</span>
						</div>
					</a>
				</div>
			</div>		
			<div class="col-md-4">
				<div class="tile" data-toggle="modal" data-target="#ContactUsFrom">
					<a class="stats" href="javascript:;">
						<div class="icon"><i class="fal fa-envelope"></i></div>
						<div class="stat"><i class="fad fa-envelope"></i></div>
						<div class="title">
							<span class="text-base">{lang key='contactUs'}</span>
							<span class="decs mt-1">{lang key='presalescontactdescription'}</span>
						</div>
					</a>
				</div>
			</div>
		</div>
	</div>
</section>

{if $themesettings.clientarea.caddress}
<section class="section">
	<div class="row">
		{if $themesettings.clientarea.gmaps}
		<div class="col-md-6 col-lg-7 mb-3 mb-md-0">
			<div class="border rounded">
				{$themesettings.clientarea.gmaps|unescape:"html"}
			</div>	
		</div>
		{/if}
		{if $themesettings.clientarea.caddress}
		<div class="{if $themesettings.clientarea.gmaps}col-md-6 col-lg-5{else}col-12{/if}">
			<h4 class="h3 mt-0">{lang key='domaindnsaddress'}</h4>
			<hr />
			<address>
				{$themesettings.clientarea.caddress|unescape:"html"}
			</address>
			{if $themesettings.general.phonenumber && $themesettings.clientarea.cnumber}
				<div class="contact_phone mb-3">
					<a href="tel:{$themesettings.general.phonenumber}"><i class="fas fa-phone-volume"></i> {$themesettings.general.phonenumber}</a>
				</div>
			{/if}
			{if !empty($socialAccounts) && $themesettings.clientarea.csocial}
				<p class="h5">{lang key='twitterfollowus'}</p>
				{foreach $socialAccounts as $account}
					<a class="btn btn-icon" href="{$account->getUrl()}" target="_blank">
						<i class="{$account->getFontAwesomeIcon()}"></i>
					</a>
				{/foreach}
			{/if}
		</div>
		{/if}
	</div>
</section>
{/if}


<div class="modal system-modal fade" id="ContactUsFrom" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
				<h5 class="modal-title">{lang key='contactUs'}</h5>
				<button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">&times;</span>
					<span class="sr-only">{lang key='close'}</span>
				</button>
            </div>
            <div class="modal-body">
				{if $errormessage || $sent}{else}
					<p class="text-muted d-none">{lang key='contactheader'}</p>
				{/if}
				
				{if $sent}
					{include file="$template/includes/alert.tpl" type="success" msg=$LANG.contactsent textcenter=true}
				{/if}
				
				{if $errormessage}
					{include file="$template/includes/alert.tpl" type="error" errorshtml=$errormessage}
				{/if}
				
				{if !$sent}	
				<form method="post" action="contact.php" role="form">
					<input type="hidden" name="action" value="send" />
					<div class="TM-card">
						<div class="row">
							<div class="col-sm-6">
								<div class="form-group">
									<label for="inputName">{$LANG.supportticketsclientname}</label>
									<input type="text" name="name" value="{$name}" class="form-control" id="inputName" required/>
								</div>
							</div>
							<div class="col-sm-6">
								<div class="form-group">
									<label for="inputEmail">{$LANG.supportticketsclientemail}</label>
									<input type="email" name="email" value="{$email}" class="form-control" id="inputEmail" required/>
								</div>
							</div>
						</div>
						<div class="form-group">
							<label for="inputSubject">{$LANG.supportticketsticketsubject}</label>
							<input type="subject" name="subject" value="{$subject}" class="form-control" id="inputSubject" required/>
						</div>	  
						<div class="form-group">
							<label for="inputMessage">{$LANG.contactmessage}</label>
							<textarea name="message" rows="7" class="form-control" id="inputMessage" required>{$message}</textarea>
						</div>
					</div>
					{if $captcha}	
						{include file="$template/includes/captcha.tpl"}
					{/if}			
					<div class="m-3 pt-3 border-top">
						<button type="submit" class="btn btn-lg btn-block btn-primary{$captcha->getButtonClass($captchaForm)}">{$LANG.contactsend}</button>
					</div>
				</form>
				{/if}
            </div>
        </div>
    </div>
</div>

{if $errormessage || $sent}
	<script>
		jQuery(document).ready(function () {
			jQuery("#ContactUsFrom").modal('show');
		});
	</script>
{/if}

{/if}