<script src="{$WEB_ROOT}/templates/{$template}/assets/js/jscolor.js"></script>
<script src="{$WEB_ROOT}/templates/{$template}/assets/js/sweetalert.min.js"></script>

<div class="theme-colors" id="settingsModal">
	<h4 id="settingsModalLabel" class="no-margin-bottom">
		<i class="fad fa-tint text-danger"></i> Colour Settings<br /><span class="small text-muted">Build your own color scheme</span>
	</h4>
	<hr />
	<div class="theme-colors-container">
		<form action="#" id="settingsForm">
		</form>
	</div>
	<hr />
	<button type="button" id="saveSettings" class="btn btn-block btn-primary">Save changes</button>
</div>

<script>	
	{if $lessvariables}
		let lessVariables = {
			{foreach from=$lessvariables key=key item=value}
				'{$key}': '{$value}',
			{/foreach}
		}
	{else}
		let lessVariables = {
			'themeColor': '#0273d4',
			'brand-secondary': '#DB3F3B',
			'baseFontcolor': '#2a2e36',
			'baseHeadingcolor': '#2a2e36',
			'gray-darker': '#101010',
			'gray-lighter': '#EDF0F5',
			'default-border-color': '#D5DCE5',
			'sticker-bg': '#fedc45',
			'dmb': '#1d1d1d',
			'dmc': '#e0e0e0',
			'dmhc': '#e0e0e0',
			'dmbc': '#333333',
		}
	{/if}
	
	let lessVariableNames = {
		'themeColor': 'Primary',
		'brand-secondary': 'Secondary',
		'baseFontcolor': 'Text',
		'baseHeadingcolor': 'Headings',
		'gray-darker': 'Dark',
		'gray-lighter': 'Light',
		'default-border-color': 'Border',
		'sticker-bg': 'Sticker',
		'dmb': 'Body',
		'dmc': 'Text',
		'dmhc': 'Headings',
		'dmbc': 'Border',
	}

	if (localStorage.getItem('lessVariables') !== null) {
		lessVariables = JSON.parse(localStorage.getItem('lessVariables'));
		less.modifyVars(lessVariables);
	}

	function createLessVariableElements(variables) {
		$('#settingsForm').html('');
		{literal}
		$.each(variables, function (key, value) {
			let jscolorClass = '';
			if (key !== 'version') {
				jscolorClass = 'jscolor {zIndex:9999, hash:true, closable:true}';
			}
			$(`
			<div class="form-row align-items-center mb-3" id="${key}">
				<label for="${key}" class="col-sm-4 control-label">${lessVariableNames[key]}:</label>
				<div class="col-sm-6">
					<input type="text" name="${key}" data-name="${key}" class="form-control ${jscolorClass}"
						id="${key}" value="${value}">
				</div>
			</div>`).appendTo('#settingsForm');
		});
		{/literal}
	}

	let defaultLessVariables = currentLessVariables = lessVariables;
	$(document).ready(function () {
		createLessVariableElements(lessVariables);
	});

	$(document).on('change keyup blur', '#settingsForm input', function () {
		let variables = {};
		currentLessVariables = {}
		$('#settingsForm input[type=text]').each(function () {
			variables['@' + $(this).data('name')] = $(this).val();
			currentLessVariables[$(this).data('name')] = $(this).val();
		});

		less.modifyVars(variables);
	});

	$('#settingsModal').on('hide.bs.modal', function () {
		$('#settingsForm input[type=text]').each(function () {
			$(this).val(defaultLessVariables[$(this).data('name')]);
		});
		less.modifyVars(defaultLessVariables);
	});

	$('#saveSettings').on('click', function () {
		lessVariables = defaultLessVariables = currentLessVariables;

		less.modifyVars(lessVariables).then(function (response) {
			console.log(response);
		});
		localStorage.setItem('lessVariables', JSON.stringify(currentLessVariables));

		// Make post
		let button = $(this);
		$(button).attr('disabled', 'disabled').html('Compiling please wait...');
	
		$.ajax({
			url: '{$WEB_ROOT}/modules/addons/adminpanel/api/compile.php',
			data: {
				css: $(less.sheets[0].nextSibling).html(),
				template: '{$template}',
				lessvariables: lessVariables
			},
			dataType: 'json',
			method: 'POST',
			success: function (response) {
				console.log('Success', response);
				$(button).removeAttr('disabled').html('Save changes');
				swal('Saved!', 'Your color scheme have been saved.', 'success');
			},
			error: function (response) {
				console.log('Error', response);
				$(button).removeAttr('disabled').html('Save changes');
				swal('Error!', 'There was an error saving your color scheme.', 'error');
			}
		});
	});
	</script>
	
	<script>
		jQuery(document).ready(function () {
			{if $themesettings.customcolors.darkmode == '1'}
				$('#baseFontcolor, #baseHeadingcolor, #gray-darker, #gray-lighter, #default-border-color').addClass('d-none');
				$('#dmb, #dmc, #dmhc, #dmbc').removeClass('d-none');
			{else}
				$('#baseFontcolor, #baseHeadingcolor, #gray-darker, #gray-lighter, #default-border-color').removeClass('d-none');
				$('#dmb, #dmc, #dmhc, #dmbc').addClass('d-none');
			{/if}
			
			$('#version').addClass('d-none');
		});
	</script>