<div class="card mb-0 promo-banner bg-checkered {$promotion->getClass()}">
    <div class="card-body p-5">
		<div class="d-flex align-items-center flex-column flex-md-row">
			<div class="icon-left">
				<a href="{$promotion->getLearnMoreRoute()}">
					<img src="{$promotion->getImagePath()}">
				</a>
			</div>

			<div class="content w-100 ml-md-5">
				<h3 class="h4 bolder">
					{$promotion->getHeadline()}
					{if $promotion->getLearnMoreRoute()}
						<small><a href="{$promotion->getLearnMoreRoute()}">{lang key='learnmore'}...</a></small>
					{/if}
				</h3>
				<h4>{$promotion->getTagline()}</h4>

				{if $promotion->getDescription()}
					<p>{$promotion->getDescription()}</p>
				{/if}

				{if $promotion->hasFeatures()}
					<ul>
						{assign "promotionFeatures" $promotion->getFeatures()}
						{foreach $promotionFeatures as $key=>$feature}
							<li class="{if $key < ($promotionFeatures|@count / 2)}left{else}right{/if}">
								<i class="far fa-check-circle"></i> {$feature}
							</li>
						{/foreach}
					</ul>
				{/if}
			</div>
		</div>
    </div>
	<div class="card-footer">
		<form method="post" action="{$targetUrl}">
			{foreach $inputParameters as $key => $value}
				<input type="hidden" name="{$key}" value="{$value}">
			{/foreach}
			<button type="submit" class="btn btn-primary btn-block">
				{if $product->isFree()}
					{$promotion->getCta()}
					{lang key="orderfree"}
				{else}
					{$promotion->getCta()} {$product->name}
					{lang key="fromJust"}
					{if $product->pricing()->first()->isYearly()}
						{$product->pricing()->first()->yearlyPrice()}
					{elseif $product->pricing()->first()->isOneTime()}
						{$product->pricing()->first()->oneTimePrice()}
					{else}
						{$product->pricing()->first()->monthlyPrice()}
					{/if}
				{/if}
			</button>
		</form>
	</div>
</div>
