<div class="section">
    <div class="">
        {include file="$template/includes/flashmessage.tpl"}

        {if $accounts->count() == 0}
			<div class="alert-lg no-data" id="cPanelSuspendReasonPanel">
				<div class="icon">
					<i class="fas fa-exclamation-triangle"></i>
				</div>
				<div class="text">
					<p>{lang key="switchAccount.noneFound"}</p>
					<p>{lang key="switchAccount.createInstructions"}</p>
				</div>
                <a href="{routePath('cart-index')}" class="btn btn-primary">
                    {lang key="shopNow"}
                </a>
			</div>
        {else}
            <p>{lang key="switchAccount.choose"}</p>

            <div class="select-account">
				{foreach $accounts as $account}
					<a href="#" class="TM-card white{if $account->status == 'Closed'} disabled{/if}" data-id="{$account->id}">
						<span class="user-list user-switch">
							<span class="user-list-item">
								{if $themesettings.clientarea.gravatar}
									<span class="user-avatar avatar-small">
										<img src="https://www.gravatar.com/avatar/{$account->email|md5}" />
									</span>
								{/if}
								<span class="user-info">
									<span class="user-profile">
										<span class="user-list-name">{$account->displayName}</span>
										<span class="user-list-email small text-muted">{$account->email}</span>
									</span>
									<span class="user-status">
										{if $account->authedUserIsOwner()}
											<span class="label label-info">{lang key="clientOwner"}</span>
										{/if}
										{if $account->status == 'Closed'}
											<span class="label label-default">{$account->status}</span>
										{/if}
									</span>
								</span>
							</span>
						</span>
					</a>
				{/foreach}
            </div>
        {/if}
    </div>
</div>

<form method="post" action="{routePath('user-accounts')}">
    <input type="hidden" name="id" value="" id="inputSwitchAcctId">
</form>

<script>
    $(document).ready(function() {
        $('.select-account a').click(function(e) {
            e.preventDefault();
            $('#inputSwitchAcctId').val($(this).data('id'))
                .parent('form').submit();
        });
    });
</script>
