{include file="orderforms/{$carttpl}/common.tpl"}

<div id="order-standard_cart">
	<div {if !$themesettings.general.themelayout}class="main-container-nosidebar mx-auto"{/if}>
		<div class="row">
			<div class="col-md-12">				
				{if $totalDomainCount == 0}
					<div class="alert-lg no-data no-border">
						<div class="icon">
							<i class="fad fa-thumbs-up"></i>
						</div>
						<div class="text">
							<h4>{$LANG.domainRenewal.noDomains}</h4>
						</div>
						<a href="{$WEB_ROOT}/clientarea.php" class="btn btn-default">
							{$LANG.orderForm.returnToClientArea}
						</a>
					</div>
				{else}
				
					<div class="header-lined">
						<div>
							<h1>
								{if $totalResults > 1}{lang key='navrenewdomains'}{else}{lang key='domainrenew'}{/if}
							</h1>
							{if $totalResults > 5}
								<div class="search-group">
									<input id="domainRenewalFilter" type="search" class="domain-renewals-filter form-control" placeholder="{lang key='searchenterdomain'}">
								</div>
							{/if}
						</div>
					</div>
				
					<div class="row ajaxcart_cont">
						<div class="col-lg-8">						
							{if $totalResults < $totalDomainCount}
								<div class="text-center mb-3">
									{lang key='domainRenewal.showingDomains' showing=$totalResults totalCount=$totalDomainCount}
									<a id="linkShowAll" href="{routePath('cart-domain-renewals')}">{lang key='domainRenewal.showAll'}</a>
								</div>
							{/if}
							<div id="domainRenewals" class="domain-renewals">
								{foreach $renewalsData as $renewalData}
									<div class="domain-renewal card bg-white p-0" data-domain="{$renewalData.domain}">
										<div class="card-body p-3">
											<div class="d-flex flex-column flex-sm-row justify-content-between">
												<h4 class="m-0">{$renewalData.domain}</h4>
												<div>
													{if !$renewalData.eligibleForRenewal}
														<span class="label label-info">
															{if $renewalData.freeDomainRenewal}
																{lang key='domainRenewal.freeWithService'}
															{else}
																{lang key='domainRenewal.unavailable'}
															{/if}
														</span>
													{elseif ($renewalData.pastGracePeriod && $renewalData.pastRedemptionGracePeriod)}
														<span class="label label-info">
															{lang key='domainrenewalspastgraceperiod'}
														</span>
													{elseif !$renewalData.beforeRenewLimit && $renewalData.daysUntilExpiry > 0}
														<span class="label label-{if $renewalData.daysUntilExpiry > 30}success{else}warning{/if}">
															{lang key='domainRenewal.expiringIn' days=$renewalData.daysUntilExpiry}
														</span>
													{elseif $renewalData.daysUntilExpiry === 0}
														<span class="label label-grey">
															{lang key='expiresToday'}
														</span>
													{elseif $renewalData.beforeRenewLimit}
														<span class="label label-info">
															{lang key='domainRenewal.maximumAdvanceRenewal' days=$renewalData.beforeRenewLimitDays}
														</span>
													{else}
														<span class="label label-danger">
															{lang key='domainRenewal.expiredDaysAgo' days=$renewalData.daysUntilExpiry*-1}
														</span>
													{/if}
												</div>
											</div>

											<p class="small text-muted">{lang key='clientareadomainexpirydate'}: {$renewalData.expiryDate->format('j M Y')} ({$renewalData.expiryDate->diffForHumans()})</p>
											{if $renewalData.freeDomainRenewal}
												<p class="domain-renewal-desc">{lang key='domainRenewal.freeWithServiceDesc'}</p>
											{/if}										

											{*
											<label for="renewalPricing{$renewalData.id}" class="control-label col-md-5 text-muted">
												{lang key='domainRenewal.availablePeriods'}
												{if $renewalData.inGracePeriod || $renewalData.inRedemptionGracePeriod}
													*
												{/if}
											</label>
											*}
					
											<div class="domain-renewal-form">
												{if ($renewalData.pastGracePeriod && $renewalData.pastRedemptionGracePeriod) || !count($renewalData.renewalOptions)}
												{else}
												<div class="domain-renewal-period">
													<select class="form-control input-lg select-renewal-pricing" id="renewalPricing{$renewalData.id}" data-domain-id="{$renewalData.id}">
														{foreach $renewalData.renewalOptions as $renewalOption}
															<option value="{$renewalOption.period}">
																{$renewalOption.period} {lang key='orderyears'} @ {$renewalOption.rawRenewalPrice}
																{if $renewalOption.gracePeriodFee && $renewalOption.gracePeriodFee->toNumeric() != 0.00}
																	+ {$renewalOption.gracePeriodFee} {lang key='domainRenewal.graceFee'}
																{/if}
																{if $renewalOption.redemptionGracePeriodFee && $renewalOption.redemptionGracePeriodFee->toNumeric() != 0.00}
																	+ {$renewalOption.redemptionGracePeriodFee} {lang key='domainRenewal.redemptionFee'}
																{/if}
															</option>
														{/foreach}
													</select>
												</div>
												{/if}
												{if !$renewalData.eligibleForRenewal || $renewalData.beforeRenewLimit || ($renewalData.pastGracePeriod && $renewalData.pastRedemptionGracePeriod)}
												{else}
												<div class="domain-renewal-action">
													<button id="renewDomain{$renewalData.id}" class="btn btn-primary btn-add-renewal-to-cart" data-domain-id="{$renewalData.id}">
														<span class="to-add">
															<i class="fas fa-fw fa-spinner fa-spin"></i> {lang key='addtocart'}
														</span>
														<span class="added">{lang key='domaincheckeradded'}</span>
													</button>
												</div>
												{/if}
											</div>
										</div>
									</div>
								{/foreach}
							</div>

							{if $hasDomainsInGracePeriod}
								<div class="text-muted">
									 * {lang key='domainRenewal.graceRenewalPeriodDescription'}
								</div>
							{/if}
						</div>
						<div class="col-lg-4">
							<div  id="sidebar">
								<div class="sidebar__inner blocks cartsummary">
									<div>
										<div class="order-summary">
											<div class="loader" id="orderSummaryLoader">
												<i class="fad fa-circle-notch fa-spin fa-2x"></i>
											</div>
											<h2><i class="fal fa-shopping-cart text-primary"></i>&nbsp;{lang key='ordersummary'}</h2>
											<div class="summary-container-outer">
												<div class="summary-container" id="producttotal"></div>
											
												<div class="text-center">
													<a id="btnGoToCart" class="btn btn-primary btn-block btn-lg" href="{$WEB_ROOT}/cart.php?a=view">
														{lang key='viewcart'}
													</a>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				{/if}
			</div>
		</div>
	</div>
</div>

<form id="removeRenewalForm" method="post" action="{$WEB_ROOT}/cart.php">
	<input type="hidden" name="a" value="remove" />
	<input type="hidden" name="r" value="" id="inputRemoveItemType" />
	<input type="hidden" name="i" value="" id="inputRemoveItemRef" />
	<div class="modal fade modal-remove-item" id="modalRemoveItem" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header d-block">
					<h4 class="modal-title m-0">
						<button type="button" class="close" data-dismiss="modal" aria-label="{lang key='orderForm.close'}">
							<span aria-hidden="true">&times;</span>
						</button>
						<span>{lang key='orderForm.removeItem'}</span>
					</h4>
				</div>
				<div class="modal-body">
					{lang key='cartremoveitemconfirm'}
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">{lang key='no'}</button>
					<button type="submit" class="btn btn-primary">{lang key='yes'}</button>
				</div>
			</div>
		</div>
	</div>
</form>

<script>recalculateRenewalTotals();</script>

<script type="text/javascript" src="{$WEB_ROOT}/templates/orderforms/{$carttpl}/js/ResizeSensor.js"></script>
<script type="text/javascript" src="{$WEB_ROOT}/templates/orderforms/{$carttpl}/js/jquery.sticky-sidebar.min.js"></script>

<script>
    jQuery('#sidebar').stickySidebar({
        topSpacing: 90,
        bottomSpacing: 60,
        minWidth: 992,
        containerSelector: '.ajaxcart_cont',
        innerWrapperSelector: '.sidebar__inner'
    });
</script>