{include file="$template/includes/tablelist.tpl" tableName="DomainPricing" filterColumn="1"  noOrdering=true}
<script>
	jQuery(document).ready(function(){
		var table = jQuery('#tableDomainPricing').show().DataTable();
		{if $orderby == 'tld'}
			table.order(0, '{$sort}');
		{elseif $orderby == 'category'}
			table.order(1, '{$sort}');
		{/if}
		table.draw();
		jQuery('#tableLoading').hide();
	});
</script>
			
<div class="table-container clearfix">
	<div class="table-header">
		<div class="d-flex align-items-center mb-2 mb-md-0">
			<label>{lang key='view'}</label>
			<div class="dropdown view-filter-btns">
				<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
					<span>{lang key='domainRenewal.showAll'}</span>
				</button>
				 <ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenuButton">
					<li><a href="#" class="dropdown-item"><span data-value="all">{lang key='domainRenewal.showAll'}</span></a></li>
					<div class="dropdown-divider">--</div>
					{foreach $categoriesWithCounts as $category => $count}
						<li><a href="#" class="dropdown-item"><span data-value="{$category}">{lang key="domainTldCategory.$category" defaultValue=$category}</span>&nbsp;({$count})</a></li>
					{/foreach}
				</ul>
			</div>
		</div>
		<div class="search-group">
			<input type="text" id="table-search" class="form-control" placeholder="{$LANG.tableentersearchterm}">
		</div>
	</div>
	<table class="datatable table table-tlds w-hidden" id="tableDomainPricing">
		<thead>
			<tr>
				<th class="text-muted">{lang key='orderdomain'}</th>
				<th class="text-muted d-none">{lang key='category'}</th>
				<th class="text-muted">{lang key='pricing.register'}</th>
				<th class="text-muted">{lang key='pricing.transfer'}</th>
				<th class="text-muted">{lang key='pricing.renewal'}</th>
			</tr>
		</thead>
		<tbody>
			{foreach $pricing['pricing'] as $tld => $price}
				<tr>
					<td>
						<strong class="tld-name"><span>.</span>{$tld}</strong>
						{if $price.group}
							<span class="tld-sale-group tld-sale-group-{$price.group}">{$price.group}!</span>
						{/if}
					</td>
					<td class="d-none">
						<span class="categories">{$price.categories[0]}</span>
					</td>
					<td>
						<span class="tld-label text-muted">{lang key='pricing.register'}</span>
						{if isset($price.register) && current($price.register) > 0}
							{current($price.register)}<br>
								<small class="text-muted">{key($price.register)} {if key($price.register) > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
							{elseif isset($price.register) && current($price.register) == 0}
								<small class="text-muted">{lang key='orderfree'}</small>
							{else}
								<small class="text-muted">{lang key='na'}</small>
						{/if}
					</td>
					<td>
						<span class="tld-label text-muted">{lang key='pricing.transfer'}</span>
						{if isset($price.transfer) && current($price.transfer) > 0}
							{current($price.transfer)}<br>
							<small class="text-muted">{key($price.transfer)} {if key($price.register) > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
						{elseif isset($price.transfer) && current($price.transfer) == 0}
							<small class="text-muted">{lang key='orderfree'}</small>
						{else}
							<small class="text-muted">{lang key='na'}</small>
						{/if}
					</td>
					<td>
						<span class="tld-label text-muted">{lang key='pricing.renewal'}</span>
						{if isset($price.renew) && current($price.renew) > 0}
							{current($price.renew)}<br>
							<small class="text-muted">{key($price.renew)} {if key($price.register) > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
						{elseif isset($price.renew) && current($price.renew) == 0}
							<small class="text-muted">{lang key='orderfree'}</small>
						{else}
							<small class="text-muted">{lang key='na'}</small>
						{/if}
					</td>
				</tr>
			{/foreach}
		</tbody>
	</table>
	<div class="text-center" id="tableLoading">
		<p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
	</div>
</div>