{if $action eq 'checkout'}
	{include file="orderforms/{$carttpl}/checkout.tpl"}
{else}
	<div class="cartsummary_cont">
		<div class="summary_body">
		
			{if $errormessage}
				<div class="errorbox m-3" style="display:block;">
					{$errormessage|replace:'<li>':' &nbsp;#&nbsp; '} &nbsp;#&nbsp;
				</div>
			{elseif $promotioncode && $rawdiscount eq "0.00"}
				<div class="errorbox m-3" style="display:block;">
					{$LANG.promoappliedbutnodiscount}
				</div>
			{/if}
			
			
			{if $cartitems == 0}            
				<div class="emptycart">
					{$LANG.cartempty}
				</div>
			{else}
			
			{foreach $products as $num => $product}
				<div class="summary_products">
					<ul class="mb-0">
						<li>
							<span class="product-group">{$product.productinfo.groupname}</span>
							<span class="product-name">{$product.productinfo.name}</span>
							{if $product.domain}<span class="product-domain text-muted">{$product.domain}</span>{/if}
						</li>
						<li>{$product.pricing.baseprice}{if $product.proratadate}<br />({$LANG.orderprorata} {$product.proratadate}){/if}</li>
					</ul>
				</div>
			{/foreach}
			
			<div class="cart-contents collapse" id="CartContents">
			
				{foreach $products as $num => $product}
					<div class="summary_products">
						{if $product.configoptions}
							<div class="configurableoptions">
								{foreach key=confnum item=configoption from=$product.configoptions}
									<div class="list-item">
										<span class="item-name">&nbsp;&raquo; {$configoption.name}: {$configoption.optionname}</span>
										<span class="item-value">{$configoption.recurring} {* {if $configoption.setup} + {$configoption.setup} {$LANG.ordersetupfee}{/if} *}</span>
									</div>
								{/foreach}
							</div>
						{/if}
						{if $product.addons}
							<div class="pb-1 border-bottom fw-500 my-2">{$LANG.cartaddons}</div>
							{foreach $product.addons as $addonnum => $addon}
								<div class="list-item">
									<span class="item-name">{$addon.name}</span></li>
									<span class="item-value">{$addon.recurring}</span></li>
								</div>
							{/foreach}
						{/if}
					</div>
				{/foreach}
				
				{foreach $addons as $num => $addon}
					<div class="summary_addons">
						<div class="list-item">
							<span class="item-name"><strong>{$addon.name}</strong><br />{$addon.productname}{if $addon.domainname} - {$addon.domainname}{/if}</span>
							<span class="item-value">{$addon.recurring}</span>
						</div>
					</div>
				{/foreach}
				
				{foreach $domains as $num => $domain}
					<div class="summary_domains">
						<div class="clearfix">
							<span class="pull-left float-left">
								{if $domain.type eq "register"}{$LANG.orderdomainregistration}{else}{$LANG.orderdomaintransfer}{/if} - <br /><strong>{$domain.domain}</strong> - {$domain.regperiod} {$LANG.orderyears}<br />
								{if $domain.dnsmanagement}&nbsp;&raquo; {$LANG.domaindnsmanagement}<br />{/if}
								{if $domain.emailforwarding}&nbsp;&raquo; {$LANG.domainemailforwarding}<br />{/if}
								{if $domain.idprotection}&nbsp;&raquo; {$LANG.domainidprotection}<br />{/if}
							</span>
							<span class="pull-right float-right">{$domain.price}
								{if $domain.type eq "register"}
									<button type="button" class="btn btn-add-to-cart2 btn-icon btn-domain-remove px-2" data-whois="1" data-domain="{$domain.domain}"><i class="fas fa-trash bigger-120"></i></button>                                    
								{/if}
							</span>
						</div>
						{if $domain.type eq "register"}
							<div class="dropdown domainpricingarea mb-1">
								<button class="btn btn-primary btn-block btn-xs dropdown-toggle" type="button" id="{$domain.domain}Pricing" name="{$domain.domain}Pricing" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									{$domain.regperiod} {$domain.yearsLanguage}
									<span class="caret"></span>
								</button>
								<ul class="dropdown-menu w-100" aria-labelledby="{$domain.domain}Pricing">
									{foreach $domain.pricing as $years => $price}
										<li>
											<a href="#" class="dropdown-item" onclick="OPCselectDomainPeriodInCart('{$domain.domain}', '{$price.register}', {$years}, '{if $years == 1}{lang key='orderForm.year'}{else}{lang key='orderForm.years'}{/if}');
												return false;">
												{$years} {if $years == 1}{lang key='orderForm.year'}{else}{lang key='orderForm.years'}{/if} @ {$price.register}
											</a>
										</li>
									{/foreach}
								</ul>
							</div>
						{/if}
					</div>
				{/foreach}

				{foreach $renewalsByType['services'] as $num => $service}
					<div class="summary_domains">
						<ul>
							<li>
								<strong>{lang key='renewService.titleAltSingular'}</strong><br />{$service.name}<br /> <i>{$service.domainName} - {$service.billingCycle}</i>
							</li>
							<li>{$service.recurringBeforeTax}<br /></li>
						</ul>
					</div>
				{/foreach}

				{foreach $renewalsByType['addons'] as $num => $service}
					<div class="summary_domains">
						<ul>
							<li>
								<strong>{lang key='renewServiceAddon.titleAltSingular'}</strong><br />{$service.name}<br /> <i>{$service.domainName} - {$service.billingCycle}</i>
							</li>
							<li>{$service.recurringBeforeTax}<br /></li>
						</ul>
					</div>
				{/foreach}
		
				{foreach $renewalsByType['domains'] as $num => $domain}
					<div class="summary_domains">
						<ul>
							<li>
								<strong>{$LANG.domainrenewal}</strong><br /><i>{$domain.domain} - {$domain.regperiod} {$LANG.orderyears}</i><br />
								{if $domain.dnsmanagement}&nbsp;&raquo; {$LANG.domaindnsmanagement}<br />{/if}
								{if $domain.emailforwarding}&nbsp;&raquo; {$LANG.domainemailforwarding}<br />{/if}
								{if $domain.idprotection}&nbsp;&raquo; {$LANG.domainidprotection}<br />{/if}
							</li>
							<li>{$domain.price}</li>
						</ul>
					</div>
				{/foreach}

				{if $product.pricing.setup || $product.pricing.recurring || $product.pricing.addons}
					<div class="subtotal">
						{if $product.pricing.setup}
							<div class="clearfix">
								<span class="pull-left float-left">{$LANG.cartsetupfees}:</span>
								<span class="pull-right float-right">{$product.pricing.setup}</span>
							</div>
						{/if}	
						{foreach from=$product.pricing.recurringexcltax key=cycle item=recurring}
							<div class="clearfix">
								<span class="pull-left float-left text-muted">{$cycle}:</span>
								<span class="pull-right float-right text-muted">{$recurring}</span>
							</div>
						{/foreach}
					</div>
				{/if}

				<div class="subtotal">			
					<ul>
						<li>{$LANG.ordersubtotal}</li>
						<li>{$subtotal}</li>
					</ul>
				</div>

				{if $promotioncode}
					<div class="promotion">
						<ul>
							<li>{$promotiondescription}</li>
							<li>- {$discount}</li>
						</ul>
					</div>
				{/if}

				<div class="subtotal">			
					{if $taxrate}
						<ul>
							<li>{$taxname} @ {$taxrate}%</li>
							<li>{$taxtotal}</li>
						</ul>
					{/if}
					{if $taxrate2}
						<ul>
							<li>{$taxname2} @ {$taxrate2}%</li>
							<li>{$taxtotal2}</li>
						</ul>
					{/if}
				</div>
			</div>

			<div class="total">
				<div class="d-flex align-items-center">
					<button type="button" class="btn btn-cart-contents"><i class="fas fa-chevron-up"></i></button>
				</div>
				<ul>
					<li><span class="text-muted total-text">{$LANG.ordertotalduetoday}</span></li>
					<li>{$total}</li>
				</ul>
			</div>
			
			{/if}
			<div class="cart-loader">
				<i class="fad fa-circle-notch fa-spin fa-2x"></i>
			</div>
						
		</div>
		{*
		<div class="order_form_submit">
			<button type="submit" id="order_submit" class="btn btn-primary btn-block btn-lg"{if $cartitems == 0} disabled="disabled"{/if}><i class="fas fa-share"></i>&nbsp;{$LANG.completeorder}</button>			
		</div>
		*}
	</div>
{/if}